/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class GeneralTextBox
extends PropertyPage {
    private Text labeledText;
    private ColorSelector backgroundSelector;
    private ColorSelector textSelector;
    private ColorSelector borderSelector;
    private Button borderCheck;
    private Spinner fontSize;
    private NetworkMapTextBox textBox;
    private ObjectSelector drillDownObject;

    protected Control createContents(Composite parent) {
        this.textBox = (NetworkMapTextBox)this.getElement().getAdapter(NetworkMapTextBox.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.labeledText = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2050, (int)-1, (String)"Text", (String)this.textBox.getText(), (Object)gd);
        this.labeledText.setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.backgroundSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)"Background color", (Object)gd);
        this.backgroundSelector.setColorValue(ColorConverter.rgbFromInt((int)this.textBox.getBackgroundColor()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)"Text color", (Object)gd);
        this.textSelector.setColorValue(ColorConverter.rgbFromInt((int)this.textBox.getTextColor()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.borderSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)"Border color", (Object)gd);
        this.borderSelector.setColorValue(ColorConverter.rgbFromInt((int)this.textBox.getBorderColor()));
        this.borderCheck = new Button(dialogArea, 32);
        this.borderCheck.setText("Show border");
        this.borderCheck.setSelection(this.textBox.isBorderRequired());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.borderCheck.setLayoutData((Object)gd);
        this.borderCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTextBox.this.borderSelector.setEnabled(GeneralTextBox.this.borderCheck.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fontSize = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)"Text size", (int)1, (int)100, (Object)"WidgetHelper::default_layout_data");
        this.fontSize.setSelection(this.textBox.getFontSize());
        this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
        this.drillDownObject.setLabel("Drill-down object");
        this.drillDownObject.setObjectClass(AbstractObject.class);
        this.drillDownObject.setObjectId(this.textBox.getDrillDownObjectId());
        this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.drillDownObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    private boolean applyChanges(boolean isApply) {
        this.textBox.setText(this.labeledText.getText());
        this.textBox.setBackgroundColor(ColorConverter.rgbToInt((RGB)this.backgroundSelector.getColorValue()));
        this.textBox.setTextColor(ColorConverter.rgbToInt((RGB)this.textSelector.getColorValue()));
        this.textBox.setBorderRequired(this.borderCheck.getSelection());
        this.textBox.setBorderColor(ColorConverter.rgbToInt((RGB)this.borderSelector.getColorValue()));
        this.textBox.setFontSize(this.fontSize.getSelection());
        this.textBox.setDrillDownObjectId(this.drillDownObject.getObjectId());
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

