/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AgentActionResults
extends AbstractCommandResults
implements TextOutputListener {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.AgentActionResults";
    private IOConsoleOutputStream out;
    private String lastAction = null;
    private String[] lastArgs = null;
    private Action actionRestart;

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                AgentActionResults.this.executeAction(AgentActionResults.this.lastAction, AgentActionResults.this.lastArgs);
            }
        };
        this.actionRestart.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void executeAction(final String action, final String[] args) {
        this.actionRestart.setEnabled(false);
        final NXCSession session = ConsoleSharedData.getSession();
        this.out = this.console.newOutputStream();
        this.lastAction = action;
        this.lastArgs = args;
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, session.getObjectName(AgentActionResults.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    session.executeAction(AgentActionResults.this.nodeId, action, args, true, (TextOutputListener)AgentActionResults.this, null);
                    IOConsoleOutputStream iOConsoleOutputStream = AgentActionResults.this.out;
                    Messages.get();
                    iOConsoleOutputStream.write(Messages.LocalCommandResults_Terminated);
                }
                finally {
                    AgentActionResults.this.out.close();
                    AgentActionResults.this.out = null;
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentActionResults.this.actionRestart.setEnabled(true);
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text);
            }
        }
        catch (IOException iOException) {}
    }

    public void dispose() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
            this.out = null;
        }
        super.dispose();
    }

    public void setStreamId(long streamId) {
    }
}

