/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets.ansi;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.widgets.ansi.AnsiConsoleColorPalette;

public class AnsiConsoleAttributes
implements Cloneable {
    public static final int UNDERLINE_NONE = -1;
    private static ColorCache colorCache = new ColorCache();
    public Integer currentBgColor;
    public Integer currentFgColor;
    public int underline;
    public boolean bold;
    public boolean italic;
    public boolean invert;
    public boolean conceal;
    public boolean strike;
    public boolean framed;

    public static Color getDefaultBackgroundColor() {
        return colorCache.create(0, 0, 0);
    }

    public AnsiConsoleAttributes() {
        this.reset();
    }

    public void reset() {
        this.currentBgColor = null;
        this.currentFgColor = null;
        this.underline = -1;
        this.bold = false;
        this.italic = false;
        this.invert = false;
        this.conceal = false;
        this.strike = false;
        this.framed = false;
    }

    public AnsiConsoleAttributes clone() {
        AnsiConsoleAttributes result = new AnsiConsoleAttributes();
        result.currentBgColor = this.currentBgColor;
        result.currentFgColor = this.currentFgColor;
        result.underline = this.underline;
        result.bold = this.bold;
        result.italic = this.italic;
        result.invert = this.invert;
        result.conceal = this.conceal;
        result.strike = this.strike;
        result.framed = this.framed;
        return result;
    }

    public static Color hiliteRgbColor(Color c) {
        if (c == null) {
            return colorCache.create(new RGB(255, 255, 255));
        }
        int red = c.getRed() * 2;
        int green = c.getGreen() * 2;
        int blue = c.getBlue() * 2;
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return colorCache.create(new RGB(red, green, blue));
    }

    public static void updateRangeStyle(StyleRange range, AnsiConsoleAttributes attribute) {
        AnsiConsoleAttributes tempAttrib = attribute.clone();
        boolean hilite = false;
        if (tempAttrib.bold) {
            tempAttrib.bold = false;
            hilite = true;
        }
        if (tempAttrib.italic) {
            tempAttrib.italic = false;
            tempAttrib.invert = true;
        }
        if (hilite) {
            if (tempAttrib.currentFgColor == null) {
                range.foreground = colorCache.create(192, 192, 192);
                range.foreground = AnsiConsoleAttributes.hiliteRgbColor(range.foreground);
            } else {
                range.foreground = tempAttrib.currentFgColor < 8 ? new Color(null, AnsiConsoleColorPalette.getColor(tempAttrib.currentFgColor + 8)) : new Color(null, AnsiConsoleColorPalette.getColor(tempAttrib.currentFgColor));
            }
        } else if (tempAttrib.currentFgColor != null) {
            range.foreground = new Color(null, AnsiConsoleColorPalette.getColor(tempAttrib.currentFgColor));
        }
        if (tempAttrib.currentBgColor != null) {
            range.background = new Color(null, AnsiConsoleColorPalette.getColor(tempAttrib.currentBgColor));
        }
        if (tempAttrib.invert) {
            if (range.foreground == null) {
                range.foreground = colorCache.create(192, 192, 192);
            }
            if (range.background == null) {
                range.background = colorCache.create(0, 0, 0);
            }
            Color tmp = range.background;
            range.background = range.foreground;
            range.foreground = tmp;
        }
        if (tempAttrib.conceal) {
            if (range.background == null) {
                range.background = colorCache.create(0, 0, 0);
            }
            range.foreground = range.background;
        }
        range.font = null;
        range.fontStyle = 0;
        if (tempAttrib.bold) {
            range.fontStyle |= 1;
        }
        if (tempAttrib.italic) {
            range.fontStyle |= 2;
        }
        if (tempAttrib.underline != -1) {
            range.underline = true;
            range.underlineColor = range.foreground;
            range.underlineStyle = tempAttrib.underline;
        } else {
            range.underline = false;
        }
        range.strikeout = tempAttrib.strike;
        range.strikeoutColor = range.foreground;
        if (tempAttrib.framed) {
            range.borderStyle = 1;
            range.borderColor = range.foreground;
        } else {
            range.borderStyle = 0;
        }
    }
}

