/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.actions;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ShowHistoryGraph
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private Object[] currentSelection = null;
    private long uniqueId = 0L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        if (this.currentSelection != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.uniqueId++);
            int i = 0;
            while (i < this.currentSelection.length) {
                if (this.currentSelection[i] instanceof DciValue) {
                    sb.append("&");
                    sb.append(Integer.toString((DciValue)this.currentSelection[i] instanceof SimpleDciValue ? 1 : 2));
                    sb.append("@");
                    sb.append(Long.toString(((DciValue)this.currentSelection[i]).getNodeId()));
                    sb.append("@");
                    sb.append(Long.toString(((DciValue)this.currentSelection[i]).getId()));
                    sb.append("@");
                    try {
                        sb.append(URLEncoder.encode(((DciValue)this.currentSelection[i]).getDescription(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Messages.get();
                        sb.append(Messages.ShowHistoryGraph_DescriptionUnavailable);
                    }
                    sb.append("@");
                    try {
                        sb.append(URLEncoder.encode(((DciValue)this.currentSelection[i]).getName(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        sb.append("<name unavailable>");
                    }
                } else if (this.currentSelection[i] instanceof DataCollectionItem) {
                    sb.append("&");
                    sb.append(Integer.toString(1));
                    sb.append("@");
                    sb.append(Long.toString(((DataCollectionItem)this.currentSelection[i]).getNodeId()));
                    sb.append("@");
                    sb.append(Long.toString(((DataCollectionItem)this.currentSelection[i]).getId()));
                    sb.append("@");
                    try {
                        sb.append(URLEncoder.encode(((DataCollectionItem)this.currentSelection[i]).getDescription(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Messages.get();
                        sb.append(Messages.ShowHistoryGraph_DescriptionUnavailable);
                    }
                    sb.append("@");
                    try {
                        sb.append(URLEncoder.encode(((DataCollectionItem)this.currentSelection[i]).getName(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        sb.append("<name unavailable>");
                    }
                }
                ++i;
            }
            try {
                this.window.getActivePage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", sb.toString(), 1);
            }
            catch (PartInitException e) {
                Shell shell = this.window.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.ShowHistoryGraph_Error, (String)String.format(Messages.ShowHistoryGraph_ErrorOpeningView, e.getLocalizedMessage()));
            }
            catch (IllegalArgumentException e) {
                Shell shell = this.window.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.ShowHistoryGraph_Error, (String)String.format(Messages.ShowHistoryGraph_ErrorOpeningView, e.getLocalizedMessage()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        this.currentSelection = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof DciValue || element instanceof DataCollectionItem ? ((IStructuredSelection)selection).toArray() : null) : null;
        action.setEnabled(this.currentSelection != null && this.currentSelection.length > 0);
    }
}

