/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.widgets.BaseTableValueViewer;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class TableValueViewer
extends BaseTableValueViewer {
    private static long uniqueId = 1L;
    private long objectId = 0L;
    private long dciId = 0L;
    private String objectName = null;
    private Action actionShowHistory;
    private Action actionShowLineChart;
    private Action actionShowBarChart;
    private Action actionShowPieChart;

    public TableValueViewer(Composite parent, int style, IViewPart viewPart, String configSubId) {
        super(parent, style, viewPart, configSubId);
    }

    @Override
    protected String buildConfigId(String configSubId) {
        StringBuilder sb = new StringBuilder("TableLastValues.");
        sb.append(this.dciId);
        if (configSubId != null) {
            sb.append('.');
            sb.append(configSubId);
        }
        return sb.toString();
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.actionShowHistory = new Action("History", Activator.getImageDescriptor("icons/data_history.gif")){

            public void run() {
                TableValueViewer.this.showHistory();
            }
        };
        Messages.get();
        this.actionShowLineChart = new Action(Messages.TableValue_LineChart, Activator.getImageDescriptor("icons/chart_line.png")){

            public void run() {
                TableValueViewer.this.showLineChart();
            }
        };
        Messages.get();
        this.actionShowBarChart = new Action(Messages.TableValue_BarChart, Activator.getImageDescriptor("icons/chart_bar.png")){

            public void run() {
                TableValueViewer.this.showDataComparisonChart(0);
            }
        };
        Messages.get();
        this.actionShowPieChart = new Action(Messages.TableValue_PieChart, Activator.getImageDescriptor("icons/chart_pie.png")){

            public void run() {
                TableValueViewer.this.showDataComparisonChart(1);
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowHistory);
        manager.add((IAction)this.actionShowLineChart);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void setObject(long objectId, long dciId) {
        this.objectId = objectId;
        this.dciId = dciId;
        this.objectName = this.session.getObjectName(objectId);
    }

    private void showHistory() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            String id = String.valueOf(Long.toString(this.objectId)) + "&" + Long.toString(this.dciId) + "@" + TableValueViewer.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableValueViewer.safeEncode(instance) + "@" + TableValueViewer.safeEncode(column.getName());
            IWorkbenchPage page = this.viewPart != null ? this.viewPart.getSite().getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.showView("org.netxms.ui.eclipse.perfview.views.HistoricalDataView", id, 1);
            }
            catch (Exception e) {
                Shell shell = page.getWorkbenchWindow().getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.TableValue_Error, (String)String.format(Messages.TableValue_ErrorOpeningView, e.getLocalizedMessage()));
            }
            ++i;
        }
    }

    private void showLineChart() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uniqueId++);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            sb.append("&");
            sb.append(2);
            sb.append("@");
            sb.append(this.objectId);
            sb.append("@");
            sb.append(this.dciId);
            sb.append("@");
            sb.append(TableValueViewer.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")));
            sb.append("@");
            sb.append(TableValueViewer.safeEncode(instance));
            sb.append("@");
            sb.append(TableValueViewer.safeEncode(column.getName()));
            ++i;
        }
        IWorkbenchPage page = this.viewPart != null ? this.viewPart.getSite().getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", sb.toString(), 1);
        }
        catch (Exception e) {
            Shell shell = page.getWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.TableValue_Error, (String)String.format(Messages.TableValue_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private void showDataComparisonChart(int chartType) {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        String id = String.valueOf(Long.toString(uniqueId++)) + "&" + Integer.toString(chartType);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            int source = this.currentData.getSource();
            id = String.valueOf(id) + "&" + Long.toString(this.objectId) + "@" + Long.toString(this.dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(column.getDataType()) + "@" + TableValueViewer.safeEncode(this.currentData.getTitle()) + "@" + TableValueViewer.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableValueViewer.safeEncode(instance) + "@" + TableValueViewer.safeEncode(column.getName());
            ++i;
        }
        IWorkbenchPage page = this.viewPart != null ? this.viewPart.getSite().getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.perfview.views.DataComparisionView", id, 1);
        }
        catch (Exception e) {
            Shell shell = page.getWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.TableValue_Error, (String)String.format(Messages.TableValue_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private static String safeEncode(String text) {
        if (text == null) {
            return "";
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "none";
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "[" + this.dciId + "]";
    }

    @Override
    protected Table readData() throws Exception {
        return this.session.getTableLastValues(this.objectId, this.dciId);
    }

    @Override
    protected String getReadJobName() {
        Messages.get();
        return String.format(Messages.TableValue_JobName, this.dciId);
    }

    @Override
    protected String getReadJobErrorMessage() {
        Messages.get();
        return String.format(Messages.TableValue_JobError, this.dciId);
    }
}

