/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverjobmanager.views.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.server.ServerJob;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.serverjobmanager.Activator;
import org.netxms.ui.eclipse.serverjobmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerJobLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Map<Integer, String> statusTexts = new HashMap<Integer, String>(5);
    private Map<Integer, Image> statusImages = new HashMap<Integer, Image>(5);

    public ServerJobLabelProvider() {
        this.session = ConsoleSharedData.getSession();
        Integer n = 1;
        Messages.get();
        this.statusTexts.put(n, Messages.ServerJobLabelProvider_Active);
        Integer n2 = 6;
        Messages.get();
        this.statusTexts.put(n2, Messages.ServerJobLabelProvider_CancelPending);
        Integer n3 = 5;
        Messages.get();
        this.statusTexts.put(n3, Messages.ServerJobLabelProvider_Cancelled);
        Integer n4 = 3;
        Messages.get();
        this.statusTexts.put(n4, Messages.ServerJobLabelProvider_Completed);
        Integer n5 = 4;
        Messages.get();
        this.statusTexts.put(n5, Messages.ServerJobLabelProvider_Failed);
        Integer n6 = 2;
        Messages.get();
        this.statusTexts.put(n6, Messages.ServerJobLabelProvider_OnHold);
        Integer n7 = 0;
        Messages.get();
        this.statusTexts.put(n7, Messages.ServerJobLabelProvider_Pending);
        this.statusImages.put(1, Activator.getImageDescriptor("icons/active.gif").createImage());
        this.statusImages.put(6, Activator.getImageDescriptor("icons/cancel_pending.png").createImage());
        this.statusImages.put(5, Activator.getImageDescriptor("icons/cancel.png").createImage());
        this.statusImages.put(3, Activator.getImageDescriptor("icons/completed.gif").createImage());
        this.statusImages.put(4, Activator.getImageDescriptor("icons/failed.png").createImage());
        this.statusImages.put(2, Activator.getImageDescriptor("icons/hold.gif").createImage());
        this.statusImages.put(0, Activator.getImageDescriptor("icons/pending.gif").createImage());
    }

    public String getColumnText(Object obj, int index) {
        if (obj instanceof ServerJob) {
            switch (index) {
                case 0: {
                    return this.statusTexts.get(((ServerJob)obj).getStatus());
                }
                case 1: {
                    String string;
                    AbstractUserObject user = this.session.findUserDBObjectById(((ServerJob)obj).getUserId());
                    if (user != null) {
                        string = user.getName();
                    } else {
                        Messages.get();
                        string = Messages.ServerJobLabelProvider_Unknown;
                    }
                    return string;
                }
                case 2: {
                    String string;
                    AbstractObject object = this.session.findObjectById(((ServerJob)obj).getNodeId());
                    if (object != null) {
                        string = object.getObjectName();
                    } else {
                        Messages.get();
                        string = Messages.ServerJobLabelProvider_Unknown;
                    }
                    return string;
                }
                case 3: {
                    return ((ServerJob)obj).getDescription();
                }
                case 4: {
                    return ((ServerJob)obj).getStatus() == 1 ? String.valueOf(Integer.toString(((ServerJob)obj).getProgress())) + "%" : "";
                }
                case 5: {
                    return ((ServerJob)obj).getFailureMessage();
                }
            }
        }
        return "";
    }

    public void dispose() {
        for (Image image : this.statusImages.values()) {
            image.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object obj) {
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof ServerJob) || columnIndex != 0) {
            return null;
        }
        return this.statusImages.get(((ServerJob)element).getStatus());
    }
}

