/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListLabelProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfacesTabFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class InterfacesTab
extends ObjectTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_ALIAS = 2;
    public static final int COLUMN_TYPE = 3;
    public static final int COLUMN_INDEX = 4;
    public static final int COLUMN_SLOT = 5;
    public static final int COLUMN_PORT = 6;
    public static final int COLUMN_MTU = 7;
    public static final int COLUMN_SPEED = 8;
    public static final int COLUMN_DESCRIPTION = 9;
    public static final int COLUMN_MAC_ADDRESS = 10;
    public static final int COLUMN_IP_ADDRESS = 11;
    public static final int COLUMN_VLAN = 12;
    public static final int COLUMN_PEER_NAME = 13;
    public static final int COLUMN_PEER_MAC_ADDRESS = 14;
    public static final int COLUMN_PEER_IP_ADDRESS = 15;
    public static final int COLUMN_PEER_PROTOCOL = 16;
    public static final int COLUMN_ADMIN_STATE = 17;
    public static final int COLUMN_OPER_STATE = 18;
    public static final int COLUMN_EXPECTED_STATE = 19;
    public static final int COLUMN_STATUS = 20;
    public static final int COLUMN_8021X_PAE_STATE = 21;
    public static final int COLUMN_8021X_BACKEND_STATE = 22;
    private SortableTableViewer viewer;
    private InterfaceListLabelProvider labelProvider;
    private SessionListener sessionListener = null;
    private Action actionCopyToClipboard;
    private Action actionCopyMacAddressToClipboard;
    private Action actionCopyIpAddressToClipboard;
    private Action actionCopyPeerNameToClipboard;
    private Action actionCopyPeerMacToClipboard;
    private Action actionCopyPeerIpToClipboard;
    private Action actionExportToCsv;
    private boolean showFilter = true;
    private boolean hideSubInterfaces = false;
    private FilterText filterText;
    private InterfacesTabFilter filter;
    private Composite interfacesArea;

    @Override
    protected void createTabContent(Composite parent) {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.showFilter = InterfacesTab.safeCast(settings.get("InterfacesTab.showFilter"), settings.getBoolean("InterfacesTab.showFilter"), this.showFilter);
        this.hideSubInterfaces = InterfacesTab.safeCast(settings.get("InterfacesTab.hideSubInterfaces"), settings.getBoolean("InterfacesTab.hideSubInterfaces"), this.hideSubInterfaces);
        this.interfacesArea = new Composite(parent, 2048);
        FormLayout formLayout = new FormLayout();
        this.interfacesArea.setLayout((Layout)formLayout);
        this.filterText = new FilterText(this.interfacesArea, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfacesTab.this.onFilterModify();
            }
        });
        this.filterText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("InterfacesTab.showFilter", InterfacesTab.this.showFilter);
                settings.put("InterfacesTab.hideSubInterfaces", InterfacesTab.this.hideSubInterfaces);
            }
        });
        Action action = new Action(){

            public void run() {
                InterfacesTab.this.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
                State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        };
        this.setFilterCloseAction(action);
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
        State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
        state.setValue((Object)this.showFilter);
        service.refreshElements(command.getId(), null);
        command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.hideSubInterfaces");
        state = command.getState("org.netxms.ui.eclipse.objectview.commands.hideSubInterfaces.state");
        state.setValue((Object)this.hideSubInterfaces);
        service.refreshElements(command.getId(), null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        String[] stringArray = new String[23];
        Messages.get();
        stringArray[0] = Messages.InterfacesTab_ColId;
        Messages.get();
        stringArray[1] = Messages.InterfacesTab_ColName;
        Messages.get();
        stringArray[2] = Messages.InterfacesTab_Alias;
        Messages.get();
        stringArray[3] = Messages.InterfacesTab_ColIfType;
        Messages.get();
        stringArray[4] = Messages.InterfacesTab_ColIfIndex;
        Messages.get();
        stringArray[5] = Messages.InterfacesTab_ColSlot;
        Messages.get();
        stringArray[6] = Messages.InterfacesTab_ColPort;
        Messages.get();
        stringArray[7] = Messages.InterfacesTab_MTU;
        Messages.get();
        stringArray[8] = Messages.InterfacesTab_Speed;
        Messages.get();
        stringArray[9] = Messages.InterfacesTab_ColDescription;
        Messages.get();
        stringArray[10] = Messages.InterfacesTab_ColMacAddr;
        Messages.get();
        stringArray[11] = Messages.InterfacesTab_ColIpAddr;
        stringArray[12] = "VLAN";
        Messages.get();
        stringArray[13] = Messages.InterfacesTab_ColPeerNode;
        Messages.get();
        stringArray[14] = Messages.InterfacesTab_ColPeerMAC;
        Messages.get();
        stringArray[15] = Messages.InterfacesTab_ColPeerIP;
        Messages.get();
        stringArray[16] = Messages.InterfacesTab_PeerDiscoveryProtocol;
        Messages.get();
        stringArray[17] = Messages.InterfacesTab_ColAdminState;
        Messages.get();
        stringArray[18] = Messages.InterfacesTab_ColOperState;
        Messages.get();
        stringArray[19] = Messages.InterfacesTab_ColExpState;
        Messages.get();
        stringArray[20] = Messages.InterfacesTab_ColStatus;
        Messages.get();
        stringArray[21] = Messages.InterfacesTab_Col8021xPAE;
        Messages.get();
        stringArray[22] = Messages.InterfacesTab_Col8021xBackend;
        String[] names = stringArray;
        int[] widths = new int[]{60, 150, 150, 150, 70, 70, 70, 70, 90, 150, 100, 90, 80, 150, 100, 90, 80, 80, 80, 80, 80, 80, 80};
        this.viewer = new SortableTableViewer(this.interfacesArea, names, widths, 1, 128, 65538);
        this.labelProvider = new InterfaceListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new InterfaceListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.filter = new InterfacesTabFilter();
        this.filter.setHideSubInterfaces(this.hideSubInterfaces);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable.V5");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)InterfacesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable.V5");
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText, 0, 1024);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        this.createActions();
        this.createPopupMenu();
        if (this.showFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                AbstractObject object;
                if (n.getCode() == 4 && (object = (AbstractObject)n.getObject()) != null && object instanceof Interface && InterfacesTab.this.getObject() != null && object.isDirectChildOf(InterfacesTab.this.getObject().getObjectId())) {
                    InterfacesTab.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            InterfacesTab.this.refresh();
                        }
                    });
                }
            }
        };
        ConsoleSharedData.getSession().addListener(this.sessionListener);
    }

    @Override
    public void dispose() {
        ConsoleSharedData.getSession().removeListener(this.sessionListener);
        super.dispose();
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    private void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }

    public void enableFilter(boolean enable) {
        this.showFilter = enable;
        this.filterText.setVisible(this.showFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.interfacesArea.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private void createActions() {
        Messages.get();
        this.actionCopyToClipboard = new Action(Messages.InterfacesTab_ActionCopy, SharedIcons.COPY){

            public void run() {
                InterfacesTab.this.copyToClipboard(-1);
            }
        };
        Messages.get();
        this.actionCopyMacAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyMAC){

            public void run() {
                InterfacesTab.this.copyToClipboard(10);
            }
        };
        Messages.get();
        this.actionCopyIpAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(11);
            }
        };
        Messages.get();
        this.actionCopyPeerNameToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerName){

            public void run() {
                InterfacesTab.this.copyToClipboard(13);
            }
        };
        Messages.get();
        this.actionCopyPeerMacToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerMAC){

            public void run() {
                InterfacesTab.this.copyToClipboard(14);
            }
        };
        Messages.get();
        this.actionCopyPeerIpToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(15);
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this.getViewPart(), (ColumnViewer)this.viewer, true);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                InterfacesTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.getViewPart() != null) {
            this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionCopyMacAddressToClipboard);
        manager.add((IAction)this.actionCopyIpAddressToClipboard);
        manager.add((IAction)this.actionCopyPeerNameToClipboard);
        manager.add((IAction)this.actionCopyPeerMacToClipboard);
        manager.add((IAction)this.actionCopyPeerIpToClipboard);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this.viewer);
    }

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.objectChanged(object);
    }

    @Override
    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChilds(3).toArray());
        } else {
            this.viewer.setInput((Object)new Interface[0]);
        }
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.labelProvider.setNode((AbstractNode)object);
        this.refresh();
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    private void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    int j = 0;
                    while (j < this.viewer.getTable().getColumnCount()) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                        ++j;
                    }
                } else {
                    sb.append(selection[i].getText(column));
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    @Override
    public void selected() {
        super.selected();
        this.refresh();
    }

    public void hideSubInterfaces(boolean hide) {
        this.hideSubInterfaces = hide;
        this.filter.setHideSubInterfaces(hide);
        this.viewer.refresh();
    }
}

