/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCategoryList;

public class AlarmCategoryConfigurator
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.view.alarm_category_configurator";
    private static final String TABLE_CONFIG_PREFIX = "AlarmCategoryConfigurator";
    private AlarmCategoryList dataView;
    private Action actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setPartName("Alarm Category Configuration");
    }

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.dataView = new AlarmCategoryList(this, parent, 0, TABLE_CONFIG_PREFIX, true);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.dataView.setLayoutData(fd);
        this.dataView.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AlarmCategoryConfigurator.this.dataView.editCategory();
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.alarmviewer.context.AlarmCategoryConfigurator");
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.dataView.getAddCategoryAction());
        manager.add((IAction)this.dataView.getDeleteCategoryAction());
        manager.add((IAction)this.dataView.getEditCategoryAction());
        manager.add((IAction)this.dataView.getShowFilterAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.dataView.getAddCategoryAction());
        manager.add((IAction)this.dataView.getDeleteCategoryAction());
        manager.add((IAction)this.dataView.getEditCategoryAction());
        manager.add((IAction)this.dataView.getShowFilterAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                AlarmCategoryConfigurator.this.dataView.refreshView();
            }
        };
        handlerService.activateHandler(this.dataView.getShowFilterAction().getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.dataView.getShowFilterAction()));
    }

    public void setFocus() {
        this.dataView.setFocus();
    }
}

