/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.propertypages.helpers.RackView;
import org.netxms.ui.eclipse.dashboard.widgets.internal.RackDiagramConfig;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class RackDiagram
extends PropertyPage {
    private static final String[] RACK_VIEWS = new String[]{"Full", "Front", "Back"};
    private RackDiagramConfig config;
    private ObjectSelector objectSelector;
    private LabeledText title;
    private Button showTitle;
    private Combo view;

    protected Control createContents(Composite parent) {
        this.config = (RackDiagramConfig)this.getElement().getAdapter(RackDiagramConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false);
        this.objectSelector.setLabel("Rack");
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createRackSelectionFilter());
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel("Title");
        this.title.setText(this.config.getTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.view = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"View", (Object)gd);
        this.view.setItems(RACK_VIEWS);
        this.view.setText(RACK_VIEWS[this.config.getView().getValue()]);
        this.showTitle = new Button(dialogArea, 32);
        this.showTitle.setText("Show title");
        this.showTitle.setSelection(this.config.isShowTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.showTitle.setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setTitle(this.title.getText());
        this.config.setShowTitle(this.showTitle.getSelection());
        this.config.setView(RackView.getByValue(this.view.getSelectionIndex()));
        return true;
    }
}

