/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.configs;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="config", strict=false)
public class LinkConfig {
    public static final int COLOR_SOURCE_UNDEFINED = -1;
    public static final int COLOR_SOURCE_DEFAULT = 0;
    public static final int COLOR_SOURCE_OBJECT_STATUS = 1;
    public static final int COLOR_SOURCE_CUSTOM_COLOR = 2;
    @ElementArray(required=false)
    private SingleDciConfig[] dciList;
    @ElementList(required=false)
    private List<Long> objectStatusList = new ArrayList<Long>();
    @Element(required=false)
    private int color;
    @Element(required=false)
    private int routing;
    @Element(required=false)
    private long[] bendPoints;
    @Element(required=false)
    private boolean useActiveThresholds;
    @Element(required=false)
    private boolean isLocked;
    @Element(required=false)
    private int colorSource;

    public LinkConfig() {
        this.color = -1;
        this.colorSource = -1;
        this.routing = 0;
        this.bendPoints = null;
        this.dciList = null;
        this.useActiveThresholds = false;
        this.isLocked = false;
    }

    public LinkConfig(SingleDciConfig[] dciList, List<Long> objectStatusList, int colorSource, int color, int routing, long[] bendPoints, boolean useActiveThresholds, boolean isLocked) {
        this.dciList = dciList;
        this.objectStatusList = objectStatusList;
        this.colorSource = colorSource;
        this.color = color;
        this.routing = routing;
        this.bendPoints = bendPoints;
        this.useActiveThresholds = useActiveThresholds;
        this.isLocked = isLocked;
    }

    public static LinkConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (LinkConfig)((Object)serializer.read(LinkConfig.class, xml));
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, writer);
        return ((Object)writer).toString();
    }

    public List<Long> getObjectStatusList() {
        return this.objectStatusList != null ? this.objectStatusList : new ArrayList(0);
    }

    public void setObjectStatusList(List<Long> objectStatusList) {
        this.objectStatusList = objectStatusList;
    }

    public SingleDciConfig[] getDciList() {
        return this.dciList;
    }

    public void setDciList(SingleDciConfig[] dciList) {
        this.dciList = dciList;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getRouting() {
        return this.routing;
    }

    public void setRouting(int routing) {
        this.routing = routing;
    }

    public long[] getBendPoints() {
        return this.bendPoints;
    }

    public void setBendPoints(long[] bendPoints) {
        this.bendPoints = bendPoints;
    }

    public void setUseActiveThresholds(boolean useActiveThresholds) {
        this.useActiveThresholds = useActiveThresholds;
    }

    public boolean isUseActiveThresholds() {
        return this.useActiveThresholds;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public int getColorSource() {
        if (this.colorSource == -1) {
            if (this.objectStatusList != null && !this.objectStatusList.isEmpty()) {
                return 1;
            }
            return this.color >= 0 ? 2 : 0;
        }
        return this.colorSource;
    }

    public void setColorSource(int colorSource) {
        this.colorSource = colorSource;
    }

    public String toString() {
        return "LinkConfig [dciList=" + Arrays.toString(this.dciList) + ", objectStatusList=" + this.objectStatusList.toString() + ", color=" + this.color + ", routing=" + this.routing + ", bendPoints=" + Arrays.toString(this.bendPoints) + "], isLocked=" + this.isLocked;
    }
}

