/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigDecimal;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinClassMethodNarrow;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat$real_descriptor;
import org.python.core.PyFloatDerived;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.stringlib.FloatFormatter;
import org.python.core.stringlib.InternalFormat;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.math;

@Untraversable
@ExposedType(name="float", doc="float(x) -> floating point number\n\nConvert a string or number to a floating point number, if possible.")
public class PyFloat
extends PyObject {
    public static final PyType TYPE;
    static final InternalFormat.Spec SPEC_REPR;
    static final InternalFormat.Spec SPEC_STR;
    static final PyFloat ZERO;
    static final PyFloat ONE;
    static final PyFloat NAN;
    private final double value;
    private static double INT_LONG_BOUNDARY;
    public static volatile Format double_format;
    public static volatile Format float_format;

    public double getValue() {
        return this.value;
    }

    public PyFloat(PyType subtype, double v) {
        super(subtype);
        this.value = v;
    }

    public PyFloat(double v) {
        this(TYPE, v);
    }

    public PyFloat(float v) {
        this((double)v);
    }

    @ExposedNew
    public static PyObject float_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("float", args, keywords, new String[]{"x"}, 0);
        PyObject x = ap.getPyObject(0, null);
        if (x == null) {
            if (new_.for_type == subtype) {
                return ZERO;
            }
            return new PyFloatDerived(subtype, 0.0);
        }
        PyFloat floatObject = null;
        try {
            floatObject = x.__float__();
        }
        catch (PyException e) {
            if (e.match(Py.AttributeError)) {
                throw Py.TypeError("float() argument must be a string or a number");
            }
            throw e;
        }
        if (new_.for_type == subtype) {
            return floatObject;
        }
        return new PyFloatDerived(subtype, floatObject.getValue());
    }

    public PyObject getReal() {
        return this.float___float__();
    }

    public PyObject getImag() {
        return ZERO;
    }

    public static PyObject float_fromhex(PyType type, PyObject o) {
        String message2 = "invalid hexadecimal floating-point string";
        boolean negative = false;
        PyString s = o.__str__();
        String value = s.getString().trim().toLowerCase();
        if (value.length() == 0) {
            throw Py.ValueError(message2);
        }
        if (value.equals("nan") || value.equals("-nan") || value.equals("+nan")) {
            return NAN;
        }
        if (value.equals("inf") || value.equals("infinity") || value.equals("+inf") || value.equals("+infinity")) {
            return new PyFloat(Double.POSITIVE_INFINITY);
        }
        if (value.equals("-inf") || value.equals("-infinity")) {
            return new PyFloat(Double.NEGATIVE_INFINITY);
        }
        if (value.charAt(0) == '-') {
            value = value.substring(1);
            negative = true;
        } else if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        if (value.length() == 0) {
            throw Py.ValueError(message2);
        }
        if (!value.startsWith("0x") && !value.startsWith("0X")) {
            value = "0x" + value;
        }
        if (negative) {
            value = "-" + value;
        }
        if (value.indexOf(112) == -1) {
            value = value + "p0";
        }
        try {
            double d = Double.parseDouble(value);
            if (Double.isInfinite(d)) {
                throw Py.OverflowError("hexadecimal value too large to represent as a float");
            }
            return new PyFloat(d);
        }
        catch (NumberFormatException n) {
            throw Py.ValueError(message2);
        }
    }

    private String pyHexString(Double f) {
        String java_hex = Double.toHexString(this.getValue());
        if (java_hex.equals("Infinity")) {
            return "inf";
        }
        if (java_hex.equals("-Infinity")) {
            return "-inf";
        }
        if (java_hex.equals("NaN")) {
            return "nan";
        }
        if (java_hex.equals("0x0.0p0")) {
            return "0x0.0p+0";
        }
        if (java_hex.equals("-0x0.0p0")) {
            return "-0x0.0p+0";
        }
        int len = java_hex.length();
        boolean start_exponent = false;
        StringBuilder py_hex = new StringBuilder(len + 1);
        int padding = f > 0.0 ? 17 : 18;
        for (int i = 0; i < len; ++i) {
            char c = java_hex.charAt(i);
            if (c == 'p') {
                for (int pad = i; pad < padding; ++pad) {
                    py_hex.append('0');
                }
                start_exponent = true;
            } else if (start_exponent) {
                if (c != '-') {
                    py_hex.append('+');
                }
                start_exponent = false;
            }
            py_hex.append(c);
        }
        return py_hex.toString();
    }

    public PyObject float_hex() {
        return new PyString(this.pyHexString(this.getValue()));
    }

    public boolean isFinite() {
        return !Double.isInfinite(this.getValue()) && !Double.isNaN(this.getValue());
    }

    @Override
    public String toString() {
        return this.__str__().toString();
    }

    @Override
    public PyString __str__() {
        return this.float___str__();
    }

    final PyString float___str__() {
        return Py.newString(this.formatDouble(SPEC_STR));
    }

    @Override
    public PyString __repr__() {
        return this.float___repr__();
    }

    final PyString float___repr__() {
        return Py.newString(this.formatDouble(SPEC_REPR));
    }

    private String formatDouble(InternalFormat.Spec spec) {
        FloatFormatter f = new FloatFormatter(spec);
        return f.format(this.value).getResult();
    }

    @Override
    public int hashCode() {
        return this.float___hash__();
    }

    final int float___hash__() {
        double value = this.getValue();
        if (Double.isInfinite(value)) {
            return value < 0.0 ? -271828 : 314159;
        }
        if (Double.isNaN(value)) {
            return 0;
        }
        double intPart = Math.floor(value);
        double fractPart = value - intPart;
        if (fractPart == 0.0) {
            if (intPart <= 2.147483647E9 && intPart >= -2.147483648E9) {
                return (int)value;
            }
            return this.__long__().hashCode();
        }
        long v = Double.doubleToLongBits(this.getValue());
        return (int)v ^ (int)(v >> 32);
    }

    @Override
    public boolean __nonzero__() {
        return this.float___nonzero__();
    }

    final boolean float___nonzero__() {
        return this.getValue() != 0.0;
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c == Double.TYPE || c == Number.class || c == Double.class || c == Object.class || c == Serializable.class) {
            return new Double(this.getValue());
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.getValue());
        }
        return super.__tojava__(c);
    }

    @Override
    public PyObject __eq__(PyObject other) {
        if (Double.isNaN(this.getValue())) {
            return Py.False;
        }
        return null;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        if (Double.isNaN(this.getValue())) {
            return Py.True;
        }
        return null;
    }

    @Override
    public PyObject __gt__(PyObject other) {
        if (Double.isNaN(this.getValue())) {
            return Py.False;
        }
        return null;
    }

    @Override
    public PyObject __ge__(PyObject other) {
        if (Double.isNaN(this.getValue())) {
            return Py.False;
        }
        return null;
    }

    @Override
    public PyObject __lt__(PyObject other) {
        if (Double.isNaN(this.getValue())) {
            return Py.False;
        }
        return null;
    }

    @Override
    public PyObject __le__(PyObject other) {
        if (Double.isNaN(this.getValue())) {
            return Py.False;
        }
        return null;
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.float___cmp__(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int float___cmp__(PyObject other) {
        double j;
        double i = this.getValue();
        if (other instanceof PyFloat) {
            j = ((PyFloat)other).getValue();
        } else if (!this.isFinite()) {
            if (!(other instanceof PyInteger)) {
                if (!(other instanceof PyLong)) return -2;
            }
            j = 0.0;
        } else if (other instanceof PyInteger) {
            j = ((PyInteger)other).getValue();
        } else {
            if (!(other instanceof PyLong)) return -2;
            BigDecimal v = new BigDecimal(this.getValue());
            BigDecimal w = new BigDecimal(((PyLong)other).getValue());
            return v.compareTo(w);
        }
        if (i < j) {
            return -1;
        }
        if (i > j) {
            return 1;
        }
        if (i == j) {
            return 0;
        }
        if (!Double.isNaN(i)) return 1;
        if (!Double.isNaN(j)) return -1;
        return 1;
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        return this.float___coerce_ex__(other);
    }

    final PyObject float___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.float___coerce_ex__(other));
    }

    final Object float___coerce_ex__(PyObject other) {
        if (other instanceof PyFloat) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)other).getValue());
        }
        if (other instanceof PyLong) {
            return new PyFloat(((PyLong)other).doubleValue());
        }
        return Py.None;
    }

    private static boolean canCoerce(PyObject other) {
        return other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private static double coerce(PyObject other) {
        if (other instanceof PyFloat) {
            return ((PyFloat)other).getValue();
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        if (other instanceof PyLong) {
            return ((PyLong)other).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        return this.float___add__(right);
    }

    final PyObject float___add__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.getValue() + rightv);
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.float___radd__(left);
    }

    final PyObject float___radd__(PyObject left) {
        return this.__add__(left);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        return this.float___sub__(right);
    }

    final PyObject float___sub__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.getValue() - rightv);
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        return this.float___rsub__(left);
    }

    final PyObject float___rsub__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(leftv - this.getValue());
    }

    @Override
    public PyObject __mul__(PyObject right) {
        return this.float___mul__(right);
    }

    final PyObject float___mul__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.getValue() * rightv);
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.float___rmul__(left);
    }

    final PyObject float___rmul__(PyObject left) {
        return this.__mul__(left);
    }

    @Override
    public PyObject __div__(PyObject right) {
        return this.float___div__(right);
    }

    final PyObject float___div__(PyObject right) {
        double rightv;
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        if (Options.division_warning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        if ((rightv = PyFloat.coerce(right)) == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.getValue() / rightv);
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        return this.float___rdiv__(left);
    }

    final PyObject float___rdiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        if (Options.division_warning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        double leftv = PyFloat.coerce(left);
        if (this.getValue() == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.getValue());
    }

    @Override
    public PyObject __floordiv__(PyObject right) {
        return this.float___floordiv__(right);
    }

    final PyObject float___floordiv__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(this.getValue() / rightv));
    }

    @Override
    public PyObject __rfloordiv__(PyObject left) {
        return this.float___rfloordiv__(left);
    }

    final PyObject float___rfloordiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.getValue() == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(leftv / this.getValue()));
    }

    @Override
    public PyObject __truediv__(PyObject right) {
        return this.float___truediv__(right);
    }

    final PyObject float___truediv__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.getValue() / rightv);
    }

    @Override
    public PyObject __rtruediv__(PyObject left) {
        return this.float___rtruediv__(left);
    }

    final PyObject float___rtruediv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.getValue() == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.getValue());
    }

    private static double modulo(double x, double y) {
        if (y == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double z = x % y;
        if (z == 0.0) {
            return Math.copySign(z, y);
        }
        if (z > 0.0 == y > 0.0) {
            return z;
        }
        return z + y;
    }

    @Override
    public PyObject __mod__(PyObject right) {
        return this.float___mod__(right);
    }

    final PyObject float___mod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(PyFloat.modulo(this.getValue(), rightv));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        return this.float___rmod__(left);
    }

    final PyObject float___rmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(PyFloat.modulo(leftv, this.getValue()));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        return this.float___divmod__(right);
    }

    final PyObject float___divmod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(this.getValue() / rightv);
        return new PyTuple(new PyFloat(z), new PyFloat(this.getValue() - z * rightv));
    }

    @Override
    public PyObject __rdivmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.getValue() == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(leftv / this.getValue());
        return new PyTuple(new PyFloat(z), new PyFloat(leftv - z * this.getValue()));
    }

    final PyObject float___rdivmod__(PyObject left) {
        return this.__rdivmod__(left);
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.float___pow__(right, modulo);
    }

    final PyObject float___pow__(PyObject right, PyObject modulo) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        PyObject pyObject = modulo = modulo == Py.None ? null : modulo;
        if (modulo != null) {
            throw Py.TypeError("pow() 3rd argument not allowed unless all arguments are integers");
        }
        return PyFloat._pow(this.getValue(), PyFloat.coerce(right));
    }

    final PyObject float___rpow__(PyObject left) {
        return this.__rpow__(left);
    }

    @Override
    public PyObject __rpow__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(left), this.getValue());
    }

    private static PyFloat _pow(double v, double w) {
        if (w == 0.0) {
            return ONE;
        }
        if (Double.isNaN(v)) {
            return NAN;
        }
        if (Double.isNaN(w)) {
            if (v == 1.0) {
                return ONE;
            }
            return NAN;
        }
        if (Double.isInfinite(w)) {
            if (v == 1.0 || v == -1.0) {
                return ONE;
            }
        } else if (v == 0.0) {
            if (w < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
        } else if (!Double.isInfinite(v) && v < 0.0 && w != Math.floor(w)) {
            throw Py.ValueError("negative number cannot be raised to a fractional power");
        }
        return new PyFloat(Math.pow(v, w));
    }

    @Override
    public PyObject __neg__() {
        return this.float___neg__();
    }

    final PyObject float___neg__() {
        return new PyFloat(-this.getValue());
    }

    @Override
    public PyObject __pos__() {
        return this.float___pos__();
    }

    final PyObject float___pos__() {
        return this.float___float__();
    }

    @Override
    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    @Override
    public PyObject __abs__() {
        return this.float___abs__();
    }

    final PyObject float___abs__() {
        return new PyFloat(Math.abs(this.getValue()));
    }

    @Override
    public PyObject __int__() {
        return this.float___int__();
    }

    final PyObject float___int__() {
        double v = this.getValue();
        if (v < INT_LONG_BOUNDARY && v > -(INT_LONG_BOUNDARY + 1.0)) {
            return new PyInteger((int)v);
        }
        return this.__long__();
    }

    @Override
    public PyObject __long__() {
        return this.float___long__();
    }

    final PyObject float___long__() {
        return new PyLong(this.getValue());
    }

    @Override
    public PyFloat __float__() {
        return this.float___float__();
    }

    final PyFloat float___float__() {
        return this.getType() == TYPE ? this : Py.newFloat(this.getValue());
    }

    @Override
    public PyObject __trunc__() {
        return this.float___trunc__();
    }

    final PyObject float___trunc__() {
        if (Double.isNaN(this.value)) {
            throw Py.ValueError("cannot convert float NaN to integer");
        }
        if (Double.isInfinite(this.value)) {
            throw Py.OverflowError("cannot convert float infinity to integer");
        }
        if (this.value < 2.147483647E9) {
            return new PyInteger((int)this.value);
        }
        if (this.value < 9.223372036854776E18) {
            return new PyLong((long)this.value);
        }
        BigDecimal d = new BigDecimal(this.value);
        return new PyLong(d.toBigInteger());
    }

    @Override
    public PyObject conjugate() {
        return this.float_conjugate();
    }

    final PyObject float_conjugate() {
        return this;
    }

    public boolean is_integer() {
        return this.float_is_integer();
    }

    final boolean float_is_integer() {
        if (Double.isInfinite(this.value)) {
            return false;
        }
        return Math.floor(this.value) == this.value;
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.getValue(), 0.0);
    }

    final PyTuple float___getnewargs__() {
        return new PyTuple(new PyFloat(this.getValue()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.float___getnewargs__();
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.float___format__(formatSpec);
    }

    final PyObject float___format__(PyObject formatSpec) {
        InternalFormat.Spec spec = InternalFormat.fromText(formatSpec, "__format__");
        FloatFormatter f = PyFloat.prepareFormatter(spec);
        if (f != null) {
            f.setBytes(!(formatSpec instanceof PyUnicode));
            f.format(this.value);
            return f.pad().getPyResult();
        }
        throw InternalFormat.Formatter.unknownFormat(spec.type, "float");
    }

    static FloatFormatter prepareFormatter(InternalFormat.Spec spec) {
        switch (spec.type) {
            case 'n': {
                if (spec.grouping) {
                    throw InternalFormat.Formatter.notAllowed("Grouping", "float", spec.type);
                }
            }
            case '%': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'e': 
            case 'f': 
            case 'g': 
            case '\uffff': {
                if (spec.alternate) {
                    throw FloatFormatter.alternateFormNotAllowed("float");
                }
                spec = spec.withDefaults(InternalFormat.Spec.NUMERIC);
                return new FloatFormatter(spec);
            }
        }
        return null;
    }

    public PyTuple as_integer_ratio() {
        if (Double.isInfinite(this.value)) {
            throw Py.OverflowError("Cannot pass infinity to float.as_integer_ratio.");
        }
        if (Double.isNaN(this.value)) {
            throw Py.ValueError("Cannot pass NaN to float.as_integer_ratio.");
        }
        PyTuple frexp = math.frexp(this.value);
        double float_part = (Double)frexp.get(0);
        int exponent = (Integer)frexp.get(1);
        for (int i = 0; i < 300 && float_part != Math.floor(float_part); ++i) {
            float_part *= 2.0;
            --exponent;
        }
        PyLong numerator = new PyLong(float_part);
        PyLong denominator = new PyLong(1L);
        PyLong py_exponent = new PyLong(Math.abs(exponent));
        py_exponent = (PyLong)denominator.__lshift__(py_exponent);
        if (exponent > 0) {
            numerator = new PyLong(numerator.getValue().multiply(py_exponent.getValue()));
        } else {
            denominator = py_exponent;
        }
        return new PyTuple(numerator, denominator);
    }

    @Override
    public double asDouble() {
        return this.getValue();
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    public static String float___getformat__(PyType type, String typestr) {
        if ("double".equals(typestr)) {
            return double_format.format();
        }
        if ("float".equals(typestr)) {
            return float_format.format();
        }
        throw Py.ValueError("__getformat__() argument 1 must be 'double' or 'float'");
    }

    public static void float___setformat__(PyType type, String typestr, String format) {
        Format new_format = null;
        if (!"double".equals(typestr) && !"float".equals(typestr)) {
            throw Py.ValueError("__setformat__() argument 1 must be 'double' or 'float'");
        }
        if (Format.LE.format().equals(format)) {
            throw Py.ValueError(String.format("can only set %s format to 'unknown' or the detected platform value", typestr));
        }
        if (Format.BE.format().equals(format)) {
            new_format = Format.BE;
        } else if (Format.UNKNOWN.format().equals(format)) {
            new_format = Format.UNKNOWN;
        } else {
            throw Py.ValueError("__setformat__() argument 2 must be 'unknown', 'IEEE, little-endian' or 'IEEE, big-endian'");
        }
        if (new_format != null) {
            if ("double".equals(typestr)) {
                double_format = new_format;
            } else {
                float_format = new_format;
            }
        }
    }

    static {
        PyType.addBuilder(PyFloat.class, new PyFloat$PyExposer());
        TYPE = PyType.fromClass(PyFloat.class);
        SPEC_REPR = InternalFormat.fromText(" >r");
        SPEC_STR = InternalFormat.Spec.NUMERIC;
        ZERO = new PyFloat(0.0);
        ONE = new PyFloat(1.0);
        NAN = new PyFloat(Double.NaN);
        INT_LONG_BOUNDARY = 2.147483648E9;
        double_format = Format.BE;
        float_format = Format.BE;
    }

    public static enum Format {
        UNKNOWN("unknown"),
        BE("IEEE, big-endian"),
        LE("IEEE, little-endian");

        private final String format;

        private Format(String format) {
            this.format = format;
        }

        public String format() {
            return this.format;
        }
    }

    public class PyFloat$float_fromhex_exposer
    extends PyBuiltinClassMethodNarrow {
        public PyFloat$float_fromhex_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "float.fromhex(string) -> float\n\nCreate a floating-point number from a hexadecimal string.\n>>> float.fromhex('0x1.ffffp10')\n2047.984375\n>>> float.fromhex('-0x1p-1074')\n-4.9406564584124654e-324";
        }

        public PyFloat$float_fromhex_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "float.fromhex(string) -> float\n\nCreate a floating-point number from a hexadecimal string.\n>>> float.fromhex('0x1.ffffp10')\n2047.984375\n>>> float.fromhex('-0x1p-1074')\n-4.9406564584124654e-324";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float_fromhex_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return PyFloat.float_fromhex((PyType)this.self, pyObject);
        }
    }

    public class PyFloat$float_hex_exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float_hex_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "float.hex() -> string\n\nReturn a hexadecimal representation of a floating-point number.\n>>> (-0.1).hex()\n'-0x1.999999999999ap-4'\n>>> 3.14159.hex()\n'0x1.921f9f01b866ep+1'";
        }

        public PyFloat$float_hex_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "float.hex() -> string\n\nReturn a hexadecimal representation of a floating-point number.\n>>> (-0.1).hex()\n'-0x1.999999999999ap-4'\n>>> 3.14159.hex()\n'0x1.921f9f01b866ep+1'";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float_hex_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float_hex();
        }
    }

    public class PyFloat$float___str___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___str___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyFloat$float___str___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___str___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___str__();
        }
    }

    public class PyFloat$float___repr___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___repr___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__repr__() <==> repr(x)";
        }

        public PyFloat$float___repr___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__repr__() <==> repr(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___repr___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___repr__();
        }
    }

    public class PyFloat$float___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___hash___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyFloat$float___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyFloat)this.self).float___hash__());
        }
    }

    public class PyFloat$float___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___nonzero___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyFloat$float___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFloat)this.self).float___nonzero__());
        }
    }

    public class PyFloat$float___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___cmp___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyFloat$float___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyFloat)this.self).float___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("float.__cmp__(x,y) requires y to be 'float', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyFloat$float___coerce___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___coerce___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__coerce__(y) <==> coerce(x, y)";
        }

        public PyFloat$float___coerce___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__coerce__(y) <==> coerce(x, y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___coerce___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyFloat)this.self).float___coerce__(pyObject);
        }
    }

    public class PyFloat$float___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___add___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__add__(y) <==> x+y";
        }

        public PyFloat$float___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__add__(y) <==> x+y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___radd___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___radd___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__radd__(y) <==> y+x";
        }

        public PyFloat$float___radd___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__radd__(y) <==> y+x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___radd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___radd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___sub___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___sub___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__sub__(y) <==> x-y";
        }

        public PyFloat$float___sub___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__sub__(y) <==> x-y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___sub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___sub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rsub___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rsub___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rsub__(y) <==> y-x";
        }

        public PyFloat$float___rsub___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rsub__(y) <==> y-x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rsub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rsub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___mul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mul__(y) <==> x*y";
        }

        public PyFloat$float___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mul__(y) <==> x*y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rmul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rmul__(y) <==> y*x";
        }

        public PyFloat$float___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rmul__(y) <==> y*x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___div___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___div___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__div__(y) <==> x/y";
        }

        public PyFloat$float___div___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__div__(y) <==> x/y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___div___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___div__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rdiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rdiv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rdiv__(y) <==> y/x";
        }

        public PyFloat$float___rdiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rdiv__(y) <==> y/x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rdiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rdiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___floordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___floordiv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__floordiv__(y) <==> x//y";
        }

        public PyFloat$float___floordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__floordiv__(y) <==> x//y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___floordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___floordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rfloordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rfloordiv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyFloat$float___rfloordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rfloordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rfloordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___truediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___truediv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__truediv__(y) <==> x/y";
        }

        public PyFloat$float___truediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__truediv__(y) <==> x/y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___truediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___truediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rtruediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rtruediv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rtruediv__(y) <==> y/x";
        }

        public PyFloat$float___rtruediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rtruediv__(y) <==> y/x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rtruediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rtruediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___mod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyFloat$float___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___mod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rmod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyFloat$float___rmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___divmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___divmod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__divmod__(y) <==> divmod(x, y)";
        }

        public PyFloat$float___divmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__divmod__(y) <==> divmod(x, y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___divmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___divmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rdivmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rdivmod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rdivmod__(y) <==> divmod(y, x)";
        }

        public PyFloat$float___rdivmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rdivmod__(y) <==> divmod(y, x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rdivmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rdivmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___pow___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___pow___exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "x.__pow__(y[, z]) <==> pow(x, y[, z])";
        }

        public PyFloat$float___pow___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__pow__(y[, z]) <==> pow(x, y[, z])";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___pow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            PyObject pyObject3 = ((PyFloat)this.self).float___pow__(pyObject, pyObject2);
            if (pyObject3 == null) {
                return Py.NotImplemented;
            }
            return pyObject3;
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___pow__(pyObject, null);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___rpow___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___rpow___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "y.__rpow__(x[, z]) <==> pow(x, y[, z])";
        }

        public PyFloat$float___rpow___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "y.__rpow__(x[, z]) <==> pow(x, y[, z])";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___rpow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyFloat)this.self).float___rpow__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyFloat$float___neg___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___neg___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyFloat$float___neg___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___neg___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___neg__();
        }
    }

    public class PyFloat$float___pos___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___pos___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__pos__() <==> +x";
        }

        public PyFloat$float___pos___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__pos__() <==> +x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___pos___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___pos__();
        }
    }

    public class PyFloat$float___abs___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___abs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyFloat$float___abs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___abs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___abs__();
        }
    }

    public class PyFloat$float___int___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___int___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__int__() <==> int(x)";
        }

        public PyFloat$float___int___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__int__() <==> int(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___int___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___int__();
        }
    }

    public class PyFloat$float___long___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___long___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__long__() <==> long(x)";
        }

        public PyFloat$float___long___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__long__() <==> long(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___long___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___long__();
        }
    }

    public class PyFloat$float___float___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___float___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__float__() <==> float(x)";
        }

        public PyFloat$float___float___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__float__() <==> float(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___float___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___float__();
        }
    }

    public class PyFloat$float___trunc___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___trunc___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Returns the Integral closest to x between 0 and x.";
        }

        public PyFloat$float___trunc___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Returns the Integral closest to x between 0 and x.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___trunc___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___trunc__();
        }
    }

    public class PyFloat$float_conjugate_exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float_conjugate_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Returns self, the complex conjugate of any float.";
        }

        public PyFloat$float_conjugate_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Returns self, the complex conjugate of any float.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float_conjugate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float_conjugate();
        }
    }

    public class PyFloat$float_is_integer_exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float_is_integer_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Returns True if the float is an integer.";
        }

        public PyFloat$float_is_integer_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Returns True if the float is an integer.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float_is_integer_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFloat)this.self).float_is_integer());
        }
    }

    public class PyFloat$float___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___getnewargs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyFloat$float___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).float___getnewargs__();
        }
    }

    public class PyFloat$float___format___exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$float___format___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "float.__format__(format_spec) -> string\n\nFormats the float according to format_spec.";
        }

        public PyFloat$float___format___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "float.__format__(format_spec) -> string\n\nFormats the float according to format_spec.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___format___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyFloat)this.self).float___format__(pyObject);
        }
    }

    public class PyFloat$as_integer_ratio_exposer
    extends PyBuiltinMethodNarrow {
        public PyFloat$as_integer_ratio_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "float.as_integer_ratio() -> (int, int)\n\nReturns a pair of integers, whose ratio is exactly equal to the original\nfloat and with a positive denominator.\nRaises OverflowError on infinities and a ValueError on NaNs.\n\n>>> (10.0).as_integer_ratio()\n(10, 1)\n>>> (0.0).as_integer_ratio()\n(0, 1)\n>>> (-.25).as_integer_ratio()\n(-1, 4)";
        }

        public PyFloat$as_integer_ratio_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "float.as_integer_ratio() -> (int, int)\n\nReturns a pair of integers, whose ratio is exactly equal to the original\nfloat and with a positive denominator.\nRaises OverflowError on infinities and a ValueError on NaNs.\n\n>>> (10.0).as_integer_ratio()\n(10, 1)\n>>> (0.0).as_integer_ratio()\n(0, 1)\n>>> (-.25).as_integer_ratio()\n(-1, 4)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$as_integer_ratio_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFloat)this.self).as_integer_ratio();
        }
    }

    public class PyFloat$float___getformat___exposer
    extends PyBuiltinClassMethodNarrow {
        public PyFloat$float___getformat___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "float.__getformat__(typestr) -> string\n\nYou probably don't want to use this function.  It exists mainly to be\nused in Python's test suite.\n\ntypestr must be 'double' or 'float'.  This function returns whichever of\n'unknown', 'IEEE, big-endian' or 'IEEE, little-endian' best describes the\nformat of floating point numbers used by the C type named by typestr.";
        }

        public PyFloat$float___getformat___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "float.__getformat__(typestr) -> string\n\nYou probably don't want to use this function.  It exists mainly to be\nused in Python's test suite.\n\ntypestr must be 'double' or 'float'.  This function returns whichever of\n'unknown', 'IEEE, big-endian' or 'IEEE, little-endian' best describes the\nformat of floating point numbers used by the C type named by typestr.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___getformat___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = PyFloat.float___getformat__((PyType)this.self, pyObject.asString());
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyFloat$float___setformat___exposer
    extends PyBuiltinClassMethodNarrow {
        public PyFloat$float___setformat___exposer(String string2) {
            super(string2, 3, 3);
            this.doc = "float.__setformat__(typestr, fmt) -> None\n\nYou probably don't want to use this function.  It exists mainly to be\nused in Python's test suite.\n\ntypestr must be 'double' or 'float'.  fmt must be one of 'unknown',\n'IEEE, big-endian' or 'IEEE, little-endian', and in addition can only be\none of the latter two if it appears to match the underlying C reality.\n\nOverrides the automatic determination of C-level floating point type.\nThis affects how floats are converted to and from binary strings.";
        }

        public PyFloat$float___setformat___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "float.__setformat__(typestr, fmt) -> None\n\nYou probably don't want to use this function.  It exists mainly to be\nused in Python's test suite.\n\ntypestr must be 'double' or 'float'.  fmt must be one of 'unknown',\n'IEEE, big-endian' or 'IEEE, little-endian', and in addition can only be\none of the latter two if it appears to match the underlying C reality.\n\nOverrides the automatic determination of C-level floating point type.\nThis affects how floats are converted to and from binary strings.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFloat$float___setformat___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            PyFloat.float___setformat__((PyType)this.self, pyObject.asString(), pyObject2.asString());
            return Py.None;
        }
    }

    public class PyFloat$imag_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyFloat$imag_descriptor() {
            super("imag", PyObject.class, "the imaginary part of a complex number");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyFloat)pyObject).getImag();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyFloat$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyFloat.float_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyFloat$PyExposer
    extends BaseTypeBuilder {
        public PyFloat$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyFloat$float_fromhex_exposer("fromhex"), new PyFloat$float_hex_exposer("hex"), new PyFloat$float___str___exposer("__str__"), new PyFloat$float___repr___exposer("__repr__"), new PyFloat$float___hash___exposer("__hash__"), new PyFloat$float___nonzero___exposer("__nonzero__"), new PyFloat$float___cmp___exposer("__cmp__"), new PyFloat$float___coerce___exposer("__coerce__"), new PyFloat$float___add___exposer("__add__"), new PyFloat$float___radd___exposer("__radd__"), new PyFloat$float___sub___exposer("__sub__"), new PyFloat$float___rsub___exposer("__rsub__"), new PyFloat$float___mul___exposer("__mul__"), new PyFloat$float___rmul___exposer("__rmul__"), new PyFloat$float___div___exposer("__div__"), new PyFloat$float___rdiv___exposer("__rdiv__"), new PyFloat$float___floordiv___exposer("__floordiv__"), new PyFloat$float___rfloordiv___exposer("__rfloordiv__"), new PyFloat$float___truediv___exposer("__truediv__"), new PyFloat$float___rtruediv___exposer("__rtruediv__"), new PyFloat$float___mod___exposer("__mod__"), new PyFloat$float___rmod___exposer("__rmod__"), new PyFloat$float___divmod___exposer("__divmod__"), new PyFloat$float___rdivmod___exposer("__rdivmod__"), new PyFloat$float___pow___exposer("__pow__"), new PyFloat$float___rpow___exposer("__rpow__"), new PyFloat$float___neg___exposer("__neg__"), new PyFloat$float___pos___exposer("__pos__"), new PyFloat$float___abs___exposer("__abs__"), new PyFloat$float___int___exposer("__int__"), new PyFloat$float___long___exposer("__long__"), new PyFloat$float___float___exposer("__float__"), new PyFloat$float___trunc___exposer("__trunc__"), new PyFloat$float_conjugate_exposer("conjugate"), new PyFloat$float_is_integer_exposer("is_integer"), new PyFloat$float___getnewargs___exposer("__getnewargs__"), new PyFloat$float___format___exposer("__format__"), new PyFloat$as_integer_ratio_exposer("as_integer_ratio"), new PyFloat$float___getformat___exposer("__getformat__"), new PyFloat$float___setformat___exposer("__setformat__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyFloat$real_descriptor(), new PyFloat$imag_descriptor()};
            super("float", PyFloat.class, Object.class, true, "float(x) -> floating point number\n\nConvert a string or number to a floating point number, if possible.", pyBuiltinMethodArray, pyDataDescrArray, new PyFloat$exposed___new__());
        }
    }
}

