/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;
import org.simpleframework.xml.util.WeakCache;

public class RegistryMatcher
implements Matcher {
    private final Cache<Transform> transforms = new Cache();
    private final Cache<Class> types = new Cache();

    public void bind(Class type, Class transform) {
        this.types.cache(type, transform);
    }

    public void bind(Class type, Transform transform) {
        this.transforms.cache(type, transform);
    }

    public Transform match(Class type) throws Exception {
        Transform transform = (Transform)this.transforms.fetch(type);
        if (transform == null) {
            return this.create(type);
        }
        return transform;
    }

    private Transform create(Class type) throws Exception {
        Class factory = (Class)this.types.fetch(type);
        if (factory != null) {
            return this.create(type, factory);
        }
        return null;
    }

    private Transform create(Class type, Class factory) throws Exception {
        Object value = factory.newInstance();
        Transform transform = (Transform)value;
        if (transform != null) {
            this.transforms.cache(type, transform);
        }
        return transform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache<T>
    extends WeakCache<Class, T> {
    }
}

