/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ApiProperties {
    private Properties properties = new Properties();
    private String host = "127.0.0.1";
    private int port = 4701;

    public ApiProperties() {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("/nxapisrv.properties");
            if (in != null) {
                this.properties.load(in);
                this.host = this.properties.getProperty("netxms.server.address", "127.0.0.1");
                this.port = this.getIntProperty("netxms.server.port", 4701);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int getIntProperty(String name, int defaultValue) {
        try {
            String v = this.properties.getProperty(name);
            if (v == null) {
                return defaultValue;
            }
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getServerAddress() {
        return this.host;
    }

    public int getServerPort() {
        return this.port;
    }
}

