/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.netxms.client.NXCSession;
import org.netxms.websvc.ApiProperties;
import org.netxms.websvc.SessionStore;
import org.netxms.websvc.SessionToken;
import org.netxms.websvc.WebSvcStatusService;
import org.netxms.websvc.json.JsonTools;
import org.restlet.Application;
import org.restlet.data.CookieSetting;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandler
extends ServerResource {
    static ApiProperties properties = new ApiProperties();
    private Logger log = LoggerFactory.getLogger(AbstractHandler.class);
    private SessionToken sessionToken = null;
    private NXCSession session = null;

    @Get
    public Representation onGet() throws Exception {
        String id = this.getEntityId();
        this.log.debug("GET: entityId = " + id);
        if (this.attachToSession()) {
            Map query = this.getRequest().getResourceRef().getQueryAsForm().getValuesMap();
            Object response = id == null ? this.getCollection(query) : this.get(id, query);
            return new StringRepresentation((CharSequence)JsonTools.jsonFromObject((Object)response, (Set)this.getRequestedFields()), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
    }

    @Post
    public Representation onPost(Representation entity) throws Exception {
        if (entity == null) {
            this.log.warn("No POST data in call");
            return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
        }
        JSONObject data = new JsonRepresentation(entity).getJsonObject();
        this.log.debug("POST: data = " + data);
        if (this.attachToSession()) {
            return new StringRepresentation((CharSequence)JsonTools.jsonFromObject((Object)this.create(data), null), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
    }

    @Put
    public Representation onPut(Representation entity) throws Exception {
        if (entity == null) {
            this.log.warn("No PUT data in call");
            return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
        }
        JSONObject data = new JsonRepresentation(entity).getJsonObject();
        String id = this.getEntityId();
        this.log.debug("PUT: entityId = " + id);
        if (this.attachToSession()) {
            Object response = id != null ? this.update(id, data) : this.createErrorResponse(17);
            return new StringRepresentation((CharSequence)JsonTools.jsonFromObject((Object)response, null), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
    }

    @Delete
    public Representation onDelete(Representation entity) throws Exception {
        String id = this.getEntityId();
        this.log.debug("DELETE: entityId = " + id);
        if (this.attachToSession()) {
            Object response = id != null ? this.delete(id) : this.createErrorResponse(17);
            return new StringRepresentation((CharSequence)JsonTools.jsonFromObject((Object)response, null), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
    }

    protected String getEntityId() {
        return (String)this.getRequest().getAttributes().get(this.getEntityIdFieldName());
    }

    protected String getEntityIdFieldName() {
        return "id";
    }

    protected String decodeBase64(String data) {
        if (data != null && !data.equals("0")) {
            String value = data.substring(data.indexOf(32) + 1, data.length());
            return new String(Base64.decodeBase64((String)value), Charset.forName("UTF-8"));
        }
        return null;
    }

    protected boolean attachToSession() throws Exception {
        SessionToken token = this.findSessionToken();
        if (token == null && this.getHeader("Authorization") != null) {
            String value = this.decodeBase64(this.getHeader("Authorization"));
            String login = value.substring(0, value.indexOf(58));
            String password = value.substring(value.indexOf(58) + 1, value.length());
            this.log.debug("Cannot find session token - re-authenticating (login=" + login + ")");
            token = this.login(login, password);
            this.getCookieSettings().add((Object)new CookieSetting(0, "session_handle", token.getSessionHandle().toString(), "/", null));
            this.getResponse().getHeaders().add((Object)new Header("Session-Id", token.getSessionHandle().toString()));
        } else if (token != null) {
            this.log.debug("Handler attached to session " + token.getSessionHandle());
            this.sessionToken = token;
            this.session = token.getSession();
        } else {
            this.log.debug("Session token not found and new session cannot be created");
        }
        return this.session != null;
    }

    protected SessionToken findSessionToken() {
        String cookie = this.getCookies().getValues("session_handle");
        if (cookie != null) {
            this.log.debug("session_handle: " + cookie);
            UUID guid = UUID.fromString(cookie);
            return SessionStore.getInstance((ServletContext)this.getServletContext()).getSessionToken(guid);
        }
        String sid = this.getHeader("Session-Id");
        if (sid != null && !sid.equals("0")) {
            this.log.debug("Session-Id: " + sid);
            UUID guid = UUID.fromString(sid);
            return SessionStore.getInstance((ServletContext)this.getServletContext()).getSessionToken(guid);
        }
        return null;
    }

    protected NXCSession getSession() {
        return this.session;
    }

    protected SessionToken getSessionToken() {
        return this.sessionToken;
    }

    protected ServletContext getServletContext() {
        Application app = Application.getCurrent();
        return (ServletContext)app.getContext().getAttributes().get("org.restlet.ext.servlet.ServletContext");
    }

    protected JsonObject createErrorResponse(int rcc) throws JSONException {
        this.setStatus(WebSvcStatusService.getStatusFromRCC((int)rcc));
        JsonObject response = new JsonObject();
        response.addProperty("error", (Number)rcc);
        response.addProperty("description", WebSvcStatusService.getMessageFromRCC((int)rcc));
        return response;
    }

    protected Object getCollection(Map<String, String> query) throws Exception {
        return this.createErrorResponse(17);
    }

    protected Object get(String id, Map<String, String> query) throws Exception {
        return this.createErrorResponse(17);
    }

    protected Object create(JSONObject data) throws Exception {
        return this.createErrorResponse(17);
    }

    protected Object update(String id, JSONObject data) throws Exception {
        return this.createErrorResponse(17);
    }

    protected Object delete(String id) throws Exception {
        return this.createErrorResponse(17);
    }

    protected SessionToken login(String login, String password) throws Exception {
        this.log.debug("Performing login to " + properties.getServerAddress() + ":" + properties.getServerPort());
        this.session = new NXCSession(properties.getServerAddress(), properties.getServerPort());
        this.session.connect();
        this.session.login(login, password == null ? "" : password);
        return SessionStore.getInstance((ServletContext)this.getServletContext()).registerSession(this.session);
    }

    private Set<String> getRequestedFields() {
        String fieldList = (String)this.getRequest().getResourceRef().getQueryAsForm().getValuesMap().get("fields");
        if (fieldList == null || fieldList.isEmpty()) {
            return null;
        }
        String[] parts = fieldList.split(",");
        if (parts.length == 0) {
            return null;
        }
        HashSet<String> fields = new HashSet<String>();
        for (String f : parts) {
            fields.add(f);
        }
        return fields;
    }

    protected String getHeader(String name) {
        return this.getRequest().getHeaders().getFirstValue(name, true);
    }

    protected static int parseInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected static long parseLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

