/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.json.ResponseContainer;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;

public class Alarms
extends AbstractHandler {
    private static final int TERMINATE = 0;
    private static final int ACKNOWLEDGE = 1;
    private static final int STICKY_ACKNOWLEDGE = 2;
    private static final int RESOLVE = 3;

    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        Collection alarms = session.getAlarms().values();
        String queryGuid = query.get("objectGuid");
        if (queryGuid != null) {
            AbstractObject object;
            UUID objectGuid = UUID.fromString(queryGuid);
            if (!session.isObjectsSynchronized()) {
                session.syncObjects();
            }
            if ((object = session.findObjectByGUID(objectGuid)) == null) {
                throw new NXCException(7);
            }
            Iterator iterator = alarms.iterator();
            while (iterator.hasNext()) {
                Alarm alarm = (Alarm)iterator.next();
                if (alarm.getSourceObjectId() == object.getObjectId()) continue;
                iterator.remove();
            }
        }
        return new ResponseContainer("alarms", alarms);
    }

    @Post
    public Representation onPost(Representation entity) throws Exception {
        if (entity == null || !this.attachToSession()) {
            return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
        }
        NXCSession session = this.getSession();
        HashMap alarms = session.getAlarms();
        JSONObject data = new JsonRepresentation(entity).getJsonObject();
        if (data.has("alarmList")) {
            JSONArray alarmList = data.getJSONArray("alarmList");
            block6: for (int i = 0; i < alarmList.length(); ++i) {
                JSONObject alarmData = alarmList.getJSONObject(i);
                Alarm a = (Alarm)alarms.get(alarmData.getLong("alarmId"));
                if (a == null) continue;
                switch (alarmData.getInt("action")) {
                    case 0: {
                        session.terminateAlarm(a.getId());
                        continue block6;
                    }
                    case 1: {
                        session.acknowledgeAlarm(a.getId());
                        continue block6;
                    }
                    case 2: {
                        if (!alarmData.has("timeout")) continue block6;
                        session.acknowledgeAlarm(a.getId(), true, alarmData.getInt("timeout"));
                        continue block6;
                    }
                    case 3: {
                        session.resolveAlarm(a.getId());
                    }
                }
            }
        } else {
            return new StringRepresentation((CharSequence)this.createErrorResponse(46).toString(), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse(0).toString(), MediaType.APPLICATION_JSON);
    }
}

