/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.series;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.Range;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.compress.CompressConfig;
import org.swtchart.internal.compress.ICompress;
import org.swtchart.internal.series.BarSeries;
import org.swtchart.internal.series.LineSeries;
import org.swtchart.internal.series.Series;

public class SeriesSet
implements ISeriesSet {
    private Chart chart;
    private LinkedHashMap<String, Series> seriesMap;

    public SeriesSet(Chart chart) {
        this.chart = chart;
        this.seriesMap = new LinkedHashMap();
    }

    @Override
    public ISeries createSeries(ISeries.SeriesType type, String id, boolean updateChart) {
        Axis axis;
        if (id == null) {
            SWT.error((int)4);
            return null;
        }
        String identifier = id.trim();
        if ("".equals(identifier)) {
            SWT.error((int)5);
        }
        Series series = null;
        if (type == ISeries.SeriesType.BAR) {
            series = new BarSeries(this.chart, identifier);
        } else if (type == ISeries.SeriesType.LINE) {
            series = new LineSeries(this.chart, identifier);
        } else {
            SWT.error((int)5);
            return null;
        }
        Series oldSeries = this.seriesMap.get(identifier);
        if (oldSeries != null) {
            oldSeries.dispose();
        }
        int[] xAxisIds = this.chart.getAxisSet().getXAxisIds();
        int[] yAxisIds = this.chart.getAxisSet().getYAxisIds();
        series.setXAxisId(xAxisIds[0]);
        series.setYAxisId(yAxisIds[0]);
        this.seriesMap.put(identifier, series);
        if (updateChart && (axis = (Axis)this.chart.getAxisSet().getXAxis(xAxisIds[0])) != null) {
            this.updateStackAndRiserData();
        }
        this.chart.updateLayout();
        return series;
    }

    @Override
    public ISeries getSeries(String id) {
        if (id == null) {
            SWT.error((int)4);
        }
        return this.seriesMap.get(id);
    }

    @Override
    public ISeries[] getSeries() {
        Set<String> keys = this.seriesMap.keySet();
        ISeries[] series = new ISeries[keys.size()];
        int i = 0;
        for (String key : keys) {
            series[i++] = this.seriesMap.get(key);
        }
        return series;
    }

    @Override
    public void deleteSeries(String id) {
        this.validateSeriesId(id);
        this.seriesMap.get(id).dispose();
        this.seriesMap.remove(id);
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void bringForward(String id) {
        this.validateSeriesId(id);
        String seriesId = null;
        LinkedHashMap<String, Series> newSeriesMap = new LinkedHashMap<String, Series>();
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            if (entry.getKey().equals(id)) {
                seriesId = id;
                continue;
            }
            newSeriesMap.put(entry.getKey(), entry.getValue());
            if (seriesId == null) continue;
            newSeriesMap.put(seriesId, this.seriesMap.get(seriesId));
            seriesId = null;
        }
        if (seriesId != null) {
            newSeriesMap.put(seriesId, this.seriesMap.get(seriesId));
        }
        this.seriesMap = newSeriesMap;
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void bringToFront(String id) {
        this.validateSeriesId(id);
        Series series = this.seriesMap.get(id);
        this.seriesMap.remove(id);
        this.seriesMap.put(series.getId(), series);
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void sendBackward(String id) {
        this.validateSeriesId(id);
        String seriesId = null;
        LinkedHashMap<String, Series> newSeriesMap = new LinkedHashMap<String, Series>();
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            if (!entry.getKey().equals(id) || seriesId == null) {
                newSeriesMap.put(entry.getKey(), entry.getValue());
                seriesId = entry.getKey();
                continue;
            }
            newSeriesMap.remove(seriesId);
            newSeriesMap.put(entry.getKey(), entry.getValue());
            newSeriesMap.put(seriesId, this.seriesMap.get(seriesId));
        }
        this.seriesMap = newSeriesMap;
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    @Override
    public void sendToBack(String id) {
        this.validateSeriesId(id);
        LinkedHashMap<String, Series> newSeriesMap = new LinkedHashMap<String, Series>();
        newSeriesMap.put(id, this.seriesMap.get(id));
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            if (entry.getKey().equals(id)) continue;
            newSeriesMap.put(entry.getKey(), entry.getValue());
        }
        this.seriesMap = newSeriesMap;
        this.updateStackAndRiserData();
        this.chart.updateLayout();
    }

    public void dispose() {
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            entry.getValue().dispose();
        }
    }

    private void validateSeriesId(String id) {
        if (id == null) {
            SWT.error((int)4);
        }
        if (this.seriesMap.get(id) == null) {
            throw new IllegalArgumentException("Given series id doesn't exist");
        }
    }

    public void compressAllSeries() {
        if (!this.chart.isCompressEnabled()) {
            return;
        }
        CompressConfig config = new CompressConfig();
        Point p = this.chart.getPlotArea().getSize();
        int width = p.x * 2;
        int height = p.y * 2;
        config.setSizeInPixel(width, height);
        ISeries[] iSeriesArray = this.getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            int xAxisId = series.getXAxisId();
            int yAxisId = series.getYAxisId();
            IAxis xAxis = this.chart.getAxisSet().getXAxis(xAxisId);
            IAxis yAxis = this.chart.getAxisSet().getYAxis(yAxisId);
            if (xAxis != null && yAxis != null) {
                Range xRange = xAxis.getRange();
                Range yRange = yAxis.getRange();
                if (xRange != null && yRange != null) {
                    double xMin = xRange.lower;
                    double xMax = xRange.upper;
                    double yMin = yRange.lower;
                    double yMax = yRange.upper;
                    config.setXLogScale(xAxis.isLogScaleEnabled());
                    config.setYLogScale(yAxis.isLogScaleEnabled());
                    double lower = xMin - (xMax - xMin) * 0.015;
                    double upper = xMax + (xMax - xMin) * 0.015;
                    if (xAxis.isLogScaleEnabled()) {
                        lower = ((Series)series).getXRange().lower;
                    }
                    config.setXRange(lower, upper);
                    lower = yMin - (yMax - yMin) * 0.015;
                    upper = yMax + (yMax - yMin) * 0.015;
                    if (yAxis.isLogScaleEnabled()) {
                        lower = ((Series)series).getYRange().lower;
                    }
                    config.setYRange(lower, upper);
                    ICompress compressor = ((Series)series).getCompressor();
                    compressor.compress(config);
                }
            }
            ++n2;
        }
    }

    public void updateCompressor(Axis axis) {
        ISeries[] iSeriesArray = this.getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            int axisId;
            ISeries series = iSeriesArray[n2];
            int n3 = axisId = axis.getDirection() == IAxis.Direction.X ? series.getXAxisId() : series.getYAxisId();
            if (axisId == axis.getId()) {
                ICompress compressor = ((Series)series).getCompressor();
                if (axis.isValidCategoryAxis()) {
                    String[] categorySeries = axis.getCategorySeries();
                    if (categorySeries != null) {
                        double[] xSeries = new double[categorySeries.length];
                        int i = 0;
                        while (i < xSeries.length) {
                            xSeries[i] = i;
                            ++i;
                        }
                        compressor.setXSeries(xSeries);
                    }
                } else if (((Series)series).getXSeries() != null) {
                    compressor.setXSeries(((Series)series).getXSeries());
                }
            }
            ++n2;
        }
        this.compressAllSeries();
    }

    public void updateStackAndRiserData() {
        IAxis[] iAxisArray = this.chart.getAxisSet().getXAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis xAxis = iAxisArray[n2];
            ((Axis)xAxis).setNumRisers(0);
            IAxis[] iAxisArray2 = this.chart.getAxisSet().getYAxes();
            int n3 = iAxisArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IAxis yAxis = iAxisArray2[n4];
                this.updateStackAndRiserData(xAxis, yAxis);
                ++n4;
            }
            ++n2;
        }
    }

    private void updateStackAndRiserData(IAxis xAxis, IAxis yAxis) {
        int n;
        int riserCnt = 0;
        int stackRiserPosition = -1;
        double[] stackBarSeries = null;
        double[] stackLineSeries = null;
        double[] invertedStackLineSeries = null;
        if (((Axis)xAxis).isValidCategoryAxis()) {
            String[] categorySeries = xAxis.getCategorySeries();
            if (categorySeries != null) {
                int size = categorySeries.length;
                stackBarSeries = new double[size];
                stackLineSeries = new double[size];
                invertedStackLineSeries = new double[size];
            }
        } else {
            ISeries series;
            ArrayList<Date> combinedTimeSeries = new ArrayList<Date>();
            ISeries[] iSeriesArray = this.getSeries();
            int n2 = iSeriesArray.length;
            n = 0;
            while (n < n2) {
                series = iSeriesArray[n];
                if (series.isStackEnabled()) {
                    Date[] dateArray = series.getXDateSeries();
                    int n3 = dateArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Date d = dateArray[n4];
                        int i = 0;
                        while (i < combinedTimeSeries.size()) {
                            if (((Date)combinedTimeSeries.get(i)).getTime() == d.getTime()) break;
                            if (((Date)combinedTimeSeries.get(i)).getTime() < d.getTime()) {
                                combinedTimeSeries.add(i, d);
                                break;
                            }
                            ++i;
                        }
                        if (i == combinedTimeSeries.size()) {
                            combinedTimeSeries.add(d);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
            iSeriesArray = this.getSeries();
            n2 = iSeriesArray.length;
            n = 0;
            while (n < n2) {
                series = iSeriesArray[n];
                if (series.isStackEnabled()) {
                    double[] ySeries = new double[combinedTimeSeries.size()];
                    int combinedIndex = 0;
                    double lastValue = 0.0;
                    long lastTimestamp = 0L;
                    int i = 0;
                    while (i < series.getYSeries().length) {
                        Date currentTimestamp = series.getXDateSeries()[i];
                        double currentValue = series.getYSeries()[i];
                        long currentCombinedTimestamp = ((Date)combinedTimeSeries.get(combinedIndex)).getTime();
                        while (currentCombinedTimestamp > currentTimestamp.getTime()) {
                            ySeries[combinedIndex] = lastTimestamp != 0L ? lastValue + (currentValue - lastValue) * ((double)(lastTimestamp - currentCombinedTimestamp) / (double)(lastTimestamp - currentTimestamp.getTime())) : currentValue;
                            currentCombinedTimestamp = ((Date)combinedTimeSeries.get(++combinedIndex)).getTime();
                        }
                        ySeries[combinedIndex++] = currentValue;
                        lastTimestamp = currentTimestamp.getTime();
                        lastValue = currentValue;
                        ++i;
                    }
                    while (combinedIndex < ySeries.length) {
                        ySeries[combinedIndex++] = lastValue;
                    }
                    series.setXDateSeries(combinedTimeSeries.toArray(new Date[combinedTimeSeries.size()]));
                    series.setYSeries(ySeries);
                }
                ++n;
            }
            stackLineSeries = new double[combinedTimeSeries.size()];
            invertedStackLineSeries = new double[combinedTimeSeries.size()];
        }
        ISeries[] iSeriesArray = this.getSeries();
        n = iSeriesArray.length;
        int n5 = 0;
        while (n5 < n) {
            ISeries series = iSeriesArray[n5];
            if (series.getXAxisId() == xAxis.getId() && series.getYAxisId() == yAxis.getId() && series.isVisible()) {
                if (series.isStackEnabled() && !this.chart.getAxisSet().getYAxis(series.getYAxisId()).isLogScaleEnabled()) {
                    if (series.getType() == ISeries.SeriesType.BAR) {
                        if (stackRiserPosition == -1) {
                            stackRiserPosition = riserCnt++;
                        }
                        ((BarSeries)series).setRiserIndex(((Axis)xAxis).getNumRisers() + stackRiserPosition);
                        this.setStackSeries(stackBarSeries, series);
                    } else if (series.getType() == ISeries.SeriesType.LINE) {
                        this.setStackSeries(series.isInverted() ? invertedStackLineSeries : stackLineSeries, series);
                    }
                } else if (series.getType() == ISeries.SeriesType.BAR) {
                    ((BarSeries)series).setRiserIndex(((Axis)xAxis).getNumRisers() + riserCnt++);
                }
            }
            ++n5;
        }
        ((Axis)xAxis).setNumRisers(((Axis)xAxis).getNumRisers() + riserCnt);
    }

    private void setStackSeries(double[] stackSeries, ISeries series) {
        double[] ySeries = series.getYSeries();
        if (ySeries == null || stackSeries == null) {
            return;
        }
        int i = 0;
        while (i < stackSeries.length) {
            if (i >= ySeries.length) break;
            stackSeries[i] = new BigDecimal(new Double(stackSeries[i]).toString()).add(new BigDecimal(new Double(ySeries[i]).toString())).doubleValue();
            ++i;
        }
        double[] copiedStackSeries = new double[stackSeries.length];
        System.arraycopy(stackSeries, 0, copiedStackSeries, 0, stackSeries.length);
        ((Series)series).setStackSeries(copiedStackSeries);
    }
}

