/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.certificate.manager;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.netxms.certificate.loader.KeyStoreLoader;
import org.netxms.certificate.loader.KeyStoreRequestListener;
import org.netxms.certificate.loader.exception.KeyStoreLoaderException;
import org.netxms.certificate.manager.exception.CertificateHasNoPrivateKeyException;
import org.netxms.certificate.manager.exception.CertificateNotInKeyStoreException;
import org.netxms.certificate.manager.exception.SignatureImpossibleException;
import org.netxms.certificate.manager.exception.SignatureVerificationImpossibleException;
import org.netxms.certificate.request.KeyStoreEntryPasswordRequestListener;

public class CertificateManager {
    private KeyStore keyStore;
    private Certificate[] certs;
    private final KeyStoreLoader loader;
    private KeyStoreEntryPasswordRequestListener passwordRequestListener;

    CertificateManager(KeyStoreLoader loader) {
        this.loader = loader;
    }

    public void setPasswordRequestListener(KeyStoreEntryPasswordRequestListener passwordRequestListener) {
        this.passwordRequestListener = passwordRequestListener;
    }

    public void setKeyStoreRequestListener(KeyStoreRequestListener keyStoreRequestListener) {
        this.loader.setKeyStoreRequestListener(keyStoreRequestListener);
    }

    public Certificate[] getCerts() {
        return this.certs;
    }

    private void loadCerts() {
        try {
            this.certs = this.getCertsFromKeyStore();
        }
        catch (KeyStoreException keyStoreException) {
            this.certs = new Certificate[0];
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            this.certs = new Certificate[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.certs = new Certificate[0];
        }
    }

    public boolean hasNoCertificates() {
        return this.certs == null || this.certs.length == 0;
    }

    public byte[] sign(Certificate cert, byte[] challenge) throws SignatureImpossibleException {
        byte[] signedChallenge;
        try {
            PrivateKey pk = this.getPrivateKey(cert);
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(pk);
            signature.update(challenge);
            signedChallenge = signature.sign();
        }
        catch (Exception e) {
            throw new SignatureImpossibleException(e.getMessage());
        }
        return signedChallenge;
    }

    public Signature extractSignature(Certificate cert) throws SignatureImpossibleException {
        Signature signature;
        try {
            PrivateKey pk = this.getPrivateKey(cert);
            signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(pk);
        }
        catch (Exception e) {
            throw new SignatureImpossibleException(e.getMessage());
        }
        return signature;
    }

    public boolean verify(Certificate cert, byte[] original, byte[] signed) throws SignatureVerificationImpossibleException {
        boolean verified;
        try {
            Signature verifier = Signature.getInstance("SHA1withRSA");
            verifier.initVerify(cert);
            verifier.update(original);
            verified = verifier.verify(signed);
        }
        catch (Exception exception) {
            throw new SignatureVerificationImpossibleException();
        }
        return verified;
    }

    protected PrivateKey getPrivateKey(Certificate cert) throws KeyStoreException, CertificateNotInKeyStoreException, CertificateHasNoPrivateKeyException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.PrivateKeyEntry pkEntry;
        String alias = this.keyStore.getCertificateAlias(cert);
        if (alias == null) {
            throw new CertificateNotInKeyStoreException();
        }
        try {
            pkEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, new KeyStore.PasswordProtection("".toCharArray()));
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            String password = this.getEntryPassword();
            pkEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, new KeyStore.PasswordProtection(password.toCharArray()));
        }
        PrivateKey pk = pkEntry.getPrivateKey();
        if (pk == null) {
            throw new CertificateHasNoPrivateKeyException();
        }
        return pk;
    }

    protected String getEntryPassword() {
        if (this.passwordRequestListener == null) {
            return "";
        }
        return this.passwordRequestListener.keyStoreEntryPasswordRequested();
    }

    public void load() throws KeyStoreLoaderException {
        this.keyStore = this.loader.loadKeyStore();
        this.loadCerts();
    }

    protected Certificate[] getCertsFromKeyStore() throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException {
        if (this.keyStore == null) {
            throw new KeyStoreException();
        }
        if (this.keyStore.size() == 0) {
            return new Certificate[0];
        }
        ArrayList<Certificate> certList = new ArrayList<Certificate>();
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!this.keyStore.isKeyEntry(alias)) continue;
            Certificate cert = this.keyStore.getCertificate(alias);
            certList.add(cert);
        }
        Certificate[] certs = new Certificate[certList.size()];
        certList.toArray(certs);
        return certs;
    }
}

