/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ZoneSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ZoneSelector
extends AbstractSelector {
    private long zoneUIN = 0L;
    private String emptySelectionName = "<none>";

    public ZoneSelector(Composite parent, int style, boolean showClearButton) {
        super(parent, style, showClearButton ? 8 : 0);
        this.setText(this.emptySelectionName);
    }

    protected void selectionButtonHandler() {
        ZoneSelectionDialog dlg = new ZoneSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            this.zoneUIN = dlg.getZoneUIN();
            this.setText(dlg.getZoneName());
            this.fireModifyListeners();
        }
    }

    protected void clearButtonHandler() {
        this.zoneUIN = -1L;
        this.setText(this.emptySelectionName);
        this.fireModifyListeners();
    }

    public long getZoneUIN() {
        return this.zoneUIN;
    }

    public String getZoneName() {
        return this.getText();
    }

    public void setZoneUIN(long zoneUIN) {
        this.zoneUIN = zoneUIN;
        if (zoneUIN == -1L) {
            this.setText(this.emptySelectionName);
        } else {
            Zone zone = ConsoleSharedData.getSession().findZone(zoneUIN);
            this.setText(zone != null ? zone.getObjectName() : "<" + Long.toString(zoneUIN) + ">");
        }
    }
}

