/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.propertypages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;

public class AccessControl
extends PropertyPage {
    private ObjectToolDetails objectTool;
    private Set<AbstractUserObject> acl = new HashSet<AbstractUserObject>();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonRemove;

    public void createControl(Composite parent) {
        this.noDefaultAndApplyButton();
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.objectTool = (ObjectToolDetails)this.getElement().getAdapter(ObjectToolDetails.class);
        NXCSession session = ConsoleSharedData.getSession();
        for (Long uid : this.objectTool.getAccessList()) {
            AbstractUserObject o = session.findUserDBObjectById(uid.longValue());
            if (o == null) continue;
            this.acl.add(o);
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.AccessControl_Label);
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.getTable().setSortDirection(128);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setInput((Object)this.acl.toArray());
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        Messages.get();
        this.buttonAdd.setText(Messages.AccessControl_Add);
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AccessControl.this.addUser();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonRemove = new Button(buttons, 8);
        Messages.get();
        this.buttonRemove.setText(Messages.AccessControl_Delete);
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AccessControl.this.removeUsers();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        return dialogArea;
    }

    public void addUser() {
        SelectUserDialog dlg = new SelectUserDialog(this.getShell(), AbstractUserObject.class);
        if (dlg.open() == 0) {
            AbstractUserObject[] abstractUserObjectArray = dlg.getSelection();
            int n = abstractUserObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractUserObject o = abstractUserObjectArray[n2];
                this.acl.add(o);
                ++n2;
            }
            this.viewer.setInput((Object)this.acl.toArray());
        }
    }

    public void removeUsers() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.acl.remove(o);
        }
        this.viewer.setInput((Object)this.acl.toArray());
    }

    protected void applyChanges(boolean isApply) {
        ArrayList<Long> list = new ArrayList<Long>(this.acl.size());
        for (AbstractUserObject o : this.acl) {
            list.add(o.getId());
        }
        this.objectTool.setAccessList(list);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

