/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.TextConsole;

public abstract class AbstractCommandResults
extends ViewPart {
    protected long nodeId;
    protected long toolId;
    protected TextConsole console;
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSelectAll;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        try {
            this.nodeId = Long.parseLong(parts[0]);
            this.toolId = Long.parseLong(parts[1]);
            NXCSession session = ConsoleSharedData.getSession();
            AbstractObject object = session.findObjectById(this.nodeId);
            this.setPartName(String.valueOf(object.getObjectName()) + " - " + ObjectToolsCache.getInstance().findTool(this.toolId).getDisplayName());
        }
        catch (Exception e) {
            throw new PartInitException("Unexpected initialization failure", (Throwable)e);
        }
    }

    public void createPartControl(Composite parent) {
        this.console = new TextConsole(parent, 0);
        this.console.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractCommandResults.this.actionCopy.setEnabled(AbstractCommandResults.this.console.canCopy());
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objecttools.context.ObjectTools");
        }
    }

    protected void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionClear = new Action(Messages.LocalCommandResults_ClearConsole, SharedIcons.CLEAR_LOG){

            public void run() {
                AbstractCommandResults.this.console.clear();
            }
        };
        this.actionClear.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.clear_output");
        handlerService.activateHandler(this.actionClear.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionClear));
        Messages.get();
        this.actionScrollLock = new Action(Messages.LocalCommandResults_ScrollLock, 2){

            public void run() {
                AbstractCommandResults.this.console.setAutoScroll(!AbstractCommandResults.this.actionScrollLock.isChecked());
            }
        };
        this.actionScrollLock.setImageDescriptor(Activator.getImageDescriptor("icons/scroll_lock.gif"));
        this.actionScrollLock.setChecked(false);
        this.actionScrollLock.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.scroll_lock");
        handlerService.activateHandler(this.actionScrollLock.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionScrollLock));
        Messages.get();
        this.actionCopy = new Action(Messages.LocalCommandResults_Copy){

            public void run() {
                AbstractCommandResults.this.console.copy();
            }
        };
        this.actionCopy.setEnabled(false);
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.copy");
        handlerService.activateHandler(this.actionCopy.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopy));
        Messages.get();
        this.actionSelectAll = new Action(Messages.LocalCommandResults_SelectAll){

            public void run() {
                AbstractCommandResults.this.console.selectAll();
            }
        };
        this.actionSelectAll.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.select_all");
        handlerService.activateHandler(this.actionSelectAll.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSelectAll));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractCommandResults.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.console);
        this.console.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void setFocus() {
        this.console.setFocus();
    }
}

