/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.api;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectListener;
import org.netxms.ui.eclipse.datacollection.propertypages.TableColumns;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DataCollectionObjectEditor {
    private DataCollectionObject object;
    private long sourceNode;
    private Runnable timer;
    private Set<DataCollectionObjectListener> listeners = new HashSet<DataCollectionObjectListener>();
    private TableColumns.TableColumnDataProvider callback;

    public DataCollectionObjectEditor(DataCollectionObject object) {
        this.object = object;
        this.timer = new Runnable(){

            @Override
            public void run() {
                DataCollectionObjectEditor.this.doObjectModification();
            }
        };
    }

    private void doObjectModification() {
        Messages.get();
        new ConsoleJob(Messages.DataCollectionObjectEditor_JobName, null, "org.netxms.ui.eclipse.datacollection", null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final boolean isNewObj = DataCollectionObjectEditor.this.object.isNewItem();
                DataCollectionObjectEditor dataCollectionObjectEditor = DataCollectionObjectEditor.this;
                synchronized (dataCollectionObjectEditor) {
                    if (isNewObj) {
                        if (DataCollectionObjectEditor.this.object instanceof DataCollectionItem) {
                            DataCollectionObjectEditor.this.object.getOwner().createItem(DataCollectionObjectEditor.this.object);
                        } else if (DataCollectionObjectEditor.this.object instanceof DataCollectionTable) {
                            DataCollectionObjectEditor.this.object.getOwner().createTable(DataCollectionObjectEditor.this.object);
                        }
                    }
                    DataCollectionObjectEditor.this.object.getOwner().modifyObject(DataCollectionObjectEditor.this.object);
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Object data = DataCollectionObjectEditor.this.object.getOwner().getUserData();
                        if (data != null && data instanceof TableViewer) {
                            if (isNewObj) {
                                ((TableViewer)data).setInput((Object)DataCollectionObjectEditor.this.object.getOwner().getItems());
                            }
                            ((TableViewer)data).update((Object)DataCollectionObjectEditor.this.object, null);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DataCollectionObjectEditor_JobError;
            }
        }.start();
    }

    public void modify() {
        Display.getCurrent().timerExec(-1, this.timer);
        Display.getCurrent().timerExec(200, this.timer);
    }

    public void addListener(DataCollectionObjectListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DataCollectionObjectListener listener) {
        this.listeners.remove(listener);
    }

    public void fireOnSelectItemListeners(int origin, String name, String description, int dataType) {
        for (DataCollectionObjectListener l : this.listeners) {
            l.onSelectItem(origin, name, description, dataType);
        }
    }

    public void fireOnSelectTableListeners(int origin, String name, String description) {
        for (DataCollectionObjectListener l : this.listeners) {
            l.onSelectTable(origin, name, description);
        }
    }

    public DataCollectionObject getObject() {
        return this.object;
    }

    public DataCollectionItem getObjectAsItem() {
        return (DataCollectionItem)this.object;
    }

    public DataCollectionTable getObjectAsTable() {
        return (DataCollectionTable)this.object;
    }

    public TableColumns.TableColumnDataProvider getCallback() {
        return this.callback;
    }

    public void setCallback(TableColumns.TableColumnDataProvider callback) {
        this.callback = callback;
    }

    public void setSourceNode(long nodeId) {
        this.sourceNode = nodeId;
    }

    public long getSourceNode() {
        return this.sourceNode;
    }

    public static String createModificationWarningMessage(DataCollectionObject dco) {
        String message = null;
        if (dco.getTemplateId() == dco.getNodeId()) {
            message = "This DCI was added by instance discovery\nAll local changes can be overwritten at any moment";
        } else if (dco.getTemplateId() != 0L) {
            AbstractObject object = ConsoleSharedData.getSession().findObjectById(dco.getTemplateId());
            message = object != null ? String.format("This DCI was added by %s \"%s\"\nAll local changes can be overwritten at any moment", object.getObjectClass() == 14 ? "cluster" : "template", object.getObjectName()) : String.format("This DCI was added by unknown object with ID %d\nAll local changes can be overwritten at any moment", dco.getTemplateId());
        }
        return message;
    }
}

