/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.views.helpers.RoutingTableComparator;
import org.netxms.ui.eclipse.topology.views.helpers.RoutingTableLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RoutingTableView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.RoutingTableView";
    public static final int COLUMN_DESTINATION = 0;
    public static final int COLUMN_NEXT_HOP = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_TYPE = 3;
    private NXCSession session;
    private long rootObject;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.rootObject = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException numberFormatException) {
            this.rootObject = 0L;
        }
        this.session = ConsoleSharedData.getSession();
        Messages.get();
        this.setPartName(String.format(Messages.RoutingTableView_Title, this.session.getObjectName(this.rootObject)));
    }

    public void createPartControl(Composite parent) {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.RoutingTableView_Destination;
        Messages.get();
        stringArray[1] = Messages.RoutingTableView_NextHop;
        Messages.get();
        stringArray[2] = Messages.RoutingTableView_Interface;
        Messages.get();
        stringArray[3] = Messages.RoutingTableView_Type;
        String[] names = stringArray;
        int[] widths = new int[]{180, 140, 200, 140};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RoutingTableLabelProvider());
        this.viewer.setComparator((ViewerComparator)new RoutingTableComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"RoutingTable");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)RoutingTableView.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"RoutingTable");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                RoutingTableView.this.refresh();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RoutingTableView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.RoutingTableView_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List rt = RoutingTableView.this.session.getRoutingTable(RoutingTableView.this.rootObject);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        RoutingTableView.this.viewer.setInput((Object)rt.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.RoutingTableView_JobError, RoutingTableView.this.session.getObjectName(RoutingTableView.this.rootObject));
            }
        }.start();
    }
}

