/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import com.jcraft.jzlib.Deflater;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.base.EncryptionContext;
import org.netxms.base.GeoLocation;
import org.netxms.base.InetAddressEx;
import org.netxms.base.Logger;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCPMessageReceiver;
import org.netxms.base.NXCPMsgWaitQueue;
import org.netxms.client.AccessListElement;
import org.netxms.client.AgentFileData;
import org.netxms.client.AgentFileInfo;
import org.netxms.client.AgentParameter;
import org.netxms.client.AgentTable;
import org.netxms.client.AgentTunnel;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.LibraryImage;
import org.netxms.client.MessageHandler;
import org.netxms.client.NXCException;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCReceivedFile;
import org.netxms.client.ObjectFilter;
import org.netxms.client.ObjectQueryResult;
import org.netxms.client.ObjectUrl;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.ProgressListener;
import org.netxms.client.ProtocolVersion;
import org.netxms.client.ReceivedFile;
import org.netxms.client.ScheduledTask;
import org.netxms.client.Script;
import org.netxms.client.ScriptCompilationResult;
import org.netxms.client.ServerAction;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.SoftwarePackage;
import org.netxms.client.Table;
import org.netxms.client.TcpProxy;
import org.netxms.client.TextOutputListener;
import org.netxms.client.agent.config.ConfigContent;
import org.netxms.client.agent.config.ConfigListElement;
import org.netxms.client.constants.AggregationFunction;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.client.constants.NodePollType;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ConditionDciInfo;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.DciPushData;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphFolder;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.datacollection.PredictionEngine;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.datacollection.ThresholdViolationSummary;
import org.netxms.client.datacollection.TransformationTestResult;
import org.netxms.client.datacollection.WinPerfObject;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.events.AlarmComment;
import org.netxms.client.events.BulkAlarmStateChangeData;
import org.netxms.client.events.Event;
import org.netxms.client.events.EventInfo;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.events.SyslogRecord;
import org.netxms.client.log.Log;
import org.netxms.client.maps.MapDCIInstance;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.market.Repository;
import org.netxms.client.mt.MappingTable;
import org.netxms.client.mt.MappingTableDescriptor;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.client.objects.AgentPolicyConfig;
import org.netxms.client.objects.AgentPolicyLogParser;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.NodeLink;
import org.netxms.client.objects.PolicyGroup;
import org.netxms.client.objects.PolicyRoot;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceCheck;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.client.objects.UnknownObject;
import org.netxms.client.objects.VPNConnector;
import org.netxms.client.objects.Zone;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.packages.PackageDeploymentListener;
import org.netxms.client.packages.PackageInfo;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.client.reporting.ReportRenderFormat;
import org.netxms.client.reporting.ReportResult;
import org.netxms.client.reporting.ReportingJob;
import org.netxms.client.server.AgentFile;
import org.netxms.client.server.ServerConsoleListener;
import org.netxms.client.server.ServerFile;
import org.netxms.client.server.ServerJob;
import org.netxms.client.server.ServerJobIdUpdater;
import org.netxms.client.server.ServerVariable;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.client.snmp.SnmpTrapLogRecord;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.client.topology.FdbEntry;
import org.netxms.client.topology.NetworkPath;
import org.netxms.client.topology.Route;
import org.netxms.client.topology.VlanInfo;
import org.netxms.client.topology.WirelessStation;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.AuthCertificate;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.client.zeromq.ZmqSubscription;
import org.netxms.client.zeromq.ZmqSubscriptionType;

public class NXCSession {
    public static final int DEFAULT_CONN_PORT = 4701;
    public static final String CHANNEL_EVENTS = "Core.Events";
    public static final String CHANNEL_SYSLOG = "Core.Syslog";
    public static final String CHANNEL_ALARMS = "Core.Alarms";
    public static final String CHANNEL_OBJECTS = "Core.Objects";
    public static final String CHANNEL_SNMP_TRAPS = "Core.SNMP.Traps";
    public static final String CHANNEL_AUDIT_LOG = "Core.Audit";
    public static final String CHANNEL_USERDB = "Core.UserDB";
    public static final int OBJECT_SYNC_NOTIFY = 1;
    public static final int OBJECT_SYNC_WAIT = 2;
    public static final int CFG_IMPORT_REPLACE_EVENT_BY_CODE = 1;
    public static final int CFG_IMPORT_REPLACE_EVENT_BY_NAME = 2;
    public static final int ADDRESS_LIST_DISCOVERY_TARGETS = 1;
    public static final int ADDRESS_LIST_DISCOVERY_FILTER = 2;
    public static final int SERVER_COMPONENT_DISCOVERY_MANAGER = 1;
    public static final int DESKTOP_CLIENT = 0;
    public static final int WEB_CLIENT = 1;
    public static final int MOBILE_CLIENT = 2;
    public static final int TABLET_CLIENT = 3;
    public static final int APPLICATION_CLIENT = 4;
    private static final int CLIENT_CHALLENGE_SIZE = 256;
    private static final int MAX_DCI_DATA_ROWS = 200000;
    private static final int MAX_DCI_STRING_VALUE_LENGTH = 256;
    private static final int RECEIVED_FILE_TTL = 300000;
    private static final int FILE_BUFFER_SIZE = 32768;
    private final Semaphore syncObjects = new Semaphore(1);
    private final Semaphore syncUserDB = new Semaphore(1);
    private String connAddress;
    private int connPort;
    private boolean connUseEncryption;
    private String connClientInfo = "nxjclient/2.2.11";
    private int clientType = 0;
    private String clientAddress = null;
    private boolean ignoreProtocolVersion = false;
    private String clientLanguage = "en";
    private int sessionId;
    private int userId;
    private String userName;
    private AuthenticationType authenticationMethod;
    private long userSystemRights;
    private boolean passwordExpired;
    private int graceLogins;
    private Socket socket = null;
    private NXCPMsgWaitQueue msgWaitQueue = null;
    private ReceiverThread recvThread = null;
    private HousekeeperThread housekeeperThread = null;
    private AtomicLong requestId = new AtomicLong(1L);
    private boolean connected = false;
    private boolean disconnected = false;
    private boolean serverConsoleConnected = false;
    private boolean allowCompression = false;
    private EncryptionContext encryptionContext = null;
    private int defaultRecvBufferSize = 0x400000;
    private int maxRecvBufferSize = 0x2000000;
    private int connectTimeout = 10000;
    private int commandTimeout = 30000;
    private int serverCommandOutputTimeout = 60000;
    private LinkedBlockingQueue<SessionNotification> notificationQueue = new LinkedBlockingQueue(8192);
    private Set<SessionListener> listeners = new HashSet<SessionListener>(0);
    private Set<ServerConsoleListener> consoleListeners = new HashSet<ServerConsoleListener>(0);
    private Map<Long, ProgressListener> progressListeners = new HashMap<Long, ProgressListener>(0);
    private Map<MessageSubscription, MessageHandler> messageSubscriptions = new HashMap<MessageSubscription, MessageHandler>(0);
    private Map<Long, NXCReceivedFile> receivedFiles = new HashMap<Long, NXCReceivedFile>();
    private Map<String, String> receivedFileUpdates = new HashMap<String, String>();
    private ProtocolVersion protocolVersion;
    private String serverVersion = "(unknown)";
    private long serverId = 0L;
    private String serverTimeZone;
    private byte[] serverChallenge = new byte[256];
    private boolean zoningEnabled = false;
    private boolean helpdeskLinkActive = false;
    private String tileServerURL;
    private String dateFormat;
    private String timeFormat;
    private String shortTimeFormat;
    private int defaultDciRetentionTime;
    private int defaultDciPollingInterval;
    private boolean strictAlarmStatusFlow;
    private boolean timedAlarmAckEnabled;
    private int minViewRefreshInterval;
    private long serverTime = System.currentTimeMillis();
    private long serverTimeRecvTime = System.currentTimeMillis();
    private Set<String> serverComponents = new HashSet<String>(0);
    private String serverName;
    private String serverColor;
    private Map<String, String> clientConfigurationHints = new HashMap<String, String>();
    private Map<Long, AbstractObject> objectList = new HashMap<Long, AbstractObject>();
    private Map<UUID, AbstractObject> objectListGUID = new HashMap<UUID, AbstractObject>();
    private Map<Long, Zone> zoneList = new HashMap<Long, Zone>();
    private boolean objectsSynchronized = false;
    private Map<Long, AbstractUserObject> userDB = new HashMap<Long, AbstractUserObject>();
    private Map<Long, EventTemplate> eventTemplates = new HashMap<Long, EventTemplate>();
    private boolean eventTemplatesNeedSync = false;
    private Map<Long, AlarmCategory> alarmCategories = new HashMap<Long, AlarmCategory>();
    private boolean alarmCategoriesNeedSync = false;
    private String messageOfTheDay;
    private Map<Integer, TcpProxy> tcpProxies = new HashMap<Integer, TcpProxy>();

    public NXCSession(String connAddress) {
        this(connAddress, 4701, false);
    }

    public NXCSession(String connAddress, int connPort) {
        this(connAddress, connPort, false);
    }

    public NXCSession(String connAddress, int connPort, boolean connUseEncryption) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connUseEncryption = connUseEncryption;
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect(1);
        }
        finally {
            super.finalize();
        }
    }

    protected AbstractObject createCustomObjectFromMessage(int objectClass, NXCPMessage msg) {
        return null;
    }

    private AbstractObject createObjectFromMessage(NXCPMessage msg) {
        int objectClass = msg.getFieldAsInt32(5L);
        AbstractObject object = this.createCustomObjectFromMessage(objectClass, msg);
        if (object != null) {
            return object;
        }
        switch (objectClass) {
            case 33: {
                object = new AccessPoint(msg, this);
                break;
            }
            case 17: {
                object = new AgentPolicy(msg, this);
                break;
            }
            case 18: {
                object = new AgentPolicyConfig(msg, this);
                break;
            }
            case 34: {
                object = new AgentPolicyLogParser(msg, this);
                break;
            }
            case 28: {
                object = new BusinessService(msg, this);
                break;
            }
            case 27: {
                object = new BusinessServiceRoot(msg, this);
                break;
            }
            case 35: {
                object = new Chassis(msg, this);
                break;
            }
            case 14: {
                object = new Cluster(msg, this);
                break;
            }
            case 13: {
                object = new Condition(msg, this);
                break;
            }
            case 5: {
                object = new Container(msg, this);
                break;
            }
            case 36: {
                object = new DashboardGroup(msg, this);
                break;
            }
            case 23: {
                object = new Dashboard(msg, this);
                break;
            }
            case 22: {
                object = new DashboardRoot(msg, this);
                break;
            }
            case 3: {
                object = new Interface(msg, this);
                break;
            }
            case 31: {
                object = new MobileDevice(msg, this);
                break;
            }
            case 4: {
                object = new EntireNetwork(msg, this);
                break;
            }
            case 21: {
                object = new NetworkMap(msg, this);
                break;
            }
            case 20: {
                object = new NetworkMapGroup(msg, this);
                break;
            }
            case 19: {
                object = new NetworkMapRoot(msg, this);
                break;
            }
            case 11: {
                object = new NetworkService(msg, this);
                break;
            }
            case 2: {
                object = new Node(msg, this);
                break;
            }
            case 29: {
                object = new NodeLink(msg, this);
                break;
            }
            case 15: {
                object = new PolicyGroup(msg, this);
                break;
            }
            case 16: {
                object = new PolicyRoot(msg, this);
                break;
            }
            case 32: {
                object = new Rack(msg, this);
                break;
            }
            case 7: {
                object = new ServiceRoot(msg, this);
                break;
            }
            case 30: {
                object = new ServiceCheck(msg, this);
                break;
            }
            case 1: {
                object = new Subnet(msg, this);
                break;
            }
            case 8: {
                object = new Template(msg, this);
                break;
            }
            case 9: {
                object = new TemplateGroup(msg, this);
                break;
            }
            case 10: {
                object = new TemplateRoot(msg, this);
                break;
            }
            case 12: {
                object = new VPNConnector(msg, this);
                break;
            }
            case 6: {
                object = new Zone(msg, this);
                break;
            }
            default: {
                object = new GenericObject(msg, this);
            }
        }
        return object;
    }

    private void setupEncryption(NXCPMessage msg) throws IOException, NXCException {
        NXCPMessage response = new NXCPMessage(132, msg.getMessageId());
        response.setEncryptionDisabled(true);
        try {
            this.encryptionContext = EncryptionContext.createInstance((NXCPMessage)msg);
            response.setField(155L, this.encryptionContext.getEncryptedSessionKey(msg));
            response.setField(158L, this.encryptionContext.getEncryptedIv(msg));
            response.setFieldInt16(156L, this.encryptionContext.getCipher());
            response.setFieldInt16(157L, this.encryptionContext.getKeyLength());
            response.setFieldInt16(238L, this.encryptionContext.getIvLength());
            response.setFieldInt32(28L, 0);
            Logger.debug((String)"NXCSession.setupEncryption", (String)("Cipher selected: " + EncryptionContext.getCipherName((int)this.encryptionContext.getCipher())));
        }
        catch (Exception exception) {
            response.setFieldInt32(28L, 42);
        }
        this.sendMessage(response);
    }

    private void waitForSync(Semaphore syncObject, int timeout) throws NXCException {
        if (timeout == 0) {
            syncObject.acquireUninterruptibly();
        } else {
            long actualTimeout = timeout;
            boolean success = false;
            while (actualTimeout > 0L) {
                long startTime = System.currentTimeMillis();
                try {
                    if (this.syncObjects.tryAcquire(actualTimeout, TimeUnit.MILLISECONDS)) {
                        success = true;
                        this.syncObjects.release();
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {}
                actualTimeout -= System.currentTimeMillis() - startTime;
            }
            if (!success) {
                throw new NXCException(4);
            }
        }
    }

    private void completeSync(Semaphore syncObject) {
        syncObject.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SessionListener listener) {
        boolean changed;
        Set<SessionListener> set = this.listeners;
        synchronized (set) {
            changed = this.listeners.add(listener);
        }
        if (changed) {
            this.notificationQueue.offer(new SessionNotification(32766));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SessionListener listener) {
        boolean changed;
        Set<SessionListener> set = this.listeners;
        synchronized (set) {
            changed = this.listeners.remove(listener);
        }
        if (changed) {
            this.notificationQueue.offer(new SessionNotification(32766));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsoleListener(ServerConsoleListener listener) {
        Set<ServerConsoleListener> set = this.consoleListeners;
        synchronized (set) {
            this.consoleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsoleListener(ServerConsoleListener listener) {
        Set<ServerConsoleListener> set = this.consoleListeners;
        synchronized (set) {
            this.consoleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageSubscription(int messageCode, long messageId, MessageHandler handler) {
        Map<MessageSubscription, MessageHandler> map = this.messageSubscriptions;
        synchronized (map) {
            this.messageSubscriptions.put(new MessageSubscription(messageCode, messageId), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageSubscription(int messageCode, long messageId) {
        Map<MessageSubscription, MessageHandler> map = this.messageSubscriptions;
        synchronized (map) {
            this.messageSubscriptions.remove(new MessageSubscription(messageCode, messageId));
        }
    }

    protected void sendNotification(SessionNotification n) {
        if (!this.notificationQueue.offer(n)) {
            Logger.debug((String)"NXCSession.sendNotification", (String)"Notification processing queue is full");
        }
    }

    public synchronized void sendMessage(NXCPMessage msg) throws IOException, NXCException {
        byte[] message;
        if (this.socket == null) {
            throw new IllegalStateException("Not connected to the server. Did you forgot to call connect() first?");
        }
        OutputStream outputStream = this.socket.getOutputStream();
        if (this.encryptionContext != null && !msg.isEncryptionDisabled()) {
            try {
                message = this.encryptionContext.encryptMessage(msg, this.allowCompression);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new NXCException(98);
            }
        } else {
            message = msg.createNXCPMessage(this.allowCompression);
        }
        outputStream.write(message);
    }

    protected void sendFile(long requestId, File file, ProgressListener listener, boolean allowStreamCompression) throws IOException, NXCException {
        if (listener != null) {
            listener.setTotalWorkAmount(file.length());
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        this.sendFileStream(requestId, inputStream, listener, allowStreamCompression);
        ((InputStream)inputStream).close();
    }

    protected void sendFile(long requestId, byte[] data, ProgressListener listener, boolean allowStreamCompression) throws IOException, NXCException {
        if (listener != null) {
            listener.setTotalWorkAmount(data.length);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        this.sendFileStream(requestId, inputStream, listener, allowStreamCompression);
        ((InputStream)inputStream).close();
    }

    private void sendFileStream(long requestId, InputStream inputStream, ProgressListener listener, boolean allowStreamCompression) throws IOException, NXCException {
        int bytesRead;
        NXCPMessage msg = new NXCPMessage(105, requestId);
        msg.setBinaryMessage(true);
        Deflater compressor = allowStreamCompression ? new Deflater(9) : null;
        msg.setStream(true, allowStreamCompression);
        boolean success = false;
        byte[] buffer = new byte[32768];
        long bytesSent = 0L;
        do {
            if ((bytesRead = inputStream.read(buffer)) < 32768) {
                msg.setEndOfFile(true);
            }
            if (compressor != null && bytesRead > 0) {
                byte[] compressedData = new byte[compressor.deflateBound(bytesRead) + 4];
                compressor.setInput(buffer, 0, bytesRead, false);
                compressor.setOutput(compressedData, 4, compressedData.length - 4);
                if (compressor.deflate(2) != 0) {
                    throw new NXCException(16);
                }
                int length = compressedData.length - compressor.getAvailOut();
                byte[] payload = Arrays.copyOf(compressedData, length);
                payload[0] = 2;
                payload[1] = 0;
                payload[2] = (byte)(bytesRead >> 8 & 0xFF);
                payload[3] = (byte)(bytesRead & 0xFF);
                msg.setBinaryData(payload);
            } else {
                msg.setBinaryData(bytesRead == -1 ? new byte[]{} : Arrays.copyOf(buffer, bytesRead));
            }
            this.sendMessage(msg);
            bytesSent += (long)(bytesRead == -1 ? 0 : bytesRead);
            if (listener == null) continue;
            listener.markProgress(bytesSent);
        } while (bytesRead >= 32768);
        success = true;
        if (compressor != null) {
            compressor.deflateEnd();
        }
        if (!success) {
            NXCPMessage abortMessage = new NXCPMessage(114, requestId);
            abortMessage.setBinaryMessage(true);
            this.sendMessage(abortMessage);
            this.waitForRCC(abortMessage.getMessageId());
        }
    }

    public NXCPMessage waitForMessage(int code, long id, int timeout) throws NXCException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id, timeout);
        if (msg == null) {
            throw new NXCException(4);
        }
        return msg;
    }

    public NXCPMessage waitForMessage(int code, long id) throws NXCException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id);
        if (msg == null) {
            throw new NXCException(4);
        }
        return msg;
    }

    public NXCPMessage waitForRCC(long id) throws NXCException {
        return this.waitForRCC(id, this.msgWaitQueue.getDefaultTimeout());
    }

    public NXCPMessage waitForRCC(long id, int timeout) throws NXCException {
        NXCPMessage msg = this.waitForMessage(29, id, timeout);
        int rcc = msg.getFieldAsInt32(28L);
        if (rcc != 0) {
            if (rcc == 1 && msg.findField(29L) != null) {
                throw new NXCException(rcc, msg.getFieldAsString(29L));
            }
            if (msg.findField(259L) != null) {
                throw new NXCException(rcc, msg.getFieldAsString(259L));
            }
            if (msg.findField(21L) != null) {
                throw new NXCException(rcc, msg.getFieldAsString(21L));
            }
            throw new NXCException(rcc);
        }
        return msg;
    }

    public final NXCPMessage newMessage(int code) {
        return new NXCPMessage(code, this.requestId.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceivedFile waitForFile(long id, int timeout) {
        int timeRemaining = timeout;
        File file = null;
        int status = 2;
        while (timeRemaining > 0) {
            Map<Long, NXCReceivedFile> map = this.receivedFiles;
            synchronized (map) {
                NXCReceivedFile rf = this.receivedFiles.get(id);
                if (rf != null && rf.getStatus() != 0) {
                    if (rf.getStatus() == 1) {
                        file = rf.getFile();
                        status = 0;
                    }
                    break;
                }
                long startTime = System.currentTimeMillis();
                try {
                    this.receivedFiles.wait(timeRemaining);
                }
                catch (InterruptedException interruptedException) {}
                timeRemaining = (int)((long)timeRemaining - (System.currentTimeMillis() - startTime));
            }
        }
        return new ReceivedFile(file, timeRemaining <= 0 ? 3 : status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitForFileTail(String fileName, int timeout) {
        int timeRemaining = timeout;
        String tail = null;
        while (timeRemaining > 0) {
            Map<String, String> map = this.receivedFileUpdates;
            synchronized (map) {
                tail = this.receivedFileUpdates.get(fileName);
                if (tail != null) {
                    this.receivedFileUpdates.remove(fileName);
                    break;
                }
                long startTime = System.currentTimeMillis();
                try {
                    this.receivedFileUpdates.wait(timeRemaining);
                }
                catch (InterruptedException interruptedException) {}
                timeRemaining = (int)((long)timeRemaining - (System.currentTimeMillis() - startTime));
            }
        }
        return tail;
    }

    protected void executeSimpleCommand(int command) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(command);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Table receiveTable(long requestId, int msgCode) throws NXCException {
        NXCPMessage msg = this.waitForMessage(msgCode, requestId);
        Table table = new Table(msg);
        while (!msg.isEndOfSequence()) {
            msg = this.waitForMessage(msgCode, requestId);
            table.addDataFromMessage(msg);
        }
        return table;
    }

    public void connect() throws IOException, UnknownHostException, NXCException, IllegalStateException {
        this.connect(null);
    }

    public void connect(int[] componentVersions) throws IOException, UnknownHostException, NXCException, IllegalStateException {
        if (this.connected) {
            throw new IllegalStateException("Session already connected");
        }
        if (this.disconnected) {
            throw new IllegalStateException("Session already disconnected and cannot be reused");
        }
        this.encryptionContext = null;
        Logger.info((String)"NXCSession.connect", (String)("Connecting to " + this.connAddress + ":" + this.connPort));
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.connAddress, this.connPort), this.connectTimeout);
            this.msgWaitQueue = new NXCPMsgWaitQueue(this.commandTimeout);
            this.recvThread = new ReceiverThread();
            this.housekeeperThread = new HousekeeperThread();
            new NotificationProcessor();
            Logger.debug((String)"NXCSession.connect", (String)"connection established, retrieving server info");
            NXCPMessage request = this.newMessage(103);
            this.sendMessage(request);
            NXCPMessage response = this.waitForMessage(29, request.getMessageId());
            this.protocolVersion = new ProtocolVersion(response);
            if (!this.ignoreProtocolVersion) {
                if (!this.protocolVersion.isCorrectVersion(0) || componentVersions != null && !this.validateProtocolVersions(componentVersions)) {
                    Logger.warning((String)"NXCSession.connect", (String)("connection failed (" + this.protocolVersion.toString() + ")"));
                    throw new NXCException(40, this.protocolVersion.toString());
                }
            } else {
                Logger.debug((String)"NXCSession.connect", (String)"protocol version ignored");
            }
            this.serverVersion = response.getFieldAsString(121L);
            this.serverId = response.getFieldAsInt64(142L);
            this.serverTimeZone = response.getFieldAsString(308L);
            this.serverTime = response.getFieldAsInt64(94L) * 1000L;
            this.serverTimeRecvTime = System.currentTimeMillis();
            this.serverChallenge = response.getFieldAsBinary(278L);
            this.tileServerURL = response.getFieldAsString(384L);
            if (this.tileServerURL != null) {
                if (!this.tileServerURL.endsWith("/")) {
                    this.tileServerURL = this.tileServerURL.concat("/");
                }
            } else {
                this.tileServerURL = "http://tile.openstreetmap.org/";
            }
            this.dateFormat = response.getFieldAsString(421L);
            if (this.dateFormat == null || this.dateFormat.length() == 0) {
                this.dateFormat = "dd.MM.yyyy";
            }
            this.timeFormat = response.getFieldAsString(422L);
            if (this.timeFormat == null || this.timeFormat.length() == 0) {
                this.timeFormat = "HH:mm:ss";
            }
            this.shortTimeFormat = response.getFieldAsString(453L);
            if (this.shortTimeFormat == null || this.shortTimeFormat.length() == 0) {
                this.shortTimeFormat = "HH:mm";
            }
            int count = response.getFieldAsInt32(560L);
            long fieldId = 0x20000000L;
            int i = 0;
            while (i < count) {
                this.serverComponents.add(response.getFieldAsString(fieldId++));
                ++i;
            }
            if (this.connUseEncryption) {
                request = this.newMessage(133);
                request.setFieldInt16(319L, 1);
                this.sendMessage(request);
                this.waitForRCC(request.getMessageId());
            }
            Logger.debug((String)"NXCSession.connect", (String)("Connected to server version " + this.serverVersion));
            this.connected = true;
        }
        finally {
            if (!this.connected) {
                this.disconnect(2002);
            }
        }
    }

    public void login(String login, String password) throws NXCException, IOException, IllegalStateException {
        this.login(AuthenticationType.PASSWORD, login, password, null, null);
    }

    public void login(String login, Certificate certificate, Signature signature) throws NXCException, IOException, IllegalStateException {
        this.login(AuthenticationType.CERTIFICATE, login, null, certificate, signature);
    }

    public void login(AuthenticationType authType, String login, String password, Certificate certificate, Signature signature) throws NXCException, IOException, IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("Session not connected");
        }
        if (this.disconnected) {
            throw new IllegalStateException("Session already disconnected and cannot be reused");
        }
        this.authenticationMethod = authType;
        this.userName = login;
        NXCPMessage request = this.newMessage(1);
        request.setFieldInt16(275L, authType.getValue());
        request.setField(1L, login);
        if (authType == AuthenticationType.PASSWORD || authType == AuthenticationType.SSO_TICKET) {
            request.setField(2L, password);
        } else if (authType == AuthenticationType.CERTIFICATE) {
            if (this.serverChallenge == null || signature == null || certificate == null) {
                throw new NXCException(98);
            }
            byte[] signedChallenge = this.signChallenge(signature, this.serverChallenge);
            request.setField(277L, signedChallenge);
            try {
                request.setField(276L, certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new NXCException(98);
            }
        }
        request.setField(177L, "2.2.11");
        request.setField(175L, this.connClientInfo);
        request.setField(176L, String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version"));
        request.setFieldInt16(170L, this.clientType);
        if (this.clientAddress != null) {
            request.setField(452L, this.clientAddress);
        }
        if (this.clientLanguage != null) {
            request.setField(479L, this.clientLanguage);
        }
        request.setFieldInt16(570L, 1);
        this.sendMessage(request);
        NXCPMessage response = this.waitForMessage(2, request.getMessageId());
        int rcc = response.getFieldAsInt32(28L);
        Logger.debug((String)"NXCSession.login", (String)("CMD_LOGIN_RESP received, RCC=" + rcc));
        if (rcc != 0) {
            Logger.warning((String)"NXCSession.login", (String)("Login failed, RCC=" + rcc));
            throw new NXCException(rcc);
        }
        this.userId = response.getFieldAsInt32(35L);
        this.sessionId = response.getFieldAsInt32(209L);
        this.userSystemRights = response.getFieldAsInt64(36L);
        this.passwordExpired = response.getFieldAsBoolean(221L);
        this.graceLogins = response.getFieldAsInt32(576L);
        this.zoningEnabled = response.getFieldAsBoolean(148L);
        this.helpdeskLinkActive = response.getFieldAsBoolean(470L);
        this.defaultDciPollingInterval = response.getFieldAsInt32(44L);
        if (this.defaultDciPollingInterval == 0) {
            this.defaultDciPollingInterval = 60;
        }
        this.defaultDciRetentionTime = response.getFieldAsInt32(45L);
        if (this.defaultDciRetentionTime == 0) {
            this.defaultDciRetentionTime = 30;
        }
        this.minViewRefreshInterval = response.getFieldAsInt32(473L);
        if (this.minViewRefreshInterval <= 0) {
            this.minViewRefreshInterval = 200;
        }
        this.strictAlarmStatusFlow = response.getFieldAsBoolean(461L);
        this.timedAlarmAckEnabled = response.getFieldAsBoolean(465L);
        this.serverCommandOutputTimeout = response.getFieldAsInt32(514L) * 1000;
        this.serverColor = response.getFieldAsString(562L);
        this.serverName = response.getFieldAsString(561L);
        if (this.serverName == null || this.serverName.isEmpty()) {
            this.serverName = this.connAddress;
        }
        int count = response.getFieldAsInt32(478L);
        this.clientConfigurationHints.put("AlarmList.DisplayLimit", Integer.toString(count));
        count = response.getFieldAsInt32(618L);
        if (count > 0) {
            long fieldId = 0x10000000L;
            int i = 0;
            while (i < count) {
                String key = response.getFieldAsString(fieldId++);
                String value = response.getFieldAsString(fieldId++);
                this.clientConfigurationHints.put(key, value);
                Logger.info((String)"NXCSession.login", (String)("configuration hint: " + key + " = " + value));
                ++i;
            }
        }
        this.messageOfTheDay = response.getFieldAsString(563L);
        this.allowCompression = response.getFieldAsBoolean(570L);
        Logger.info((String)"NXCSession.login", (String)("succesfully logged in, userId=" + this.userId));
    }

    private void backgroundDisconnect(final int reason) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                NXCSession.this.disconnect(reason);
            }
        }, "NXCSession disconnect");
        t.setDaemon(true);
        t.start();
    }

    private synchronized void disconnect(int reason) {
        if (this.disconnected) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
        this.notificationQueue.clear();
        if (reason != 2002) {
            this.notificationQueue.offer(new SessionNotification(reason));
        }
        this.notificationQueue.offer(new SessionNotification(Short.MAX_VALUE));
        if (this.recvThread != null) {
            while (this.recvThread.isAlive()) {
                try {
                    this.recvThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.recvThread = null;
        }
        if (this.housekeeperThread != null) {
            this.housekeeperThread.setStopFlag(true);
            while (this.housekeeperThread.isAlive()) {
                try {
                    this.housekeeperThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.housekeeperThread = null;
        }
        if (this.msgWaitQueue != null) {
            this.msgWaitQueue.shutdown();
            this.msgWaitQueue = null;
        }
        this.connected = false;
        this.disconnected = true;
        this.socket = null;
        this.listeners.clear();
        this.consoleListeners.clear();
        this.messageSubscriptions.clear();
        this.receivedFiles.clear();
        this.receivedFileUpdates.clear();
        this.objectList.clear();
        this.objectListGUID.clear();
        this.zoneList.clear();
        this.eventTemplates.clear();
        this.userDB.clear();
        this.alarmCategories.clear();
        this.tcpProxies.clear();
    }

    public void disconnect() {
        this.disconnect(2002);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isEncrypted() {
        return this.connUseEncryption;
    }

    public boolean isIgnoreProtocolVersion() {
        return this.ignoreProtocolVersion;
    }

    public void setIgnoreProtocolVersion(boolean ignoreProtocolVersion) {
        this.ignoreProtocolVersion = ignoreProtocolVersion;
    }

    public boolean validateProtocolVersions(int[] versions) {
        if (this.protocolVersion == null) {
            return false;
        }
        int[] nArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (!this.protocolVersion.isCorrectVersion(index)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int getDefaultRecvBufferSize() {
        return this.defaultRecvBufferSize;
    }

    public int getMaxRecvBufferSize() {
        return this.maxRecvBufferSize;
    }

    public void setRecvBufferSize(int defaultBufferSize, int maxBufferSize) {
        this.defaultRecvBufferSize = defaultBufferSize;
        this.maxRecvBufferSize = maxBufferSize;
    }

    public String getServerAddress() {
        return this.connAddress;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public long getServerId() {
        return this.serverId;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerColor() {
        return this.serverColor;
    }

    public long getServerTime() {
        long offset = System.currentTimeMillis() - this.serverTimeRecvTime;
        return this.serverTime + offset;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public boolean isServerComponentRegistered(String componentId) {
        return this.serverComponents.contains(componentId);
    }

    public String[] getRegisteredServerComponents() {
        return this.serverComponents.toArray(new String[this.serverComponents.size()]);
    }

    public String getTileServerURL() {
        return this.tileServerURL;
    }

    public boolean isZoningEnabled() {
        return this.zoningEnabled;
    }

    public boolean isHelpdeskLinkActive() {
        return this.helpdeskLinkActive;
    }

    public String getClientInfo() {
        return this.connClientInfo;
    }

    public void setClientInfo(String connClientInfo) {
        this.connClientInfo = connClientInfo;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public AuthenticationType getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public long getUserSystemRights() {
        return this.userSystemRights;
    }

    public String getMessageOfTheDay() {
        return this.messageOfTheDay;
    }

    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }

    public int getGraceLogins() {
        return this.graceLogins;
    }

    public int getAlarmListDisplayLimit() {
        return this.getClientConfigurationHintAsInt("AlarmList.DisplayLimit", 4096);
    }

    public String getClientConfigurationHint(String name, String defaultValue) {
        String v = this.clientConfigurationHints.get(name);
        return v != null ? v : defaultValue;
    }

    public String getClientConfigurationHint(String name) {
        return this.getClientConfigurationHint(name, null);
    }

    public int getClientConfigurationHintAsInt(String name, int defaultValue) {
        String v = this.clientConfigurationHints.get(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public boolean getClientConfigurationHintAsBoolean(String name, boolean defaultValue) {
        String v = this.clientConfigurationHints.get(name);
        if (v == null) {
            return defaultValue;
        }
        if (v.equalsIgnoreCase("true")) {
            return true;
        }
        if (v.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Integer.parseInt(v) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public synchronized void syncObjects() throws IOException, NXCException {
        this.syncObjects.acquireUninterruptibly();
        NXCPMessage msg = this.newMessage(5);
        msg.setFieldInt16(254L, 1);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForSync(this.syncObjects, this.commandTimeout * 10);
        this.objectsSynchronized = true;
        this.sendNotification(new SessionNotification(2001));
        this.subscribe(CHANNEL_OBJECTS);
    }

    public void syncObjectSet(long[] objects, boolean syncComments) throws IOException, NXCException {
        this.syncObjectSet(objects, syncComments, 0);
    }

    public void syncObjectSet(long[] objects, boolean syncComments, int options) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(249);
        msg.setFieldInt16(254L, syncComments ? 1 : 0);
        msg.setFieldInt16(13L, options);
        msg.setFieldInt32(138L, objects.length);
        msg.setField(139L, objects);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        if ((options & 2) != 0) {
            this.waitForRCC(msg.getMessageId());
        }
    }

    public void syncMissingObjects(long[] objects, boolean syncComments) throws IOException, NXCException {
        this.syncMissingObjects(objects, syncComments, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMissingObjects(long[] objects, boolean syncComments, int options) throws IOException, NXCException {
        long[] syncList = Arrays.copyOf(objects, objects.length);
        int count = syncList.length;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            int i = 0;
            while (i < syncList.length) {
                if (this.objectList.containsKey(syncList[i])) {
                    syncList[i] = 0L;
                    --count;
                }
                ++i;
            }
        }
        if (count > 0) {
            this.syncObjectSet(syncList, syncComments, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectById(long id) {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return this.objectList.get(id);
        }
    }

    public <T> T findObjectById(long id, Class<T> requiredClass) {
        AbstractObject object = this.findObjectById(id);
        return (T)(requiredClass.isInstance(object) ? object : null);
    }

    public List<AbstractObject> findMultipleObjects(long[] idList, boolean returnUnknown) {
        return this.findMultipleObjects(idList, (Class<? extends AbstractObject>)null, returnUnknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> findMultipleObjects(long[] idList, Class<? extends AbstractObject> classFilter, boolean returnUnknown) {
        ArrayList<AbstractObject> result = new ArrayList<AbstractObject>(idList.length);
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            int i = 0;
            while (i < idList.length) {
                AbstractObject object = this.objectList.get(idList[i]);
                if (object != null && (classFilter == null || classFilter.isInstance(object))) {
                    result.add(object);
                } else if (returnUnknown) {
                    result.add(new UnknownObject(idList[i], this));
                }
                ++i;
            }
        }
        return result;
    }

    public List<AbstractObject> findMultipleObjects(Long[] idList, boolean returnUnknown) {
        return this.findMultipleObjects(idList, (Class<? extends AbstractObject>)null, returnUnknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> findMultipleObjects(Long[] idList, Class<? extends AbstractObject> classFilter, boolean returnUnknown) {
        ArrayList<AbstractObject> result = new ArrayList<AbstractObject>(idList.length);
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            int i = 0;
            while (i < idList.length) {
                AbstractObject object = this.objectList.get(idList[i]);
                if (object != null && (classFilter == null || classFilter.isInstance(object))) {
                    result.add(object);
                } else if (returnUnknown) {
                    result.add(new UnknownObject(idList[i], this));
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectByGUID(UUID guid) {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return this.objectListGUID.get(guid);
        }
    }

    public <T extends AbstractObject> T findObjectByGUID(UUID guid, Class<T> requiredClass) {
        AbstractObject object = this.findObjectByGUID(guid);
        return (T)(requiredClass.isInstance(object) ? object : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Zone findZone(long zoneUIN) {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return this.zoneList.get(zoneUIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Zone> getAllZones() {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return new ArrayList<Zone>(this.zoneList.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectByName(String name) {
        AbstractObject result = null;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (!object.getObjectName().equalsIgnoreCase(name)) continue;
                result = object;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObjectByNamePattern(String pattern) {
        AbstractObject result = null;
        Matcher matcher = Pattern.compile(pattern).matcher("");
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                matcher.reset(object.getObjectName());
                if (!matcher.matches()) continue;
                result = object;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject findObject(ObjectFilter filter) {
        AbstractObject result = null;
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (!filter.filter(object)) continue;
                result = object;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> filterObjects(ObjectFilter filter) {
        ArrayList<AbstractObject> result = new ArrayList<AbstractObject>();
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (!filter.filter(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getTopLevelObjects(Set<Integer> classFilter) {
        HashSet<AbstractObject> list = new HashSet<AbstractObject>();
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            for (AbstractObject object : this.objectList.values()) {
                if (classFilter != null && !classFilter.contains(object.getObjectClass())) continue;
                if (!object.hasParents()) {
                    list.add(object);
                    continue;
                }
                boolean hasParents = false;
                Iterator<Long> it = object.getParents();
                while (it.hasNext()) {
                    Long parent = it.next();
                    if (classFilter != null) {
                        AbstractObject p = this.objectList.get(parent);
                        if (p == null || !classFilter.contains(p.getObjectClass())) continue;
                        hasParents = true;
                        break;
                    }
                    if (!this.objectList.containsKey(parent)) continue;
                    hasParents = true;
                    break;
                }
                if (hasParents) continue;
                list.add(object);
            }
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    public AbstractObject[] getTopLevelObjects() {
        return this.getTopLevelObjects(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> getAllObjects() {
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            return new ArrayList<AbstractObject>(this.objectList.values());
        }
    }

    public String getObjectName(long objectId) {
        AbstractObject object = this.findObjectById(objectId);
        return object != null ? object.getObjectName() : "[" + Long.toString(objectId) + "]";
    }

    public List<AbstractObject> queryObjects(String query) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(362);
        msg.setField(617L, query);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return this.findMultipleObjects(response.getFieldAsUInt32Array(139L), false);
    }

    public List<ObjectQueryResult> queryObjectDetails(String query, List<String> properties) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(363);
        msg.setField(617L, query);
        msg.setFieldsFromStringCollection(properties, 0x70000000L, 337L);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        long[] objects = response.getFieldAsUInt32Array(139L);
        ArrayList<ObjectQueryResult> results = new ArrayList<ObjectQueryResult>(objects.length);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < objects.length) {
            List values = response.getStringListFromFields(fieldId + 1L, fieldId);
            AbstractObject object = this.findObjectById(objects[i]);
            if (object != null && properties.size() == values.size()) {
                results.add(new ObjectQueryResult(object, properties, values));
            }
            fieldId += (long)(values.size() + 1);
            ++i;
        }
        return results;
    }

    public HashMap<Long, Alarm> getAlarms() throws IOException, NXCException {
        long alarmId;
        NXCPMessage msg = this.newMessage(70);
        long rqId = msg.getMessageId();
        this.sendMessage(msg);
        HashMap<Long, Alarm> alarmList = new HashMap<Long, Alarm>(0);
        while ((alarmId = (long)(msg = this.waitForMessage(74, rqId)).getFieldAsInt32(93L)) != 0L) {
            alarmList.put(alarmId, new Alarm(msg));
        }
        return alarmList;
    }

    public Alarm getAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(259);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Alarm(response);
    }

    public List<EventInfo> getAlarmEvents(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(267);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<EventInfo> list = new ArrayList<EventInfo>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            EventInfo parent = null;
            long rootId = response.getFieldAsInt64(varId + 1L);
            if (rootId != 0L) {
                for (EventInfo e : list) {
                    if (e.getId() != rootId) continue;
                    parent = e;
                    break;
                }
            }
            list.add(new EventInfo(response, varId, parent));
            varId += 10L;
            ++i;
        }
        return list;
    }

    public void acknowledgeAlarm(long alarmId, boolean sticky, int time) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(72);
        msg.setFieldInt32(93L, (int)alarmId);
        msg.setFieldInt16(320L, sticky ? 1 : 0);
        msg.setFieldInt32(94L, time);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void acknowledgeAlarm(long alarmId) throws IOException, NXCException {
        this.acknowledgeAlarm(alarmId, false, 0);
    }

    public void acknowledgeAlarm(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(72);
        msg.setField(247L, helpdeskReference);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void resolveAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(263);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void resolveAlarm(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(263);
        msg.setField(247L, helpdeskReference);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void terminateAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(181);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void terminateAlarm(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(181);
        msg.setField(247L, helpdeskReference);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    private Map<Long, Integer> bulkAlarmOperation(int cmd, List<Long> alarmIds) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(cmd);
        msg.setField(559L, alarmIds.toArray(new Long[alarmIds.size()]));
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        HashMap<Long, Integer> operationFails = new HashMap<Long, Integer>();
        if (response.findField(559L) != null) {
            int i = 0;
            while (i < response.getFieldAsUInt32ArrayEx(559L).length) {
                operationFails.put(response.getFieldAsUInt32ArrayEx(559L)[i], response.getFieldAsUInt32ArrayEx(553L)[i].intValue());
                ++i;
            }
        }
        return operationFails;
    }

    public Map<Long, Integer> bulkResolveAlarms(List<Long> alarmIds) throws IOException, NXCException {
        return this.bulkAlarmOperation(344, alarmIds);
    }

    public Map<Long, Integer> bulkTerminateAlarms(List<Long> alarmIds) throws IOException, NXCException {
        return this.bulkAlarmOperation(343, alarmIds);
    }

    public void deleteAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(75);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public String openHelpdeskIssue(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(4);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        return this.waitForRCC(msg.getMessageId()).getFieldAsString(247L);
    }

    public String getHelpdeskIssueUrl(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(292);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        return this.waitForRCC(msg.getMessageId()).getFieldAsString(471L);
    }

    public void unlinkHelpdeskIssue(String helpdeskReference) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(293);
        msg.setField(247L, helpdeskReference);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unlinkHelpdeskIssue(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(293);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<AlarmComment> getAlarmComments(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(71);
        msg.setFieldInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<AlarmComment> comments = new ArrayList<AlarmComment>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            comments.add(new AlarmComment(response, varId));
            varId += 10L;
            ++i;
        }
        return comments;
    }

    public void deleteAlarmComment(long alarmId, long commentId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(289);
        msg.setFieldInt32(93L, (int)alarmId);
        msg.setFieldInt32(410L, (int)commentId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void createAlarmComment(long alarmId, String text) throws IOException, NXCException {
        this.updateAlarmComment(alarmId, 0L, text);
    }

    public void createAlarmComment(String helpdeskReference, String text) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(258);
        msg.setFieldInt32(93L, 0);
        msg.setField(247L, helpdeskReference);
        msg.setField(82L, text);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void updateAlarmComment(long alarmId, long commentId, String text) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(258);
        msg.setFieldInt32(93L, (int)alarmId);
        msg.setFieldInt32(410L, (int)commentId);
        msg.setField(82L, text);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setAlarmFlowState(int state) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(288);
        msg.setFieldInt32(461L, state);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Map<String, ServerVariable> getServerVariables() throws IOException, NXCException {
        NXCPMessage request = this.newMessage(13);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        int count = response.getFieldAsInt32(144L);
        HashMap<String, ServerVariable> varList = new HashMap<String, ServerVariable>(count);
        long id = 0x10000000L;
        int i = 0;
        while (i < count) {
            ServerVariable v = new ServerVariable(response, id);
            varList.put(v.getName(), v);
            ++i;
            id += 10L;
        }
        count = response.getFieldAsInt32(566L);
        i = 0;
        while (i < count) {
            ServerVariable var;
            if ((var = varList.get(response.getFieldAsString(id++))) != null) {
                var.addPossibleValue(response, id);
            }
            id += 2L;
            ++i;
        }
        return varList;
    }

    public String getPublicServerVariable(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(313);
        msg.setField(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsString(21L);
    }

    public int getPublicServerVariableAsInt(String name) throws IOException, NXCException {
        return Integer.parseInt(this.getPublicServerVariable(name));
    }

    public boolean getPublicServerVariableAsBoolean(String name) throws IOException, NXCException {
        String value = this.getPublicServerVariable(name);
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        try {
            int n = Integer.parseInt(value);
            return n != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setServerVariable(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(14);
        msg.setField(20L, name);
        msg.setField(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteServerVariable(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(17);
        msg.setField(20L, name);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setDefaultServerValues(List<ServerVariable> varList) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(139);
        long base = 0x10000000L;
        for (ServerVariable v : varList) {
            msg.setField(base++, v.getName());
        }
        msg.setFieldInt32(144L, varList.size());
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public String getServerConfigClob(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(226);
        msg.setField(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsString(21L);
    }

    public void setServerConfigClob(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(225);
        msg.setField(20L, name);
        msg.setField(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void subscribe(String channel) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(138);
        msg.setField(20L, channel);
        msg.setFieldInt16(172L, 1);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unsubscribe(String channel) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(138);
        msg.setField(20L, channel);
        msg.setFieldInt16(172L, 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void syncUserDatabase() throws IOException, NXCException {
        this.syncUserDB.acquireUninterruptibly();
        NXCPMessage msg = this.newMessage(30);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForSync(this.syncUserDB, this.commandTimeout * 10);
        this.subscribe(CHANNEL_USERDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUserObject findUserDBObjectById(long id) {
        AbstractUserObject object;
        Map<Long, AbstractUserObject> map = this.userDB;
        synchronized (map) {
            object = this.userDB.get(id);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractUserObject[] getUserDatabaseObjects() {
        AbstractUserObject[] list;
        Map<Long, AbstractUserObject> map = this.userDB;
        synchronized (map) {
            Collection<AbstractUserObject> values = this.userDB.values();
            list = values.toArray(new AbstractUserObject[values.size()]);
        }
        return list;
    }

    private long createUserDBObject(String name, boolean isGroup) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(36);
        msg.setField(34L, name);
        msg.setField(39L, isGroup);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(35L);
    }

    public long createUser(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, false);
    }

    public long createUserGroup(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, true);
    }

    public void deleteUserDBObject(long id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(35);
        msg.setFieldInt32(35L, (int)id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setUserPassword(long id, String newPassword, String oldPassword) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(40);
        msg.setFieldInt32(35L, (int)id);
        msg.setField(2L, newPassword);
        if (oldPassword != null) {
            msg.setField(349L, oldPassword);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public boolean validateUserPassword(String password) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(316);
        msg.setField(2L, password);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsBoolean(508L);
    }

    public void modifyUserDBObject(AbstractUserObject object, int fields) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(34);
        msg.setFieldInt32(337L, fields);
        object.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void detachUserFromLdap(AbstractUserObject object) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(315);
        msg.setFieldInt32(35L, (int)object.getId());
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyUserDBObject(AbstractUserObject object) throws IOException, NXCException {
        this.modifyUserDBObject(object, Integer.MAX_VALUE);
    }

    public void lockUserDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(37);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unlockUserDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(38);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setAttributeForCurrentUser(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(69);
        msg.setField(20L, name);
        msg.setField(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public String getAttributeForCurrentUser(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(68);
        msg.setField(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsString(21L);
    }

    public DciValue[] getLastValues(long nodeId, boolean objectTooltipOnly, boolean overviewOnly, boolean includeNoValueObjects) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(121);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(443L, objectTooltipOnly);
        msg.setField(502L, overviewOnly);
        msg.setField(481L, includeNoValueObjects);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(111L);
        DciValue[] list = new DciValue[count];
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            list[i] = DciValue.createFromMessage(nodeId, response, base);
            ++i;
            base += 50L;
        }
        return list;
    }

    public DciValue[] getLastValues(long nodeId) throws IOException, NXCException {
        return this.getLastValues(nodeId, false, false, false);
    }

    public DciValue[] getLastValues(Set<MapDCIInstance> mapDcis) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(291);
        long base = 0x10000000L;
        msg.setFieldInt32(111L, mapDcis.size());
        for (MapDCIInstance item : mapDcis) {
            item.fillMessage(msg, base);
            base += 10L;
        }
        return this.sendLastValuesMsg(msg);
    }

    public DciValue[] getLastValues(List<SingleDciConfig> dciConfig) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(291);
        long base = 0x10000000L;
        msg.setFieldInt32(111L, dciConfig.size());
        for (SingleDciConfig c : dciConfig) {
            c.fillMessage(msg, base);
            base += 10L;
        }
        return this.sendLastValuesMsg(msg);
    }

    public DciValue[] sendLastValuesMsg(NXCPMessage msg) throws IOException, NXCException {
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(111L);
        DciValue[] list = new DciValue[count];
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            list[i] = new SimpleDciValue(response, base);
            ++i;
            base += 10L;
        }
        return list;
    }

    public List<Threshold> getActiveThresholds(List<SingleDciConfig> dciConfig) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(369);
        long base = 0x10000000L;
        msg.setFieldInt32(111L, dciConfig.size());
        for (SingleDciConfig c : dciConfig) {
            c.fillMessage(msg, base);
            base += 10L;
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(54L);
        ArrayList<Threshold> list = new ArrayList<Threshold>(count);
        base = 0x20000000L;
        int i = 0;
        while (i < count) {
            list.add(new Threshold(response, base));
            ++i;
            base += 20L;
        }
        return list;
    }

    public Table getTableLastValues(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(260);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Table(response);
    }

    public PerfTabDci[] getPerfTabItems(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(200);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(111L);
        PerfTabDci[] list = new PerfTabDci[count];
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            list[i] = new PerfTabDci(response, base);
            ++i;
            base += 10L;
        }
        return list;
    }

    public List<ThresholdViolationSummary> getThresholdSummary(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(262);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ArrayList<ThresholdViolationSummary> list = new ArrayList<ThresholdViolationSummary>();
        long varId = 0x800000L;
        while (response.getFieldAsInt64(varId) != 0L) {
            ThresholdViolationSummary t = new ThresholdViolationSummary(response, varId);
            list.add(t);
            varId += (long)(50 * t.getDciList().size() + 2);
        }
        return list;
    }

    public int parseDataRows(byte[] input, DciData data) {
        NXCPDataInputStream inputStream = new NXCPDataInputStream(input);
        int rows = 0;
        try {
            inputStream.skipBytes(4);
            rows = inputStream.readInt();
            int dataType = inputStream.readInt();
            data.setDataType(dataType);
            inputStream.skipBytes(4);
            int i = 0;
            while (i < rows) {
                long timestamp = inputStream.readUnsignedInt() * 1000L;
                switch (dataType) {
                    case 0: {
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Long(inputStream.readInt())));
                        break;
                    }
                    case 1: {
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Long(inputStream.readUnsignedInt())));
                        break;
                    }
                    case 2: 
                    case 3: {
                        inputStream.skipBytes(4);
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Long(inputStream.readLong())));
                        break;
                    }
                    case 5: {
                        inputStream.skipBytes(4);
                        data.addDataRow(new DciDataRow(new Date(timestamp), new Double(inputStream.readDouble())));
                        break;
                    }
                    case 4: {
                        StringBuilder sb = new StringBuilder(256);
                        int count = 256;
                        while (count > 0) {
                            char ch = inputStream.readChar();
                            if (ch == '\u0000') {
                                --count;
                                break;
                            }
                            sb.append(ch);
                            --count;
                        }
                        inputStream.skipBytes(count * 2);
                        data.addDataRow(new DciDataRow(new Date(timestamp), sb.toString()));
                    }
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        inputStream.close();
        return rows;
    }

    private DciData getCollectedDataInternal(long nodeId, long dciId, String instance, String dataColumn, Date from, Date to, int maxRows) throws IOException, NXCException {
        int rowsReceived;
        NXCPMessage msg;
        if (instance != null) {
            msg = this.newMessage(261);
            msg.setField(116L, instance);
            msg.setField(413L, dataColumn);
        } else {
            msg = this.newMessage(49);
        }
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt32(43L, (int)dciId);
        DciData data = new DciData(nodeId, dciId);
        int rowsRemaining = maxRows;
        int timeFrom = from != null ? (int)(from.getTime() / 1000L) : 0;
        int timeTo = to != null ? (int)(to.getTime() / 1000L) : 0;
        do {
            DciDataRow row;
            msg.setMessageId(this.requestId.getAndIncrement());
            msg.setFieldInt32(50L, maxRows);
            msg.setFieldInt32(51L, timeFrom);
            msg.setFieldInt32(52L, timeTo);
            this.sendMessage(msg);
            this.waitForRCC(msg.getMessageId());
            NXCPMessage response = this.waitForMessage(50, msg.getMessageId());
            if (!response.isBinaryMessage()) {
                throw new NXCException(46);
            }
            rowsReceived = this.parseDataRows(response.getBinaryData(), data);
            if (rowsRemaining != 0 && rowsRemaining <= 200000 || rowsReceived != 200000) continue;
            if (rowsRemaining > 0) {
                rowsRemaining -= rowsReceived;
            }
            if (to == null || (row = data.getLastValue()) == null) continue;
            timeTo = (int)(row.getTimestamp().getTime() / 1000L) - 1;
        } while (rowsReceived == 200000);
        return data;
    }

    public DciData getCollectedData(long nodeId, long dciId, Date from, Date to, int maxRows) throws IOException, NXCException {
        return this.getCollectedDataInternal(nodeId, dciId, null, null, from, to, maxRows);
    }

    public DciData getCollectedTableData(long nodeId, long dciId, String instance, String dataColumn, Date from, Date to, int maxRows) throws IOException, NXCException {
        if (instance == null || dataColumn == null) {
            throw new NXCException(12);
        }
        return this.getCollectedDataInternal(nodeId, dciId, instance, dataColumn, from, to, maxRows);
    }

    public void clearCollectedData(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(228);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteDciEntry(long nodeId, long dciId, long timestamp) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(368);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt32(43L, (int)dciId);
        msg.setFieldInt32(94L, (int)timestamp);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void forceDCIPoll(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(309);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Threshold[] getThresholds(long nodeId, long dciId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(238);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(54L);
        Threshold[] list = new Threshold[count];
        long varId = 0x20000000L;
        int i = 0;
        while (i < count) {
            list[i] = new Threshold(response, varId);
            varId += 20L;
            ++i;
        }
        return list;
    }

    public String[] dciIdsToNames(long[] nodeIds, long[] dciIds) throws IOException, NXCException {
        if (nodeIds.length == 0) {
            return new String[0];
        }
        NXCPMessage msg = this.newMessage(174);
        msg.setFieldInt32(111L, nodeIds.length);
        msg.setField(229L, nodeIds);
        msg.setField(230L, dciIds);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        String[] result = new String[nodeIds.length];
        long varId = 0x40000000L;
        int i = 0;
        while (i < result.length) {
            result[i] = response.getFieldAsString(varId++);
            ++i;
        }
        return result;
    }

    public String[] dciIdsToNames(Collection<ConditionDciInfo> dciList) throws IOException, NXCException {
        long[] nodeIds = new long[dciList.size()];
        long[] dciIds = new long[dciList.size()];
        int i = 0;
        for (ConditionDciInfo dci : dciList) {
            nodeIds[i] = dci.getNodeId();
            dciIds[i] = dci.getDciId();
            ++i;
        }
        return this.dciIdsToNames(nodeIds, dciIds);
    }

    public long dciNameToId(long nodeId, String dciName) throws IOException, NXCException {
        DciValue[] list;
        if (nodeId == 0L || dciName == null || dciName.isEmpty()) {
            return 0L;
        }
        DciValue[] dciValueArray = list = this.getLastValues(nodeId);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            DciValue dciValue = dciValueArray[n2];
            if (dciValue.getName().equals(dciName)) {
                return dciValue.getId();
            }
            ++n2;
        }
        return 0L;
    }

    public String queryParameter(long nodeId, int origin, String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(102);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt16(46L, origin);
        msg.setField(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsString(21L);
    }

    public Table queryAgentTable(long nodeId, String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(246);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(20L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Table(response);
    }

    protected void createCustomObject(NXCObjectCreationData data, Object userData, NXCPMessage msg) {
    }

    public long createObject(NXCObjectCreationData data, Object userData) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(55);
        msg.setFieldInt32(78L, (int)data.getParentId());
        msg.setFieldInt16(5L, data.getObjectClass());
        msg.setField(4L, data.getName());
        msg.setFieldInt32(147L, (int)data.getZoneUIN());
        if (data.getComments() != null) {
            msg.setField(82L, data.getComments());
        }
        switch (data.getObjectClass()) {
            case 35: {
                msg.setFieldInt32(543L, (int)data.getControllerId());
                break;
            }
            case 3: {
                msg.setField(113L, data.getMacAddress().getValue());
                msg.setField(8L, data.getIpAddress());
                msg.setFieldInt32(12L, data.getIfType());
                msg.setFieldInt32(11L, data.getIfIndex());
                msg.setFieldInt32(367L, data.getSlot());
                msg.setFieldInt32(368L, data.getPort());
                msg.setFieldInt16(407L, data.isPhysicalPort() ? 1 : 0);
                break;
            }
            case 31: {
                msg.setField(433L, data.getDeviceId());
                break;
            }
            case 2: {
                if (data.getPrimaryName() != null) {
                    msg.setField(397L, data.getPrimaryName());
                }
                msg.setField(8L, data.getIpAddress());
                msg.setFieldInt16(15L, data.getAgentPort());
                msg.setFieldInt16(80L, data.getSnmpPort());
                msg.setFieldInt32(14L, data.getCreationFlags());
                msg.setFieldInt32(195L, (int)data.getAgentProxyId());
                msg.setFieldInt32(267L, (int)data.getSnmpProxyId());
                msg.setFieldInt32(149L, (int)data.getIcmpProxyId());
                msg.setFieldInt32(548L, (int)data.getSshProxyId());
                msg.setFieldInt32(544L, (int)data.getChassisId());
                msg.setField(546L, data.getSshLogin());
                msg.setField(547L, data.getSshPassword());
                break;
            }
            case 21: {
                msg.setFieldInt16(357L, data.getMapType());
                msg.setField(359L, data.getSeedObjectIds());
                msg.setFieldInt32(13L, data.getFlags());
                break;
            }
            case 11: {
                msg.setFieldInt16(130L, data.getServiceType());
                msg.setFieldInt16(131L, data.getIpProtocol());
                msg.setFieldInt16(132L, data.getIpPort());
                msg.setField(133L, data.getRequest());
                msg.setField(134L, data.getResponse());
                msg.setFieldInt16(408L, data.isCreateStatusDci() ? 1 : 0);
                break;
            }
            case 29: {
                msg.setFieldInt32(393L, (int)data.getLinkedNodeId());
                break;
            }
            case 32: {
                msg.setFieldInt16(441L, data.getHeight());
                break;
            }
            case 30: {
                msg.setFieldInt16(402L, data.isTemplate() ? 1 : 0);
            }
        }
        if (userData != null) {
            this.createCustomObject(data, userData, msg);
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(3L);
    }

    public long createObject(NXCObjectCreationData data) throws IOException, NXCException {
        return this.createObject(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(7);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        Map<Long, AbstractObject> map = this.objectList;
        synchronized (map) {
            AbstractObject object = this.objectList.get(objectId);
            if (object != null) {
                this.objectList.remove(objectId);
                this.objectListGUID.remove(object.getGuid());
                if (object instanceof Zone) {
                    this.zoneList.remove(((Zone)object).getUIN());
                }
                this.removeOrphanedObjects(object);
            }
        }
        this.sendNotification(new SessionNotification(99, objectId));
    }

    private void removeOrphanedObjects(AbstractObject parent) {
        Iterator<Long> it = parent.getChildren();
        while (it.hasNext()) {
            AbstractObject object = this.objectList.get(it.next());
            if (object == null || object.getParentCount() != 1) continue;
            this.objectList.remove(object.getObjectId());
            this.objectListGUID.remove(object.getGuid());
            if (object instanceof Zone) {
                this.zoneList.remove(((Zone)object).getUIN());
            }
            this.removeOrphanedObjects(object);
        }
    }

    protected void modifyCustomObject(NXCObjectModificationData data, Object userData, NXCPMessage msg) {
    }

    public void modifyObject(NXCObjectModificationData data, Object userData) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(8);
        msg.setFieldInt32(3L, (int)data.getObjectId());
        if (data.isFieldSet(1)) {
            msg.setField(4L, data.getName());
        }
        if (data.isFieldSet(17)) {
            msg.setField(8L, data.getPrimaryIpAddress());
        }
        if (data.isFieldSet(2)) {
            AccessListElement[] acl = data.getACL();
            msg.setFieldInt32(32L, acl.length);
            msg.setFieldInt16(33L, data.isInheritAccessRights() ? 1 : 0);
            long id1 = 4096L;
            long id2 = 8192L;
            int i = 0;
            while (i < acl.length) {
                msg.setFieldInt32(id1++, (int)acl[i].getUserId());
                msg.setFieldInt32(id2++, acl[i].getAccessRights());
                ++i;
            }
        }
        if (data.isFieldSet(3)) {
            Map<String, String> attrList = data.getCustomAttributes();
            Iterator<String> it = attrList.keySet().iterator();
            long id = 0x70000000L;
            int count = 0;
            while (it.hasNext()) {
                String key = it.next();
                String value = attrList.get(key);
                msg.setField(id++, key);
                msg.setField(id++, value);
                ++count;
            }
            msg.setFieldInt32(309L, count);
        }
        if (data.isFieldSet(4)) {
            msg.setField(321L, data.getAutoBindFilter());
        }
        if (data.isFieldSet(53)) {
            msg.setField(232L, data.getFilter());
        }
        if (data.isFieldSet(8)) {
            msg.setField(27L, data.getDescription());
        }
        if (data.isFieldSet(7)) {
            msg.setFieldInt32(178L, data.getVersion());
        }
        if (data.isFieldSet(6)) {
            msg.setField(81L, data.getConfigFileContent());
        }
        if (data.isFieldSet(9)) {
            msg.setFieldInt16(15L, data.getAgentPort());
        }
        if (data.isFieldSet(13)) {
            msg.setFieldInt32(195L, (int)data.getAgentProxy());
        }
        if (data.isFieldSet(10)) {
            msg.setFieldInt16(16L, data.getAgentAuthMethod());
            msg.setField(17L, data.getAgentSecret());
        }
        if (data.isFieldSet(15)) {
            long[] nodes = data.getTrustedNodes();
            msg.setFieldInt32(306L, nodes.length);
            msg.setField(307L, nodes);
        }
        if (data.isFieldSet(11)) {
            msg.setFieldInt16(6L, data.getSnmpVersion());
        }
        if (data.isFieldSet(12)) {
            msg.setField(18L, data.getSnmpAuthName());
            msg.setField(89L, data.getSnmpAuthPassword());
            msg.setField(91L, data.getSnmpPrivPassword());
            int methods = data.getSnmpAuthMethod() | data.getSnmpPrivMethod() << 8;
            msg.setFieldInt16(84L, methods);
        }
        if (data.isFieldSet(14)) {
            msg.setFieldInt32(267L, (int)data.getSnmpProxy());
        }
        if (data.isFieldSet(18)) {
            msg.setFieldInt16(80L, data.getSnmpPort());
        }
        if (data.isFieldSet(23)) {
            msg.setFieldInt32(149L, (int)data.getIcmpProxy());
        }
        if (data.isFieldSet(16)) {
            GeoLocation gl = data.getGeolocation();
            msg.setFieldInt16(342L, gl.getType());
            msg.setField(343L, Double.valueOf(gl.getLatitude()));
            msg.setField(344L, Double.valueOf(gl.getLongitude()));
            msg.setFieldInt16(438L, gl.getAccuracy());
            if (gl.getTimestamp() != null) {
                msg.setFieldInt64(439L, gl.getTimestamp().getTime() / 1000L);
            }
        }
        if (data.isFieldSet(19)) {
            msg.setFieldInt16(358L, data.getMapLayout().getValue());
        }
        if (data.isFieldSet(20)) {
            msg.setField(360L, data.getMapBackground());
            msg.setField(385L, Double.valueOf(data.getMapBackgroundLocation().getLatitude()));
            msg.setField(386L, Double.valueOf(data.getMapBackgroundLocation().getLongitude()));
            msg.setFieldInt16(387L, data.getMapBackgroundZoom());
            msg.setFieldInt32(424L, data.getMapBackgroundColor());
        }
        if (data.isFieldSet(22)) {
            msg.setField(379L, data.getImage());
        }
        if (data.isFieldSet(21)) {
            msg.setFieldInt32(361L, data.getMapElements().size());
            long varId = 0x10000000L;
            for (NetworkMapElement e : data.getMapElements()) {
                e.fillMessage(msg, varId);
                varId += 100L;
            }
            msg.setFieldInt32(214L, data.getMapLinks().size());
            varId = 0x40000000L;
            for (NetworkMapLink l : data.getMapLinks()) {
                l.fillMessage(msg, varId);
                varId += 20L;
            }
        }
        if (data.isFieldSet(24)) {
            msg.setFieldInt16(166L, data.getColumnCount());
        }
        if (data.isFieldSet(25)) {
            msg.setFieldInt32(361L, data.getDashboardElements().size());
            long varId = 0x10000000L;
            for (DashboardElement e : data.getDashboardElements()) {
                e.fillMessage(msg, varId);
                varId += 10L;
            }
        }
        if (data.isFieldSet(69)) {
            msg.setFieldInt32(575L, data.getUrls().size());
            long fieldId = 0x74000000L;
            for (ObjectUrl u : data.getUrls()) {
                u.fillMessage(msg, fieldId);
                fieldId += 10L;
            }
        }
        if (data.isFieldSet(26)) {
            msg.setField(228L, data.getScript());
        }
        if (data.isFieldSet(27)) {
            msg.setFieldInt32(223L, data.getActivationEvent());
        }
        if (data.isFieldSet(28)) {
            msg.setFieldInt32(224L, data.getDeactivationEvent());
        }
        if (data.isFieldSet(29)) {
            msg.setFieldInt32(225L, (int)data.getSourceObject());
        }
        if (data.isFieldSet(30)) {
            msg.setFieldInt16(226L, data.getActiveStatus());
        }
        if (data.isFieldSet(31)) {
            msg.setFieldInt16(227L, data.getInactiveStatus());
        }
        if (data.isFieldSet(32)) {
            List<ConditionDciInfo> dciList = data.getDciList();
            msg.setFieldInt32(111L, dciList.size());
            long varId = 0x40000000L;
            for (ConditionDciInfo dci : dciList) {
                msg.setFieldInt32(varId++, (int)dci.getDciId());
                msg.setFieldInt32(varId++, (int)dci.getNodeId());
                msg.setFieldInt16(varId++, dci.getFunction());
                msg.setFieldInt16(varId++, dci.getPolls());
                varId += 6L;
            }
        }
        if (data.isFieldSet(33)) {
            msg.setFieldInt32(389L, (int)data.getDrillDownObjectId());
        }
        if (data.isFieldSet(37)) {
            msg.setFieldInt16(130L, data.getServiceType());
        }
        if (data.isFieldSet(34)) {
            msg.setField(8L, data.getIpAddress());
        }
        if (data.isFieldSet(35)) {
            msg.setFieldInt16(131L, data.getIpProtocol());
        }
        if (data.isFieldSet(36)) {
            msg.setFieldInt16(132L, data.getIpPort());
        }
        if (data.isFieldSet(38)) {
            msg.setFieldInt32(135L, (int)data.getPollerNode());
        }
        if (data.isFieldSet(39)) {
            msg.setFieldInt16(299L, data.getRequiredPolls());
        }
        if (data.isFieldSet(40)) {
            msg.setField(133L, data.getRequest());
        }
        if (data.isFieldSet(41)) {
            msg.setField(134L, data.getResponse());
        }
        if (data.isFieldSet(42)) {
            msg.setFieldInt32(13L, data.getObjectFlags());
            msg.setFieldInt32(538L, data.getObjectFlagsMask());
        }
        if (data.isFieldSet(43)) {
            msg.setFieldInt16(318L, data.getIfXTablePolicy());
        }
        if (data.isFieldSet(44)) {
            msg.setField(390L, data.getReportDefinition());
        }
        if (data.isFieldSet(45)) {
            msg.setFieldInt32(265L, data.getResourceList().size());
            long varId = 0x20000000L;
            for (ClusterResource r : data.getResourceList()) {
                msg.setFieldInt32(varId++, (int)r.getId());
                msg.setField(varId++, r.getName());
                msg.setField(varId++, r.getVirtualAddress());
                varId += 7L;
            }
        }
        if (data.isFieldSet(48)) {
            int count = data.getNetworkList().size();
            msg.setFieldInt32(263L, count);
            long varId = 0x28000000L;
            for (InetAddressEx n : data.getNetworkList()) {
                msg.setField(varId++, n);
            }
        }
        if (data.isFieldSet(46)) {
            msg.setField(397L, data.getPrimaryName());
        }
        if (data.isFieldSet(47)) {
            msg.setFieldInt16(160L, data.getStatusCalculationMethod());
            msg.setFieldInt16(183L, data.getStatusPropagationMethod());
            msg.setFieldInt16(184L, data.getFixedPropagatedStatus().getValue());
            msg.setFieldInt16(185L, data.getStatusShift());
            ObjectStatus[] transformation = data.getStatusTransformation();
            msg.setFieldInt16(186L, transformation[0].getValue());
            msg.setFieldInt16(187L, transformation[1].getValue());
            msg.setFieldInt16(188L, transformation[2].getValue());
            msg.setFieldInt16(189L, transformation[3].getValue());
            msg.setFieldInt16(190L, data.getStatusSingleThreshold());
            int[] thresholds = data.getStatusThresholds();
            msg.setFieldInt16(191L, thresholds[0]);
            msg.setFieldInt16(192L, thresholds[1]);
            msg.setFieldInt16(193L, thresholds[2]);
            msg.setFieldInt16(194L, thresholds[3]);
        }
        if (data.isFieldSet(49)) {
            msg.setFieldInt16(416L, data.getExpectedState());
        }
        if (data.isFieldSet(5)) {
            msg.setFieldInt32(417L, data.getLinkColor());
        }
        if (data.isFieldSet(50)) {
            msg.setFieldInt16(423L, data.getConnectionRouting());
        }
        if (data.isFieldSet(51)) {
            msg.setFieldInt32(426L, data.getDiscoveryRadius());
        }
        if (data.isFieldSet(52)) {
            msg.setFieldInt16(441L, data.getHeight());
        }
        if (data.isFieldSet(61)) {
            msg.setField(539L, data.isRackNumberingTopBottom());
        }
        if (data.isFieldSet(54)) {
            msg.setFieldInt32(22L, (int)data.getPeerGatewayId());
        }
        if (data.isFieldSet(55)) {
            long fieldId = 0x10000000L;
            msg.setFieldInt32(161L, data.getLocalNetworks().size());
            for (InetAddressEx a : data.getLocalNetworks()) {
                msg.setField(fieldId++, a);
            }
            msg.setFieldInt32(162L, data.getRemoteNetworks().size());
            for (InetAddressEx a : data.getRemoteNetworks()) {
                msg.setField(fieldId++, a);
            }
        }
        if (data.isFieldSet(56)) {
            data.getPostalAddress().fillMessage(msg);
        }
        if (data.isFieldSet(57)) {
            msg.setFieldInt16(503L, data.getAgentCacheMode().getValue());
        }
        if (data.isFieldSet(68)) {
            msg.setFieldInt16(571L, data.getAgentCompressionMode().getValue());
        }
        if (data.isFieldSet(58)) {
            msg.setFieldInt16(506L, data.getMapObjectDisplayMode().getValue());
        }
        if (data.isFieldSet(59)) {
            msg.setFieldInt32(517L, (int)data.getRackId());
            msg.setField(518L, data.getFrontRackImage());
            msg.setField(613L, data.getRearRackImage());
            msg.setFieldInt16(519L, (int)data.getRackPosition());
            msg.setFieldInt16(520L, (int)data.getRackHeight());
            msg.setFieldInt16(611L, data.getRackOrientation().getValue());
        }
        if (data.isFieldSet(60)) {
            msg.setField(528L, data.getDashboards());
        }
        if (data.isFieldSet(63)) {
            msg.setFieldInt32(544L, (int)data.getChassisId());
        }
        if (data.isFieldSet(62)) {
            msg.setFieldInt32(543L, (int)data.getControllerId());
        }
        if (data.isFieldSet(64)) {
            msg.setFieldInt32(548L, (int)data.getSshProxy());
        }
        if (data.isFieldSet(65)) {
            msg.setField(546L, data.getSshLogin());
        }
        if (data.isFieldSet(66)) {
            msg.setField(547L, data.getSshPassword());
        }
        if (data.isFieldSet(67)) {
            msg.setFieldInt32(549L, (int)data.getZoneProxy());
        }
        if (data.isFieldSet(70)) {
            msg.setField(359L, data.getSeedObjectIds());
        }
        if (data.isFieldSet(80)) {
            msg.setField(612L, data.getPassiveElements());
        }
        this.modifyCustomObject(data, userData, msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyObject(NXCObjectModificationData data) throws IOException, NXCException {
        this.modifyObject(data, null);
    }

    public void setObjectName(long objectId, String name) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setName(name);
        this.modifyObject(data);
    }

    public void setObjectCustomAttributes(long objectId, Map<String, String> attrList) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setCustomAttributes(attrList);
        this.modifyObject(data);
    }

    public void setObjectACL(long objectId, AccessListElement[] acl, boolean inheritAccessRights) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setACL(acl);
        data.setInheritAccessRights(inheritAccessRights);
        this.modifyObject(data);
    }

    public void changeObjectZone(long objectId, long zoneUIN) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(253);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setFieldInt32(147L, (int)zoneUIN);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void updateObjectComments(long objectId, String comments) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(185);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setField(82L, comments);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setObjectManaged(long objectId, boolean isManaged) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(47);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setFieldInt16(49L, isManaged ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public int getEffectiveRights(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(290);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        return this.waitForRCC(msg.getMessageId()).getFieldAsInt32(463L);
    }

    private void changeObjectBinding(long parentId, long childId, boolean bind, boolean removeDci) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(bind ? 58 : 59);
        msg.setFieldInt32(78L, (int)parentId);
        msg.setFieldInt32(79L, (int)childId);
        msg.setFieldInt16(152L, removeDci ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void bindObject(long parentId, long childId) throws IOException, NXCException {
        this.changeObjectBinding(parentId, childId, true, false);
    }

    public void unbindObject(long parentId, long childId) throws IOException, NXCException {
        this.changeObjectBinding(parentId, childId, false, false);
    }

    public void removeTemplate(long templateId, long nodeId, boolean removeDci) throws IOException, NXCException {
        this.changeObjectBinding(templateId, nodeId, false, removeDci);
    }

    public void applyTemplate(long templateId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(122);
        msg.setFieldInt32(109L, (int)templateId);
        msg.setFieldInt32(110L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void addClusterNode(long clusterId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(76);
        msg.setFieldInt32(78L, (int)clusterId);
        msg.setFieldInt32(79L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void removeClusterNode(long clusterId, long nodeId) throws IOException, NXCException {
        this.changeObjectBinding(clusterId, nodeId, false, true);
    }

    public NetworkMapPage queryLayer2Topology(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(205);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(138L);
        long[] idList = response.getFieldAsUInt32Array(139L);
        if (idList.length != count) {
            throw new NXCException(46);
        }
        NetworkMapPage page = new NetworkMapPage(String.valueOf(msg.getMessageId()) + ".L2Topology");
        int i = 0;
        while (i < count) {
            page.addElement(new NetworkMapObject(page.createElementId(), idList[i]));
            ++i;
        }
        count = response.getFieldAsInt32(214L);
        long varId = 0x10000000L;
        int i2 = 0;
        while (i2 < count) {
            NetworkMapObject obj1 = page.findObjectElement(response.getFieldAsInt64(varId++));
            NetworkMapObject obj2 = page.findObjectElement(response.getFieldAsInt64(varId++));
            int type = response.getFieldAsInt32(varId++);
            String port1 = response.getFieldAsString(varId++);
            String port2 = response.getFieldAsString(varId++);
            int flags = response.getFieldAsInt32(varId++);
            if (obj1 != null && obj2 != null) {
                page.addLink(new NetworkMapLink("", type, obj1.getId(), obj2.getId(), port1, port2, flags));
            }
            ++i2;
            varId += 4L;
        }
        return page;
    }

    public void executeAction(long nodeId, String action, String[] args) throws IOException, NXCException {
        this.executeAction(nodeId, action, args, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAction(long nodeId, String action, String[] args, boolean receiveOutput, final TextOutputListener listener, final Writer writer) throws IOException, NXCException {
        MessageHandler handler;
        NXCPMessage msg = this.newMessage(16);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(87L, action);
        msg.setField(482L, receiveOutput);
        if (args != null) {
            msg.setFieldInt16(88L, args.length);
            long fieldId = 0x10000000L;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                msg.setField(fieldId++, a);
                ++n2;
            }
        } else {
            msg.setFieldInt16(88L, 0);
        }
        MessageHandler messageHandler = handler = receiveOutput ? new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                String text = m.getFieldAsString(26L);
                if (text != null) {
                    if (listener != null) {
                        listener.messageReceived(text);
                    }
                    if (writer != null) {
                        try {
                            writer.write(text);
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (m.isEndOfSequence()) {
                    this.setComplete();
                }
                return true;
            }
        } : null;
        if (receiveOutput) {
            this.addMessageSubscription(300, msg.getMessageId(), handler);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        if (receiveOutput) {
            MessageHandler messageHandler2 = handler;
            synchronized (messageHandler2) {
                try {
                    handler.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (handler.isTimeout()) {
                throw new NXCException(4);
            }
        }
    }

    public void wakeupNode(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(92);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public PhysicalComponent getNodePhysicalComponents(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(257);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new PhysicalComponent(response, 0x20000000L, null);
    }

    public List<WinPerfObject> getNodeWinPerfObjects(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(275);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return WinPerfObject.createListFromMessage(response);
    }

    public List<SoftwarePackage> getNodeSoftwarePackages(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(274);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<SoftwarePackage> packages = new ArrayList<SoftwarePackage>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            packages.add(new SoftwarePackage(response, varId));
            varId += 10L;
            ++i;
        }
        return packages;
    }

    public ServerJob[] getServerJobList() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(54);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(330L);
        ServerJob[] jobList = new ServerJob[count];
        long baseVarId = 0x10000000L;
        int i = 0;
        while (i < count) {
            jobList[i] = new ServerJob(response, baseVarId);
            ++i;
            baseVarId += 10L;
        }
        return jobList;
    }

    public void cancelServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(137);
        msg.setFieldInt32(331L, (int)jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void holdServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(251);
        msg.setFieldInt32(331L, (int)jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unholdServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(252);
        msg.setFieldInt32(331L, (int)jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deployAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(142);
        msg.setFieldInt32(83L, (int)policyId);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void uninstallAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(60);
        msg.setFieldInt32(83L, (int)policyId);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    private EventProcessingPolicy getEventProcessingPolicyInternal(boolean readOnly) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(20);
        msg.setFieldInt16(451L, readOnly ? 1 : 0);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int numRules = response.getFieldAsInt32(74L);
        EventProcessingPolicy policy = new EventProcessingPolicy(numRules);
        int i = 0;
        while (i < numRules) {
            response = this.waitForMessage(23, msg.getMessageId());
            policy.addRule(new EventProcessingPolicyRule(response, i + 1));
            ++i;
        }
        return policy;
    }

    public EventProcessingPolicy getEventProcessingPolicy() throws IOException, NXCException {
        return this.getEventProcessingPolicyInternal(true);
    }

    public EventProcessingPolicy openEventProcessingPolicy() throws IOException, NXCException {
        return this.getEventProcessingPolicyInternal(false);
    }

    public void saveEventProcessingPolicy(EventProcessingPolicy epp) throws IOException, NXCException {
        List<EventProcessingPolicyRule> rules = epp.getRules();
        NXCPMessage msg = this.newMessage(22);
        msg.setFieldInt32(74L, rules.size());
        this.sendMessage(msg);
        long msgId = msg.getMessageId();
        this.waitForRCC(msgId);
        int id = 1;
        for (EventProcessingPolicyRule rule : rules) {
            msg = new NXCPMessage(23);
            msg.setMessageId(msgId);
            msg.setFieldInt32(67L, id++);
            rule.fillMessage(msg);
            this.sendMessage(msg);
        }
        if (rules.size() > 0) {
            this.waitForRCC(msgId);
        }
    }

    public void closeEventProcessingPolicy() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(21);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public DataCollectionConfiguration openDataCollectionConfiguration(long nodeId) throws IOException, NXCException {
        DataCollectionConfiguration cfg = new DataCollectionConfiguration(this, nodeId);
        cfg.open();
        return cfg;
    }

    public void clearAgentDataCollectionConfiguration(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(318);
        msg.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void resyncAgentDataCollectionConfiguration(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(319);
        msg.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public TransformationTestResult testTransformationScript(long nodeId, String script, String inputValue, DataCollectionObject dcObject) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(53);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(228L, script);
        msg.setField(21L, inputValue);
        if (dcObject != null) {
            dcObject.fillMessage(msg);
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        TransformationTestResult r = new TransformationTestResult();
        r.success = response.getFieldAsBoolean(326L);
        r.result = response.getFieldAsString(327L);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScriptExecution(NXCPMessage msg, final TextOutputListener listener) throws IOException, NXCException {
        MessageHandler handler = null;
        if (listener != null) {
            handler = new MessageHandler(){

                @Override
                public boolean processMessage(NXCPMessage m) {
                    String text;
                    String errorMessage;
                    if (m.getFieldAsInt32(28L) != 0 && (errorMessage = m.getFieldAsString(259L)) != null && listener != null) {
                        listener.messageReceived(String.valueOf(errorMessage) + "\n\n");
                    }
                    if ((text = m.getFieldAsString(26L)) != null && listener != null) {
                        listener.messageReceived(text);
                    }
                    if (m.isEndOfSequence()) {
                        this.setComplete();
                    }
                    return true;
                }
            };
            this.addMessageSubscription(304, msg.getMessageId(), handler);
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        if (listener != null) {
            MessageHandler messageHandler = handler;
            synchronized (messageHandler) {
                if (!handler.isComplete()) {
                    try {
                        handler.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (handler.isTimeout()) {
                throw new NXCException(4);
            }
        }
    }

    public void executeLibraryScript(long nodeId, String script, Map<String, String> inputFields, TextOutputListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(85);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(228L, script);
        msg.setField(482L, listener != null);
        if (inputFields != null) {
            msg.setFieldInt16(507L, inputFields.size());
            long fieldId = 0x70000000L;
            for (Map.Entry<String, String> e : inputFields.entrySet()) {
                msg.setField(fieldId++, e.getKey());
                msg.setField(fieldId++, e.getValue());
            }
        }
        this.processScriptExecution(msg, listener);
    }

    public void executeScript(long nodeId, String script, TextOutputListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(303);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(228L, script);
        this.processScriptExecution(msg, listener);
    }

    public ScriptCompilationResult compileScript(String source, boolean serialize) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(317);
        msg.setField(228L, source);
        msg.setField(509L, serialize);
        this.sendMessage(msg);
        return new ScriptCompilationResult(this.waitForRCC(msg.getMessageId()));
    }

    public Log openServerLog(String logName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(61);
        msg.setField(171L, logName);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        Log log = new Log(this, response, logName);
        return log;
    }

    public List<AlarmCategory> getAlarmCategories() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(339);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ArrayList<AlarmCategory> list = new ArrayList<AlarmCategory>();
        long fieldId = 0x10000000L;
        int count = response.getFieldAsInt32(361L);
        int i = 0;
        while (i < count) {
            list.add(new AlarmCategory(response, fieldId));
            fieldId += 10L;
            ++i;
        }
        return list;
    }

    public long modifyAlarmCategory(AlarmCategory object) throws IOException, NXCException {
        if (object.getName().isEmpty()) {
            return 0L;
        }
        NXCPMessage msg = this.newMessage(340);
        object.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt32(104L);
    }

    public void deleteAlarmCategory(long id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(341);
        msg.setFieldInt32(104L, (int)id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncAlarmCategories() throws IOException, NXCException {
        List<AlarmCategory> categories = this.getAlarmCategories();
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            this.alarmCategories.clear();
            for (AlarmCategory c : categories) {
                this.alarmCategories.put(c.getId(), c);
            }
            this.alarmCategoriesNeedSync = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmCategory findAlarmCategoryById(long id) {
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            return this.alarmCategories.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmCategory findAlarmCategoryByName(String name) {
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            for (Map.Entry<Long, AlarmCategory> c : this.alarmCategories.entrySet()) {
                if (!c.getValue().getName().equals(name)) continue;
                return c.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlarmCategory> findMultipleAlarmCategories(List<Long> ids) {
        ArrayList<AlarmCategory> list = new ArrayList<AlarmCategory>();
        Map<Long, AlarmCategory> map = this.alarmCategories;
        synchronized (map) {
            for (Long id : ids) {
                AlarmCategory e = this.alarmCategories.get(id);
                if (e == null) continue;
                list.add(e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncEventTemplates() throws IOException, NXCException {
        List<EventTemplate> templates = this.getEventTemplates();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            this.eventTemplates.clear();
            for (EventTemplate t : templates) {
                this.eventTemplates.put(t.getCode(), t);
            }
            this.eventTemplatesNeedSync = true;
        }
    }

    private void resyncEventTemplates() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    NXCSession.this.syncEventTemplates();
                }
                catch (Exception e) {
                    Logger.error((String)"NXCSession.resyncEventTemplates", (String)"Exception in worker thread", (Throwable)e);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate[] getCachedEventTemplates() {
        EventTemplate[] events = null;
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            events = this.eventTemplates.values().toArray(new EventTemplate[this.eventTemplates.size()]);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate findEventTemplateByName(String name) {
        EventTemplate result = null;
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            for (EventTemplate e : this.eventTemplates.values()) {
                if (!e.getName().equalsIgnoreCase(name)) continue;
                result = e;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEventName(long code) {
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            EventTemplate e = this.eventTemplates.get(code);
            return e != null ? e.getName() : "[" + Long.toString(code) + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTemplate findEventTemplateByCode(long code) {
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            return this.eventTemplates.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventTemplate> findMultipleEventTemplates(Long[] codes) {
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            Long[] longArray = codes;
            int n = codes.length;
            int n2 = 0;
            while (n2 < n) {
                long code = longArray[n2];
                EventTemplate e = this.eventTemplates.get(code);
                if (e != null) {
                    list.add(e);
                }
                ++n2;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventTemplate> findMultipleEventTemplates(long[] codes) {
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        Map<Long, EventTemplate> map = this.eventTemplates;
        synchronized (map) {
            long[] lArray = codes;
            int n = codes.length;
            int n2 = 0;
            while (n2 < n) {
                long code = lArray[n2];
                EventTemplate e = this.eventTemplates.get(code);
                if (e != null) {
                    list.add(e);
                }
                ++n2;
            }
        }
        return list;
    }

    public List<EventTemplate> getEventTemplates() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(28);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<EventTemplate> list = new ArrayList<EventTemplate>();
        while (!(response = this.waitForMessage(27, msg.getMessageId())).isEndOfSequence()) {
            list.add(new EventTemplate(response));
        }
        return list;
    }

    public long generateEventCode() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(94);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(24L);
    }

    public void deleteEventTemplate(long eventCode) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(93);
        msg.setFieldInt32(24L, (int)eventCode);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyEventTemplate(EventTemplate evt) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(26);
        msg.setFieldInt32(24L, (int)evt.getCode());
        msg.setFieldInt32(25L, evt.getSeverity().getValue());
        msg.setFieldInt32(13L, evt.getFlags());
        msg.setField(20L, evt.getName());
        msg.setField(26L, evt.getMessage());
        msg.setField(27L, evt.getDescription());
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void sendEvent(long eventCode, String eventName, long objectId, String[] parameters, String userTag) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(19);
        msg.setFieldInt32(24L, (int)eventCode);
        if (eventName != null) {
            msg.setField(169L, eventName);
        }
        msg.setFieldInt32(3L, (int)objectId);
        msg.setField(298L, userTag != null ? userTag : "");
        msg.setFieldInt16(88L, parameters.length);
        long varId = 32768L;
        int i = 0;
        while (i < parameters.length) {
            msg.setField(varId++, parameters[i]);
            ++i;
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void sendEvent(long eventCode, String[] parameters) throws IOException, NXCException {
        this.sendEvent(eventCode, null, 0L, parameters, null);
    }

    public void sendEvent(String eventName, String[] parameters) throws IOException, NXCException {
        this.sendEvent(0L, eventName, 0L, parameters, null);
    }

    public List<String> getSnmpCommunities() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(209);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(86L);
        ArrayList<String> list = new ArrayList<String>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(response.getFieldAsString(varId++));
            ++i;
        }
        return list;
    }

    public void updateSnmpCommunities(List<String> list) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(210);
        msg.setFieldInt32(86L, list.size());
        long varId = 0x10000000L;
        int i = 0;
        while (i < list.size()) {
            msg.setField(varId++, list.get(i));
            ++i;
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<SnmpUsmCredential> getSnmpUsmCredentials() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(236);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(174L);
        ArrayList<SnmpUsmCredential> list = new ArrayList<SnmpUsmCredential>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new SnmpUsmCredential(response, varId));
            ++i;
            varId += 10L;
        }
        return list;
    }

    public void updateSnmpUsmCredentials(List<SnmpUsmCredential> list) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(237);
        msg.setFieldInt32(174L, list.size());
        long varId = 0x10000000L;
        int i = 0;
        while (i < list.size()) {
            list.get(i).fillMessage(msg, varId);
            ++i;
            varId += 10L;
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public String getAgentConfig(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(116);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsString(159L);
    }

    public void updateAgentConfig(long nodeId, String config, boolean apply) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(117);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(159L, config);
        msg.setFieldInt16(163L, apply ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<AgentParameter> getSupportedParameters(long nodeId, int origin) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(118);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt16(13L, 1);
        msg.setFieldInt16(46L, origin);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(137L);
        ArrayList<AgentParameter> list = new ArrayList<AgentParameter>(count);
        long baseId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new AgentParameter(response, baseId));
            baseId += 3L;
            ++i;
        }
        return list;
    }

    public List<AgentParameter> getSupportedParameters(long nodeId) throws IOException, NXCException {
        return this.getSupportedParameters(nodeId, 1);
    }

    public List<AgentTable> getSupportedTables(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(118);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt16(13L, 2);
        msg.setFieldInt16(46L, 1);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(378L);
        ArrayList<AgentTable> list = new ArrayList<AgentTable>(count);
        long baseId = 0x40000000L;
        int i = 0;
        while (i < count) {
            list.add(new AgentTable(response, baseId));
            baseId += response.getFieldAsInt64(baseId);
            ++i;
        }
        return list;
    }

    public long[] getDataCollectionEvents(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(191);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        if (response.getFieldAsInt32(69L) == 0) {
            return new long[0];
        }
        return response.getFieldAsUInt32Array(255L);
    }

    public List<Script> getDataCollectionScripts(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(310);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(206L);
        ArrayList<Script> scripts = new ArrayList<Script>(count);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count) {
            long id = response.getFieldAsInt64(fieldId++);
            String name = response.getFieldAsString(fieldId++);
            scripts.add(new Script(id, name, null));
            ++i;
        }
        return scripts;
    }

    public String exportConfiguration(String description, long[] events, long[] traps, long[] templates, UUID[] rules, long[] scripts, long[] objectTools, long[] dciSummaryTables, long[] actions) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(192);
        msg.setField(27L, description);
        msg.setFieldInt32(69L, events.length);
        msg.setField(255L, events);
        msg.setFieldInt32(138L, templates.length);
        msg.setField(139L, templates);
        msg.setFieldInt32(256L, traps.length);
        msg.setField(257L, traps);
        msg.setFieldInt32(206L, scripts.length);
        msg.setField(497L, scripts);
        msg.setFieldInt32(164L, objectTools.length);
        msg.setField(498L, objectTools);
        msg.setFieldInt32(499L, dciSummaryTables.length);
        msg.setField(500L, dciSummaryTables);
        msg.setFieldInt32(70L, actions.length);
        msg.setField(606L, actions);
        msg.setFieldInt32(74L, rules.length);
        long varId = 0x10000000L;
        int i = 0;
        while (i < rules.length) {
            msg.setField(varId++, rules[i]);
            ++i;
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsString(258L);
    }

    public void importConfiguration(String config, int flags) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(193);
        msg.setField(258L, config);
        msg.setFieldInt32(13L, flags);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Map<String, Object> getServerStats() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(151);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("VERSION", response.getFieldAsString(121L));
        stats.put("UPTIME", response.getFieldAsInt32(200L));
        stats.put("SESSION_COUNT", response.getFieldAsInt32(205L));
        stats.put("DCI_COUNT", response.getFieldAsInt32(111L));
        stats.put("OBJECT_COUNT", response.getFieldAsInt32(138L));
        stats.put("NODE_COUNT", response.getFieldAsInt32(179L));
        stats.put("PHYSICAL_MEMORY_USED", response.getFieldAsInt32(203L));
        stats.put("VIRTUAL_MEMORY_USED", response.getFieldAsInt32(204L));
        stats.put("QSIZE_CONDITION_POLLER", response.getFieldAsInt32(285L));
        stats.put("QSIZE_CONF_POLLER", response.getFieldAsInt32(286L));
        stats.put("QSIZE_DCI_POLLER", response.getFieldAsInt32(287L));
        stats.put("QSIZE_DCI_CACHE_LOADER", response.getFieldAsInt32(492L));
        stats.put("QSIZE_DBWRITER", response.getFieldAsInt32(288L));
        stats.put("QSIZE_EVENT", response.getFieldAsInt32(289L));
        stats.put("QSIZE_DISCOVERY", response.getFieldAsInt32(290L));
        stats.put("QSIZE_NODE_POLLER", response.getFieldAsInt32(291L));
        stats.put("QSIZE_ROUTE_POLLER", response.getFieldAsInt32(292L));
        stats.put("QSIZE_STATUS_POLLER", response.getFieldAsInt32(293L));
        stats.put("ALARM_COUNT", response.getFieldAsInt32(201L));
        stats.put("ALARMS_BY_SEVERITY", response.getFieldAsUInt32Array(202L));
        return stats;
    }

    public List<ServerAction> getActions() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(78);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<ServerAction> actions = new ArrayList<ServerAction>();
        while ((response = this.waitForMessage(83, msg.getMessageId())).getFieldAsInt64(97L) != 0L) {
            actions.add(new ServerAction(response));
        }
        return actions;
    }

    public long createAction(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(81);
        msg.setField(87L, name);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(97L);
    }

    public void modifyAction(ServerAction action) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(80);
        action.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteAction(long actionId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(82);
        msg.setFieldInt32(97L, (int)actionId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<AuthCertificate> getCertificateList() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(203);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(282L);
        ArrayList<AuthCertificate> list = new ArrayList<AuthCertificate>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new AuthCertificate(response, varId));
            varId += 10L;
            ++i;
        }
        return list;
    }

    public void createNewCertificate(byte[] data, String comments) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(201);
        msg.setField(276L, data);
        msg.setField(82L, comments);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteCertificate(long id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(202);
        msg.setFieldInt32(281L, (int)id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void updateCertificate(long id, String comment) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(204);
        msg.setFieldInt32(281L, (int)id);
        msg.setField(82L, comment);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<ObjectTool> getObjectTools() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(15);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(164L);
        ArrayList<ObjectTool> list = new ArrayList<ObjectTool>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new ObjectTool(response, varId));
            varId += 10000L;
            ++i;
        }
        return list;
    }

    public ObjectToolDetails getObjectToolDetails(long toolId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(144);
        msg.setFieldInt32(165L, (int)toolId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new ObjectToolDetails(response);
    }

    public long generateObjectToolId() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(150);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(165L);
    }

    public void modifyObjectTool(ObjectToolDetails tool) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(147);
        tool.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteObjectTool(long toolId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(148);
        msg.setFieldInt32(165L, (int)toolId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void changeObjecToolDisableStatuss(long toolId, boolean enable) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(287);
        msg.setFieldInt32(165L, (int)toolId);
        msg.setFieldInt32(243L, enable ? 1 : 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Table executeTableTool(long toolId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(135);
        msg.setFieldInt32(165L, (int)toolId);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        NXCPMessage response = this.waitForMessage(136, msg.getMessageId(), 300000);
        return new Table(response);
    }

    public void executeServerCommand(long objectId, String command, Map<String, String> inputFields) throws IOException, NXCException {
        this.executeServerCommand(objectId, command, inputFields, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeServerCommand(long objectId, String command, Map<String, String> inputFields, boolean receiveOutput, final TextOutputListener listener, final Writer writer) throws IOException, NXCException {
        MessageHandler handler;
        NXCPMessage msg = this.newMessage(145);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setField(145L, command);
        msg.setField(482L, receiveOutput);
        if (inputFields != null) {
            msg.setFieldInt16(507L, inputFields.size());
            long fieldId = 0x70000000L;
            for (Map.Entry<String, String> e : inputFields.entrySet()) {
                msg.setField(fieldId++, e.getKey());
                msg.setField(fieldId++, e.getValue());
            }
        }
        MessageHandler messageHandler = handler = receiveOutput ? new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                String text = m.getFieldAsString(26L);
                if (text != null) {
                    if (listener != null) {
                        listener.messageReceived(text);
                    }
                    if (writer != null) {
                        try {
                            writer.write(text);
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (m.isEndOfSequence()) {
                    this.setComplete();
                }
                return true;
            }
        } : null;
        if (receiveOutput) {
            handler.setMessageWaitTimeout(this.serverCommandOutputTimeout);
            this.addMessageSubscription(300, msg.getMessageId(), handler);
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        if (receiveOutput) {
            if (listener != null) {
                listener.setStreamId(response.getFieldAsInt64(568L));
            }
            MessageHandler messageHandler2 = handler;
            synchronized (messageHandler2) {
                try {
                    handler.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (handler.isTimeout()) {
                throw new NXCException(4);
            }
        }
    }

    public void stopServerCommand(long commandId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(88);
        msg.setFieldInt32(568L, (int)commandId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<SnmpTrap> getSnmpTrapsConfigurationSummary() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(194);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(256L);
        ArrayList<SnmpTrap> list = new ArrayList<SnmpTrap>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new SnmpTrap(response, varId));
            varId += 10L;
            ++i;
        }
        return list;
    }

    public List<SnmpTrap> getSnmpTrapsConfiguration() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(100);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<SnmpTrap> traps = new ArrayList<SnmpTrap>();
        while ((response = this.waitForMessage(101, msg.getMessageId())).getFieldAsInt64(117L) != 0L) {
            traps.add(new SnmpTrap(response));
        }
        return traps;
    }

    public long createSnmpTrapConfiguration() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(97);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(117L);
    }

    public void deleteSnmpTrapConfiguration(long trapId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(99);
        msg.setFieldInt32(117L, (int)trapId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifySnmpTrapConfiguration(SnmpTrap trap) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(98);
        trap.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Date getMibFileTimestamp() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(51);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsDate(94L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadMibFile() throws IOException, NXCException {
        NXCReceivedFile file;
        NXCPMessage msg = this.newMessage(52);
        this.sendMessage(msg);
        int ttw = 120;
        do {
            Map<Long, NXCReceivedFile> map = this.receivedFiles;
            synchronized (map) {
                file = this.receivedFiles.get(msg.getMessageId());
                if (file != null && file.getStatus() != 0) {
                    this.receivedFiles.remove(file.getId());
                    break;
                }
                try {
                    this.receivedFiles.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (--ttw > 0);
        if (ttw == 0) {
            throw new NXCException(4);
        }
        if (file.getStatus() == 2) {
            throw file.getException();
        }
        return file.getFile();
    }

    public List<GraphSettings> getPredefinedGraphs(boolean graphTemplates) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(197);
        msg.setField(533L, graphTemplates);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(273L);
        ArrayList<GraphSettings> list = new ArrayList<GraphSettings>(count);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(GraphSettings.createGraphSettings(response, fieldId));
            fieldId += 10L;
            ++i;
        }
        return list;
    }

    public GraphFolder createGraphTree(List<GraphSettings> graphs) {
        GraphFolder root = new GraphFolder("[root]");
        HashMap<String, GraphFolder> folders = new HashMap<String, GraphFolder>();
        for (GraphSettings s : graphs) {
            GraphFolder folder = root;
            String[] path = s.getName().split("\\-\\>");
            int i = 0;
            while (i < path.length - 1) {
                String key = String.valueOf(folder.hashCode()) + "@" + path[i].replace("&", "");
                GraphFolder curr = (GraphFolder)folders.get(key);
                if (curr == null) {
                    curr = new GraphFolder(path[i]);
                    folders.put(key, curr);
                    folder.addFolder(curr);
                }
                folder = curr;
                ++i;
            }
            folder.addGraph(s);
        }
        return root;
    }

    public GraphFolder getPredefinedGraphsAsTree() throws IOException, NXCException {
        return this.createGraphTree(this.getPredefinedGraphs(false));
    }

    public long saveGraph(GraphSettings graph, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(198);
        graph.fillMessage(msg);
        msg.setFieldInt16(534L, overwrite ? 1 : 0);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(274L);
    }

    public void deletePredefinedGraph(long graphId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(199);
        msg.setFieldInt32(274L, (int)graphId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<Script> getScriptLibrary() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(152);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(206L);
        ArrayList<Script> scripts = new ArrayList<Script>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            scripts.add(new Script(response, varId));
            ++i;
            varId += 2L;
        }
        return scripts;
    }

    public Script getScript(long scriptId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(153);
        msg.setFieldInt32(207L, (int)scriptId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Script(response);
    }

    public long modifyScript(long scriptId, String name, String source) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(154);
        msg.setFieldInt32(207L, (int)scriptId);
        msg.setField(20L, name);
        msg.setField(208L, source);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(207L);
    }

    public void renameScript(long scriptId, String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(156);
        msg.setFieldInt32(207L, (int)scriptId);
        msg.setField(20L, name);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteScript(long scriptId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(155);
        msg.setFieldInt32(207L, (int)scriptId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public ConnectionPoint findConnectionPoint(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(95);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.isFieldPresent(418L) ? new ConnectionPoint(response) : null;
    }

    public ConnectionPoint findConnectionPoint(MacAddress macAddr) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(96);
        msg.setField(113L, macAddr.getValue());
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.isFieldPresent(418L) ? new ConnectionPoint(response) : null;
    }

    public ConnectionPoint findConnectionPoint(int zoneId, InetAddress ipAddr) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(264);
        msg.setFieldInt32(147L, zoneId);
        msg.setField(8L, ipAddr);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.isFieldPresent(418L) ? new ConnectionPoint(response) : null;
    }

    public List<AbstractNode> findNodesByHostname(int zoneId, String hostname) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(347);
        msg.setFieldInt32(147L, zoneId);
        msg.setField(569L, hostname);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        long base = 0x10000000L;
        ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
        int i = 0;
        while (i < count) {
            nodes.add((AbstractNode)this.findObjectById(response.getFieldAsInt32(base++)));
            ++i;
        }
        return nodes;
    }

    public boolean checkConnection() {
        if (!this.connected) {
            return false;
        }
        NXCPMessage msg = this.newMessage(3);
        try {
            this.sendMessage(msg);
            this.waitForRCC(msg.getMessageId());
            return true;
        }
        catch (Exception exception) {
            this.sendNotification(new SessionNotification(1));
            return false;
        }
    }

    public List<LibraryImage> getImageLibrary() throws IOException, NXCException {
        return this.getImageLibrary(null);
    }

    public List<LibraryImage> getImageLibrary(String category) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(243);
        if (category != null) {
            msg.setField(75L, category);
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int numOfImages = response.getFieldAsInt32(174L);
        ArrayList<LibraryImage> ret = new ArrayList<LibraryImage>(numOfImages);
        long varId = 0x10000000L;
        int i = 0;
        while (i < numOfImages) {
            UUID imageGuid = response.getFieldAsUUID(varId++);
            String imageName = response.getFieldAsString(varId++);
            String imageCategory = response.getFieldAsString(varId++);
            String imageMimeType = response.getFieldAsString(varId++);
            boolean imageProtected = response.getFieldAsBoolean(varId++);
            ret.add(new LibraryImage(imageGuid, imageName, imageCategory, imageMimeType, imageProtected));
            ++i;
        }
        return ret;
    }

    public LibraryImage getImage(UUID guid) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(239);
        msg.setField(222L, guid);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ReceivedFile imageFile = this.waitForFile(msg.getMessageId(), 600000);
        if (imageFile.isFailed()) {
            throw new NXCException(16);
        }
        return new LibraryImage(response, imageFile.getFile());
    }

    public LibraryImage createImage(LibraryImage image, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(240);
        image.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        UUID imageGuid = response.getFieldAsUUID(222L);
        image.setGuid(imageGuid);
        this.sendFile(msg.getMessageId(), image.getBinaryData(), listener, this.allowCompression);
        this.waitForRCC(msg.getMessageId());
        return image;
    }

    public void deleteImage(LibraryImage image) throws IOException, NXCException {
        if (image.isProtected()) {
            throw new NXCException(3);
        }
        NXCPMessage msg = this.newMessage(241);
        image.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyImage(LibraryImage image, ProgressListener listener) throws IOException, NXCException {
        if (image.isProtected()) {
            throw new NXCException(3);
        }
        NXCPMessage msg = this.newMessage(240);
        image.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.sendFile(msg.getMessageId(), image.getBinaryData(), listener, this.allowCompression);
        this.waitForRCC(msg.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNode(long nodeId, NodePollType pollType, final TextOutputListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(89);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt16(107L, pollType.getValue());
        MessageHandler handler = new MessageHandler(){

            @Override
            public boolean processMessage(NXCPMessage m) {
                int rcc = m.getFieldAsInt32(28L);
                if (rcc == 23) {
                    if (listener != null) {
                        listener.messageReceived(m.getFieldAsString(108L));
                    }
                } else {
                    this.setComplete();
                }
                return true;
            }
        };
        handler.setMessageWaitTimeout(600000);
        this.addMessageSubscription(90, msg.getMessageId(), handler);
        this.sendMessage(msg);
        MessageHandler messageHandler = handler;
        synchronized (messageHandler) {
            try {
                handler.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (handler.isTimeout()) {
            throw new NXCException(4);
        }
    }

    public HashMap<String, String> getPersistentStorageList() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(211);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(567L);
        HashMap<String, String> map = new HashMap<String, String>();
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            map.put(response.getFieldAsString(base++), response.getFieldAsString(base++));
            ++i;
        }
        return map;
    }

    public void setPersistentStorageValue(String key, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(213);
        msg.setField(301L, key);
        msg.setField(302L, value);
        this.sendMessage(msg);
    }

    public void deletePersistentStorageValue(String key) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(212);
        msg.setField(301L, key);
        this.sendMessage(msg);
    }

    public ServerFile[] listServerFiles() throws IOException, NXCException {
        return this.listServerFiles(null);
    }

    public ServerFile[] listServerFiles(String[] filter) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(244);
        if (filter != null) {
            msg.setFieldInt32(464L, filter.length);
            int i = 0;
            long j = 0x10000000L;
            while (i < filter.length) {
                msg.setField(j, filter[i]);
                ++i;
                ++j;
            }
        } else {
            msg.setFieldInt32(464L, 0);
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(304L);
        ServerFile[] files = new ServerFile[count];
        long varId = 0x20000000L;
        int i = 0;
        while (i < count) {
            files[i] = new ServerFile(response, varId);
            varId += 10L;
            ++i;
        }
        return files;
    }

    public List<AgentFile> listAgentFiles(AgentFile file, String fullPath, long objectId) throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(294);
        msg.setField(125L, fullPath);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setFieldInt16(480L, file == null ? 1 : 0);
        msg.setFieldInt16(558L, 1);
        this.sendMessage(msg);
        ArrayList<AgentFile> files = new ArrayList<AgentFile>(64);
        do {
            response = this.waitForRCC(msg.getMessageId());
            int count = response.getFieldAsInt32(304L);
            long fieldId = 0x20000000L;
            int i = 0;
            while (i < count) {
                files.add(new AgentFile(response, fieldId, file, objectId));
                fieldId += 10L;
                ++i;
            }
            if (response.getFieldAsBoolean(558L)) continue;
            return files;
        } while (!response.isEndOfSequence());
        this.waitForRCC(msg.getMessageId());
        return files;
    }

    public AgentFileInfo getAgentFileInfo(AgentFile file) throws IOException, NXCException {
        if (!file.isDirectory()) {
            return new AgentFileInfo(file.getName(), 0L, file.getSize());
        }
        NXCPMessage msg = this.newMessage(346);
        msg.setField(125L, file.getFullName());
        msg.setFieldInt32(3L, (int)file.getNodeId());
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new AgentFileInfo(file.getName(), response.getFieldAsInt64(556L), response.getFieldAsInt64(554L));
    }

    public long uploadFileToAgent(long nodeId, String serverFileName, String remoteFileName, boolean jobOnHold) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(146);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, serverFileName);
        if (remoteFileName != null) {
            msg.setField(377L, remoteFileName);
        }
        msg.setFieldInt16(383L, jobOnHold ? 1 : 0);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt64(331L);
    }

    public void uploadFileToServer(File localFile, String serverFileName, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(219);
        if (serverFileName == null || serverFileName.isEmpty()) {
            serverFileName = localFile.getName();
        }
        msg.setField(125L, serverFileName);
        msg.setField(406L, new Date(localFile.lastModified()));
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.sendFile(msg.getMessageId(), localFile, listener, this.allowCompression);
    }

    public void uploadLocalFileToAgent(long nodeId, File localFile, String remoteFileName, boolean overvrite, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(298);
        if (remoteFileName == null || remoteFileName.isEmpty()) {
            remoteFileName = localFile.getName();
        }
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, remoteFileName);
        msg.setField(406L, new Date(localFile.lastModified()));
        msg.setField(534L, overvrite);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        this.sendFile(msg.getMessageId(), localFile, listener, response.getFieldAsBoolean(570L));
    }

    public void createFolderOnAgent(long nodeId, String folder) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(305);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, folder);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyProgressListener(long id, int length) {
        Map<Long, ProgressListener> map = this.progressListeners;
        synchronized (map) {
            ProgressListener listener = this.progressListeners.get(id);
            if (listener != null) {
                listener.markProgress(length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProgressListener(long id) {
        Map<Long, ProgressListener> map = this.progressListeners;
        synchronized (map) {
            this.progressListeners.remove(id);
        }
    }

    public AgentFileData downloadFileFromAgent(long nodeId, String remoteFileName, long maxFileSize, boolean follow, ProgressListener listener, ServerJobIdUpdater updateServerJobId) throws IOException, NXCException {
        return this.downloadFileFromAgent(nodeId, remoteFileName, false, 0L, null, maxFileSize, follow, listener, updateServerJobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentFileData downloadFileFromAgent(long nodeId, String remoteFileName, boolean expandMacros, long alarmId, Map<String, String> inputFields, long maxFileSize, boolean follow, ProgressListener listener, ServerJobIdUpdater updateServerJobId) throws IOException, NXCException {
        ReceivedFile remoteFile;
        NXCPMessage msg = this.newMessage(254);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, remoteFileName);
        msg.setFieldInt32(458L, (int)maxFileSize);
        msg.setField(459L, follow);
        msg.setField(605L, expandMacros);
        msg.setFieldInt32(93L, (int)alarmId);
        if (expandMacros && inputFields != null) {
            msg.setFieldInt16(603L, inputFields.size());
            long fieldId = 0x20000000L;
            for (Map.Entry<String, String> e : inputFields.entrySet()) {
                msg.setField(fieldId++, e.getKey());
                msg.setField(fieldId++, e.getValue());
            }
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        String id = response.getFieldAsString(20L);
        if (updateServerJobId != null) {
            updateServerJobId.setJobIdCallback(response.getFieldAsInt32(455L));
        }
        if (listener != null) {
            long fileSize = response.getFieldAsInt64(356L);
            listener.setTotalWorkAmount(fileSize);
            Map<Long, ProgressListener> map = this.progressListeners;
            synchronized (map) {
                this.progressListeners.put(msg.getMessageId(), listener);
            }
        }
        if ((remoteFile = this.waitForFile(msg.getMessageId(), 36000000)) == null) {
            throw new NXCException(124);
        }
        AgentFileData file = new AgentFileData(id, remoteFileName, remoteFile.getFile());
        try {
            this.waitForRCC(msg.getMessageId());
        }
        finally {
            this.removeProgressListener(msg.getMessageId());
        }
        return file;
    }

    public File downloadFileFromServer(String remoteFileName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(234);
        msg.setField(125L, remoteFileName);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        return this.waitForFile(msg.getMessageId(), 3600000).getFile();
    }

    public void cancelFileMonitoring(long nodeId, String remoteFileName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(286);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, remoteFileName);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteServerFile(String serverFileName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(220);
        msg.setField(125L, serverFileName);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteAgentFile(long nodeId, String fileName) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(295);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, fileName);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void renameAgentFile(long nodeId, String oldName, String newFileName, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(296);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, oldName);
        msg.setField(477L, newFileName);
        msg.setField(534L, overwrite);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void moveAgentFile(long nodeId, String oldName, String newFileName, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(297);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, oldName);
        msg.setField(477L, newFileName);
        msg.setField(534L, overwrite);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void copyAgentFile(long nodeId, String oldName, String newFileName, boolean overwrite) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(361);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(125L, oldName);
        msg.setField(477L, newFileName);
        msg.setField(534L, overwrite);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void openConsole() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(247);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.serverConsoleConnected = true;
    }

    public void closeConsole() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(248);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.serverConsoleConnected = false;
    }

    public boolean processConsoleCommand(String command) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(128);
        msg.setField(145L, command);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId(), 3600000);
        return response.isEndOfSequence();
    }

    public boolean isServerConsoleConnected() {
        return this.serverConsoleConnected;
    }

    public void snmpWalk(long nodeId, String rootOid, SnmpWalkListener listener) throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(161);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setField(19L, rootOid);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        do {
            response = this.waitForMessage(162, msg.getMessageId());
            int count = response.getFieldAsInt32(144L);
            ArrayList<SnmpValue> data = new ArrayList<SnmpValue>(count);
            long varId = 0x10000000L;
            int i = 0;
            while (i < count) {
                String name = response.getFieldAsString(varId++);
                int type = response.getFieldAsInt32(varId++);
                String value = response.getFieldAsString(varId++);
                data.add(new SnmpValue(name, type, value, nodeId));
                ++i;
            }
            listener.onSnmpWalkData(data);
        } while (!response.isEndOfSequence());
    }

    public List<VlanInfo> getVlans(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(250);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(382L);
        ArrayList<VlanInfo> vlans = new ArrayList<VlanInfo>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            vlans.add(new VlanInfo(response, varId));
            varId += 10L;
            ++i;
        }
        return vlans;
    }

    public boolean isObjectsSynchronized() {
        return this.objectsSynchronized;
    }

    public List<InetAddressListElement> getAddressList(int listId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(188);
        msg.setFieldInt32(252L, listId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(174L);
        ArrayList<InetAddressListElement> list = new ArrayList<InetAddressListElement>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new InetAddressListElement(response, varId));
            varId += 10L;
            ++i;
        }
        return list;
    }

    public void setAddressList(int listId, List<InetAddressListElement> list) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(189);
        msg.setFieldInt32(252L, listId);
        msg.setFieldInt32(174L, list.size());
        long fieldId = 0x10000000L;
        for (InetAddressListElement e : list) {
            e.fillMessage(msg, fieldId);
            fieldId += 10L;
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void resetServerComponent(int component) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(190);
        msg.setFieldInt32(253L, component);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public NetworkPath getNetworkPath(long node1, long node2) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(129);
        msg.setFieldInt32(109L, (int)node1);
        msg.setFieldInt32(110L, (int)node2);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new NetworkPath(response);
    }

    public List<Route> getRoutingTable(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(134);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<Route> rt = new ArrayList<Route>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            rt.add(new Route(response, varId));
            varId += 10L;
            ++i;
        }
        return rt;
    }

    public List<FdbEntry> getSwitchForwardingDatabase(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(299);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<FdbEntry> fdb = new ArrayList<FdbEntry>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            fdb.add(new FdbEntry(response, varId));
            varId += 10L;
            ++i;
        }
        return fdb;
    }

    public List<WirelessStation> getWirelessStations(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(276);
        msg.setFieldInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<WirelessStation> stations = new ArrayList<WirelessStation>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            stations.add(new WirelessStation(response, varId));
            varId += 10L;
            ++i;
        }
        return stations;
    }

    public void removePackage(long packageId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(110);
        msg.setFieldInt32(126L, (int)packageId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public long installPackage(PackageInfo info, File pkgFile, ProgressListener listener) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(111);
        info.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        long id = response.getFieldAsInt64(126L);
        this.sendFile(msg.getMessageId(), pkgFile, listener, this.allowCompression);
        this.waitForRCC(msg.getMessageId());
        return id;
    }

    public List<PackageInfo> getInstalledPackages() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.newMessage(108);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
        while ((response = this.waitForMessage(109, msg.getMessageId())).getFieldAsInt64(126L) != 0L) {
            list.add(new PackageInfo(response));
        }
        return list;
    }

    public void deployPackage(long packageId, Long[] nodeList, PackageDeploymentListener listener) throws IOException, NXCException {
        NXCPMessage response;
        int status;
        NXCPMessage msg = this.newMessage(119);
        msg.setFieldInt32(126L, (int)packageId);
        msg.setFieldInt32(138L, nodeList.length);
        msg.setField(139L, nodeList);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        if (listener != null) {
            listener.deploymentStarted();
        }
        while ((status = (response = this.waitForMessage(120, msg.getMessageId(), 600000)).getFieldAsInt32(140L)) != 255) {
            if (listener == null) continue;
            if (status == 4) {
                listener.statusUpdate(response.getFieldAsInt64(3L), status, response.getFieldAsString(141L));
                continue;
            }
            listener.statusUpdate(response.getFieldAsInt64(3L), status, "");
        }
        if (listener != null) {
            listener.deploymentComplete();
        }
    }

    public void sendSMS(String phoneNumber, String message) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(208);
        msg.setField(102L, phoneNumber);
        msg.setField(26L, message);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void pushDciData(DciPushData[] data) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(187);
        msg.setFieldInt32(111L, data.length);
        long varId = 0x10000000L;
        DciPushData[] dciPushDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            DciPushData d = dciPushDataArray[n2];
            msg.setFieldInt32(varId++, (int)d.nodeId);
            if (d.nodeId == 0L) {
                msg.setField(varId++, d.nodeName);
            }
            msg.setFieldInt32(varId++, (int)d.dciId);
            if (d.dciId == 0L) {
                msg.setField(varId++, d.dciName);
            }
            msg.setField(varId++, d.value);
            ++n2;
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void pushDciData(long nodeId, long dciId, String value) throws IOException, NXCException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeId, dciId, value)});
    }

    public void pushDciData(String nodeName, String dciName, String value) throws IOException, NXCException {
        this.pushDciData(new DciPushData[]{new DciPushData(nodeName, dciName, value)});
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getShortTimeFormat() {
        return this.shortTimeFormat;
    }

    public void handover(NXCSession target) {
        target.objectList = this.objectList;
        target.objectListGUID = this.objectListGUID;
        target.zoneList = this.zoneList;
        for (AbstractObject o : this.objectList.values()) {
            o.setSession(target);
        }
        this.objectList = null;
        this.objectListGUID = null;
        this.zoneList = null;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public List<MappingTableDescriptor> listMappingTables() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(273);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<MappingTableDescriptor> list = new ArrayList<MappingTableDescriptor>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new MappingTableDescriptor(response, varId));
            varId += 10L;
            ++i;
        }
        return list;
    }

    public MappingTable getMappingTable(int id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(270);
        msg.setFieldInt32(434L, id);
        this.sendMessage(msg);
        return new MappingTable(this.waitForRCC(msg.getMessageId()));
    }

    public int createMappingTable(String name, String description, int flags) throws IOException, NXCException {
        MappingTable mt = new MappingTable(name, description);
        mt.setFlags(flags);
        return this.updateMappingTable(mt);
    }

    public int updateMappingTable(MappingTable table) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(271);
        table.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt32(434L);
    }

    public void deleteMappingTable(int id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(272);
        msg.setFieldInt32(434L, id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public final int getDefaultDciRetentionTime() {
        return this.defaultDciRetentionTime;
    }

    public final int getDefaultDciPollingInterval() {
        return this.defaultDciPollingInterval;
    }

    public int getMinViewRefreshInterval() {
        return this.minViewRefreshInterval;
    }

    public final boolean isStrictAlarmStatusFlow() {
        return this.strictAlarmStatusFlow;
    }

    public boolean isTimedAlarmAckEnabled() {
        return this.timedAlarmAckEnabled;
    }

    public List<DciSummaryTableDescriptor> listDciSummaryTables() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(277);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<DciSummaryTableDescriptor> list = new ArrayList<DciSummaryTableDescriptor>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new DciSummaryTableDescriptor(response, varId));
            varId += 10L;
            ++i;
        }
        return list;
    }

    public DciSummaryTable getDciSummaryTable(int id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(280);
        msg.setFieldInt32(444L, id);
        this.sendMessage(msg);
        return new DciSummaryTable(this.waitForRCC(msg.getMessageId()));
    }

    public int modifyDciSummaryTable(DciSummaryTable table) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(278);
        table.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsInt32(444L);
    }

    public void deleteDciSummaryTable(int id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(279);
        msg.setFieldInt32(444L, id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public Table queryDciSummaryTable(int tableId, long baseObjectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(281);
        msg.setFieldInt32(444L, tableId);
        msg.setFieldInt32(3L, (int)baseObjectId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Table(response);
    }

    public Table queryAdHocDciSummaryTable(long baseObjectId, List<DciSummaryTableColumn> columns, AggregationFunction function, Date periodStart, Date periodEnd, boolean multiInstance) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(306);
        msg.setFieldInt32(3L, (int)baseObjectId);
        msg.setFieldInt32(166L, columns.size());
        msg.setFieldInt16(490L, function != null ? function.getValue() : AggregationFunction.LAST.getValue());
        msg.setField(51L, periodStart);
        msg.setField(52L, periodEnd);
        msg.setFieldInt32(13L, multiInstance ? 1 : 0);
        long id = 0x10000000L;
        for (DciSummaryTableColumn c : columns) {
            c.fillMessage(msg, id);
            id += 10L;
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return new Table(response);
    }

    public List<UUID> listReports() throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4352);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(111L);
        ArrayList<UUID> ret = new ArrayList<UUID>(count);
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            ret.add(response.getFieldAsUUID(base + (long)i));
            ++i;
        }
        return ret;
    }

    public ReportDefinition getReportDefinition(UUID reportId) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4353);
        msg.setField(390L, reportId);
        msg.setField(450L, Locale.getDefault().getLanguage());
        this.sendMessage(msg);
        return new ReportDefinition(reportId, this.waitForRCC(msg.getMessageId()));
    }

    public UUID executeReport(UUID reportId, Map<String, String> parameters) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4354);
        msg.setField(390L, reportId);
        msg.setFieldInt32(137L, parameters.size());
        long varId = 0x10000000L;
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            msg.setField(varId++, e.getKey());
            msg.setField(varId++, e.getValue());
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsUUID(331L);
    }

    public List<ReportResult> listReportResults(UUID reportId) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4355);
        msg.setField(390L, reportId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ArrayList<ReportResult> results = new ArrayList<ReportResult>();
        int count = response.getFieldAsInt32(111L);
        long base = 0x30000000L;
        int i = 0;
        while (i < count) {
            ReportResult result = ReportResult.createFromMessage(response, base);
            results.add(result);
            ++i;
            base += 10L;
        }
        return results;
    }

    public void deleteReportResult(UUID reportId, UUID jobId) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4357);
        msg.setField(390L, reportId);
        msg.setField(331L, jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public File renderReport(UUID reportId, UUID jobId, ReportRenderFormat format) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4356);
        msg.setField(390L, reportId);
        msg.setField(331L, jobId);
        msg.setFieldInt32(400L, format.getCode());
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        ReceivedFile file = this.waitForFile(msg.getMessageId(), 600000);
        if (file.isFailed()) {
            throw new NXCException(16);
        }
        return file.getFile();
    }

    public void scheduleReport(ReportingJob job, Map<String, String> parameters) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4354);
        msg.setField(390L, job.getReportId());
        msg.setField(467L, job.getJobId());
        msg.setFieldInt32(468L, job.getType());
        msg.setFieldInt64(94L, job.getStartTime().getTime());
        msg.setFieldInt32(448L, job.getDaysOfWeek());
        msg.setFieldInt32(449L, job.getDaysOfMonth());
        msg.setField(82L, job.getComments());
        msg.setFieldInt32(137L, parameters.size());
        long varId = 0x10000000L;
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            msg.setField(varId++, e.getKey());
            msg.setField(varId++, e.getValue());
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        if (job.isNotifyOnCompletion()) {
            msg = this.newMessage(4361);
            msg.setField(467L, job.getJobId());
            msg.setFieldInt32(400L, job.getRenderFormat().getCode());
            msg.setField(469L, job.getReportName());
            msg.setFieldInt32(111L, job.getEmailRecipients().size());
            varId = 112L;
            for (String s : job.getEmailRecipients()) {
                msg.setField(varId++, s);
            }
            this.sendMessage(msg);
            this.waitForRCC(msg.getMessageId());
        }
    }

    public List<ReportingJob> listScheduledJobs(UUID reportId) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4358);
        msg.setField(390L, reportId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ArrayList<ReportingJob> result = new ArrayList<ReportingJob>();
        long varId = 0x30000000L;
        int num = response.getFieldAsInt32(111L);
        int i = 0;
        while (i < num) {
            result.add(new ReportingJob(response, varId));
            varId += 20L;
            ++i;
        }
        return result;
    }

    public void deleteReportSchedule(UUID reportId, UUID jobId) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(4359);
        msg.setField(390L, reportId);
        msg.setField(331L, jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    private byte[] signChallenge(Signature signature, byte[] challenge) throws NXCException {
        byte[] signed;
        try {
            signature.update(challenge);
            signed = signature.sign();
        }
        catch (SignatureException signatureException) {
            throw new NXCException(98);
        }
        return signed;
    }

    public String getClientLanguage() {
        return this.clientLanguage;
    }

    public void setClientLanguage(String clientLanguage) {
        this.clientLanguage = clientLanguage;
    }

    public long[] getSubnetAddressMap(long subnetId) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(284);
        msg.setFieldInt32(3L, (int)subnetId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getFieldAsUInt32Array(456L);
    }

    public List<ConfigListElement> getConfigList() throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(176);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int size = response.getFieldAsInt32(174L);
        ArrayList<ConfigListElement> elements = new ArrayList<ConfigListElement>(size);
        long i = 0L;
        long base = 0x10000000L;
        while (i < (long)size) {
            elements.add(new ConfigListElement(base, response));
            ++i;
            base += 10L;
        }
        Collections.sort(elements);
        return elements;
    }

    public ConfigContent getConfigContent(long id) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(177);
        msg.setFieldInt32(231L, (int)id);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ConfigContent content = new ConfigContent(id, response);
        return content;
    }

    public void saveAgentConfig(ConfigContent conf) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(178);
        conf.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteAgentConfig(long id) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(179);
        msg.setFieldInt32(231L, (int)id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void swapAgentConfigs(long id1, long id2) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(180);
        msg.setFieldInt32(231L, (int)id1);
        msg.setFieldInt32(237L, (int)id2);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<GeoLocation> getLocationHistory(long objectId, Date from, Date to) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(301);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setField(51L, from);
        msg.setField(52L, to);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int size = response.getFieldAsInt32(174L);
        ArrayList<GeoLocation> elements = new ArrayList<GeoLocation>();
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < size) {
            elements.add(new GeoLocation(response, fieldId));
            ++i;
            fieldId += 10L;
        }
        Collections.sort(elements, new Comparator<GeoLocation>(){

            @Override
            public int compare(GeoLocation l1, GeoLocation l2) {
                return l1.getTimestamp().compareTo(l2.getTimestamp());
            }
        });
        return elements;
    }

    public byte[] takeScreenshot(long nodeId, String sessionName) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(302);
        msg.setFieldInt32(393L, (int)nodeId);
        if (sessionName != null) {
            msg.setField(20L, sessionName);
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId(), this.msgWaitQueue.getDefaultTimeout() + 60000);
        return response.getFieldAsBinary(460L);
    }

    public List<String> getScheudledTaskHandlers() throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(320);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getStringListFromFields(0x10000000L, 527L);
    }

    public List<ScheduledTask> getScheduledTasks() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(321);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int size = response.getFieldAsInt32(521L);
        ArrayList<ScheduledTask> list = new ArrayList<ScheduledTask>(size);
        long i = 0L;
        long base = 0x10000000L;
        while (i < (long)size) {
            list.add(new ScheduledTask(response, base));
            ++i;
            base += 100L;
        }
        return list;
    }

    public void addScheduledTask(ScheduledTask task) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(322);
        task.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void updateScheduledTask(ScheduledTask task) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(323);
        task.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteScheduledTask(long taskId) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(324);
        msg.setFieldInt32(522L, (int)taskId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setObjectMaintenanceMode(long objectId, boolean inMaintenance) throws NXCException, IOException {
        NXCPMessage msg = this.newMessage(inMaintenance ? 325 : 326);
        msg.setFieldInt32(3L, (int)objectId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void updateZmqEventSubscription(long objectId, long dciId, boolean subscribe) throws IOException, NXCException {
        NXCPMessage msg = subscribe ? this.newMessage(329) : this.newMessage(330);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void updateZmqDataSubscription(long objectId, long dciId, boolean subscribe) throws IOException, NXCException {
        NXCPMessage msg = subscribe ? this.newMessage(331) : this.newMessage(332);
        msg.setFieldInt32(3L, (int)objectId);
        msg.setFieldInt32(43L, (int)dciId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<ZmqSubscription> getZmqSubscriptions(ZmqSubscriptionType type) throws IOException, NXCException {
        long objectId;
        NXCPMessage msg = this.newMessage(type == ZmqSubscriptionType.EVENT ? 333 : 334);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        ArrayList<ZmqSubscription> subscriptions = new ArrayList<ZmqSubscription>();
        long baseId = 0x10000000L;
        while ((objectId = (long)response.getFieldAsInt32(baseId)) != 0L) {
            boolean ignoreItems = response.getFieldAsBoolean(baseId + 1L);
            long[] dciElements = response.getFieldAsUInt32Array(baseId + 2L);
            subscriptions.add(new ZmqSubscription(objectId, ignoreItems, dciElements));
            baseId += 10L;
        }
        return subscriptions;
    }

    public List<Repository> getRepositories() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(335);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<Repository> list = new ArrayList<Repository>(count);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count) {
            list.add(new Repository(response, fieldId));
            fieldId += 10L;
            ++i;
        }
        return list;
    }

    public void addRepository(Repository r) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(336);
        r.fillMessage(msg);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        r.setId(response.getFieldAsInt32(3L));
    }

    public void modifyRepository(Repository r) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(337);
        r.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteRepository(int id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(338);
        msg.setFieldInt32(541L, id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public List<PredictionEngine> getPredictionEngines() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(86);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<PredictionEngine> engines = new ArrayList<PredictionEngine>(count);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count) {
            engines.add(new PredictionEngine(response, fieldId));
            fieldId += 10L;
            ++i;
        }
        return engines;
    }

    public DciData getPredictedData(long nodeId, long dciId, Date from, Date to) throws IOException, NXCException {
        int rowsReceived;
        NXCPMessage msg = this.newMessage(87);
        msg.setFieldInt32(3L, (int)nodeId);
        msg.setFieldInt32(43L, (int)dciId);
        DciData data = new DciData(nodeId, dciId);
        int timeFrom = (int)(from.getTime() / 1000L);
        int timeTo = (int)(to.getTime() / 1000L);
        do {
            DciDataRow row;
            msg.setMessageId(this.requestId.getAndIncrement());
            msg.setFieldInt32(51L, timeFrom);
            msg.setFieldInt32(52L, timeTo);
            this.sendMessage(msg);
            this.waitForRCC(msg.getMessageId());
            NXCPMessage response = this.waitForMessage(50, msg.getMessageId());
            if (!response.isBinaryMessage()) {
                throw new NXCException(46);
            }
            rowsReceived = this.parseDataRows(response.getBinaryData(), data);
            if (rowsReceived != 200000 || (row = data.getLastValue()) == null) continue;
            timeTo = (int)(row.getTimestamp().getTime() / 1000L) - 1;
        } while (rowsReceived == 200000 && timeTo > timeFrom);
        return data;
    }

    public List<AgentTunnel> getAgentTunnels() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(214);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getFieldAsInt32(361L);
        ArrayList<AgentTunnel> tunnels = new ArrayList<AgentTunnel>(count);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count) {
            tunnels.add(new AgentTunnel(response, fieldId));
            fieldId += 64L;
            ++i;
        }
        return tunnels;
    }

    public void bindAgentTunnel(int tunnelId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(215);
        msg.setFieldInt32(579L, tunnelId);
        msg.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unbindAgentTunnel(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(353);
        msg.setFieldInt32(393L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpProxy setupTcpProxy(long nodeId, InetAddress address, int port) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(364);
        msg.setFieldInt32(393L, (int)nodeId);
        msg.setField(8L, address);
        msg.setFieldInt16(268L, port);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        TcpProxy proxy = new TcpProxy(this, response.getFieldAsInt32(574L));
        Map<Integer, TcpProxy> map = this.tcpProxies;
        synchronized (map) {
            this.tcpProxies.put(proxy.getChannelId(), proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTcpProxy(int channelId) {
        NXCPMessage msg = this.newMessage(366);
        msg.setFieldInt32(574L, channelId);
        try {
            this.sendMessage(msg);
            this.waitForRCC(msg.getMessageId());
        }
        catch (Exception exception) {}
        Map<Integer, TcpProxy> map = this.tcpProxies;
        synchronized (map) {
            this.tcpProxies.remove(channelId);
        }
    }

    static /* synthetic */ int access$0(NXCSession nXCSession) {
        return nXCSession.defaultRecvBufferSize;
    }

    static /* synthetic */ int access$1(NXCSession nXCSession) {
        return nXCSession.maxRecvBufferSize;
    }

    static /* synthetic */ Socket access$2(NXCSession nXCSession) {
        return nXCSession.socket;
    }

    static /* synthetic */ EncryptionContext access$3(NXCSession nXCSession) {
        return nXCSession.encryptionContext;
    }

    static /* synthetic */ void access$4(NXCSession nXCSession, NXCPMessage nXCPMessage) throws IOException, NXCException {
        nXCSession.setupEncryption(nXCPMessage);
    }

    static /* synthetic */ void access$5(NXCSession nXCSession, long l) {
        nXCSession.serverTime = l;
    }

    static /* synthetic */ void access$6(NXCSession nXCSession, long l) {
        nXCSession.serverTimeRecvTime = l;
    }

    static /* synthetic */ AbstractObject access$7(NXCSession nXCSession, NXCPMessage nXCPMessage) {
        return nXCSession.createObjectFromMessage(nXCPMessage);
    }

    static /* synthetic */ Map access$8(NXCSession nXCSession) {
        return nXCSession.objectList;
    }

    static /* synthetic */ Map access$9(NXCSession nXCSession) {
        return nXCSession.objectListGUID;
    }

    static /* synthetic */ Map access$10(NXCSession nXCSession) {
        return nXCSession.zoneList;
    }

    static /* synthetic */ Semaphore access$11(NXCSession nXCSession) {
        return nXCSession.syncObjects;
    }

    static /* synthetic */ void access$12(NXCSession nXCSession, Semaphore semaphore) {
        nXCSession.completeSync(semaphore);
    }

    static /* synthetic */ Semaphore access$14(NXCSession nXCSession) {
        return nXCSession.syncUserDB;
    }

    static /* synthetic */ NXCPMsgWaitQueue access$16(NXCSession nXCSession) {
        return nXCSession.msgWaitQueue;
    }

    static /* synthetic */ LinkedBlockingQueue access$28(NXCSession nXCSession) {
        return nXCSession.notificationQueue;
    }

    static /* synthetic */ Set access$29(NXCSession nXCSession) {
        return nXCSession.listeners;
    }

    private class HousekeeperThread
    extends Thread {
        private boolean stopFlag = false;

        HousekeeperThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopFlag) {
                Iterator<Object> it;
                try {
                    HousekeeperThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                long currTime = System.currentTimeMillis();
                Map map = NXCSession.this.receivedFiles;
                synchronized (map) {
                    it = NXCSession.this.receivedFiles.values().iterator();
                    while (it.hasNext()) {
                        NXCReceivedFile file = (NXCReceivedFile)it.next();
                        if (file.getTimestamp() + 300000L >= currTime) continue;
                        file.getFile().delete();
                        it.remove();
                    }
                }
                map = NXCSession.this.messageSubscriptions;
                synchronized (map) {
                    it = NXCSession.this.messageSubscriptions.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = (Map.Entry)it.next();
                        MessageHandler h = (MessageHandler)e.getValue();
                        if (currTime - h.getLastMessageTimestamp() <= (long)h.getMessageWaitTimeout()) continue;
                        h.setTimeout();
                        h.setComplete();
                        it.remove();
                    }
                }
            }
        }

        public void setStopFlag(boolean stopFlag) {
            this.stopFlag = stopFlag;
        }
    }

    protected final class MessageSubscription {
        protected int messageCode;
        protected long messageId;

        protected MessageSubscription(int messageCode, long messageId) {
            this.messageCode = messageCode;
            this.messageId = messageId;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.messageCode;
            result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageSubscription other = (MessageSubscription)obj;
            if (this.messageCode != other.messageCode) {
                return false;
            }
            return this.messageId == other.messageId;
        }
    }

    private class NotificationProcessor
    extends Thread {
        private SessionListener[] cachedListenerList = new SessionListener[0];

        NotificationProcessor() {
            this.setName("Session Notification Processor");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    n = (SessionNotification)NXCSession.access$28(NXCSession.this).take();
                }
                catch (InterruptedException v0) {
                    continue;
                }
                if (n.getCode() == 32767) break;
                if (n.getCode() == 32766) {
                    var2_2 = NXCSession.access$29(NXCSession.this);
                    synchronized (var2_2) {
                        this.cachedListenerList = NXCSession.access$29(NXCSession.this).toArray(new SessionListener[NXCSession.access$29(NXCSession.this).size()]);
                    }
                }
                var5_5 = this.cachedListenerList;
                var4_4 = this.cachedListenerList.length;
                var3_3 = 0;
                while (true) {
                    if (var3_3 < var4_4) ** break;
                    continue block7;
                    l = var5_5[var3_3];
                    try {
                        l.notificationHandler(n);
                    }
                    catch (Exception e) {
                        Logger.error((String)"NXCSession.NotificationProcessor", (String)"Unhandled exception in notification handler", (Throwable)e);
                    }
                    ++var3_3;
                }
                break;
            }
            this.cachedListenerList = null;
        }
    }

    private class ReceiverThread
    extends Thread {
        ReceiverThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            receiver = new NXCPMessageReceiver(NXCSession.access$0(NXCSession.this), NXCSession.access$1(NXCSession.this));
            try {
                in = NXCSession.access$2(NXCSession.this).getInputStream();
                if (true) ** GOTO lbl183
            }
            catch (IOException v0) {
                return;
            }
            block51: do {
                try {
                    msg = receiver.receiveMessage(in, NXCSession.access$3(NXCSession.this));
                    switch (msg.getMessageCode()) {
                        case 130: {
                            NXCSession.access$4(NXCSession.this, msg);
                            break;
                        }
                        case 3: {
                            NXCSession.access$5(NXCSession.this, msg.getFieldAsInt64(94L) * 1000L);
                            NXCSession.access$6(NXCSession.this, System.currentTimeMillis());
                            break;
                        }
                        case 6: 
                        case 10: {
                            if (!msg.getFieldAsBoolean(30L)) {
                                obj = NXCSession.access$7(NXCSession.this, msg);
                                var5_9 = NXCSession.access$8(NXCSession.this);
                                synchronized (var5_9) {
                                    NXCSession.access$8(NXCSession.this).put(obj.getObjectId(), obj);
                                    NXCSession.access$9(NXCSession.this).put(obj.getGuid(), obj);
                                    if (obj instanceof Zone) {
                                        NXCSession.access$10(NXCSession.this).put(((Zone)obj).getUIN(), (Zone)obj);
                                    }
                                }
                                if (msg.getMessageCode() != 10) continue block51;
                                NXCSession.this.sendNotification(new SessionNotification(4, obj.getObjectId(), obj));
                                break;
                            }
                            objectId = msg.getFieldAsInt32(3L);
                            var6_10 = NXCSession.access$8(NXCSession.this);
                            synchronized (var6_10) {
                                object = (AbstractObject)NXCSession.access$8(NXCSession.this).get(objectId);
                                if (object != null) {
                                    NXCSession.access$9(NXCSession.this).remove(object.getGuid());
                                    NXCSession.access$8(NXCSession.this).remove(objectId);
                                    if (object instanceof Zone) {
                                        NXCSession.access$10(NXCSession.this).remove(((Zone)object).getUIN());
                                    }
                                }
                            }
                            NXCSession.this.sendNotification(new SessionNotification(99, objectId));
                            break;
                        }
                        case 9: {
                            NXCSession.access$12(NXCSession.this, NXCSession.access$11(NXCSession.this));
                            break;
                        }
                        case 31: {
                            user = new User(msg);
                            var5_9 = NXCSession.access$13(NXCSession.this);
                            synchronized (var5_9) {
                                if (user.isDeleted()) {
                                    NXCSession.access$13(NXCSession.this).remove(user.getId());
                                } else {
                                    NXCSession.access$13(NXCSession.this).put(user.getId(), user);
                                }
                                break;
                            }
                        }
                        case 32: {
                            group = new UserGroup(msg);
                            var6_10 = NXCSession.access$13(NXCSession.this);
                            synchronized (var6_10) {
                                if (group.isDeleted()) {
                                    NXCSession.access$13(NXCSession.this).remove(group.getId());
                                } else {
                                    NXCSession.access$13(NXCSession.this).put(group.getId(), group);
                                }
                                break;
                            }
                        }
                        case 33: {
                            NXCSession.access$12(NXCSession.this, NXCSession.access$14(NXCSession.this));
                            break;
                        }
                        case 39: {
                            this.processUserDBUpdate(msg);
                            break;
                        }
                        case 73: {
                            NXCSession.this.sendNotification(new SessionNotification(msg.getFieldAsInt32(23L) + 1000, new Alarm(msg)));
                            break;
                        }
                        case 345: {
                            this.processBulkAlarmStateChange(msg);
                            break;
                        }
                        case 141: {
                            NXCSession.this.sendNotification(new SessionNotification(10, new ServerJob(msg)));
                            break;
                        }
                        case 105: {
                            this.processFileData(msg);
                            break;
                        }
                        case 285: {
                            this.processFileTail(msg);
                            break;
                        }
                        case 114: {
                            this.processFileTransferError(msg);
                            break;
                        }
                        case 18: {
                            this.processNotificationMessage(msg, true);
                            break;
                        }
                        case 4360: {
                            this.processNotificationMessage(msg, false);
                            break;
                        }
                        case 12: {
                            this.processNewEvents(msg);
                            break;
                        }
                        case 160: {
                            this.processNewTraps(msg);
                            break;
                        }
                        case 140: {
                            this.processSyslogRecords(msg);
                            break;
                        }
                        case 79: {
                            this.processActionConfigChange(msg);
                            break;
                        }
                        case 24: {
                            this.processEventConfigChange(msg);
                            break;
                        }
                        case 25: {
                            this.processTrapConfigChange(msg);
                            break;
                        }
                        case 127: {
                            this.processConsoleOutput(msg);
                            break;
                        }
                        case 256: {
                            this.processImageLibraryUpdate(msg);
                            break;
                        }
                        case 307: {
                            graph = GraphSettings.createGraphSettings(msg, 0x10000000L);
                            NXCSession.this.sendNotification(new SessionNotification(1012, graph.getId(), graph));
                            break;
                        }
                        case 342: {
                            this.processAlarmCategoryConfigChange(msg);
                            break;
                        }
                        case 365: {
                            this.processTcpProxyData((int)msg.getMessageId(), msg.getBinaryData());
                            break;
                        }
                        case 366: {
                            this.processTcpProxyClosure(msg.getFieldAsInt32(574L));
                            break;
                        }
                        default: {
                            var7_11 = NXCSession.access$15(NXCSession.this);
                            synchronized (var7_11) {
                                s = new MessageSubscription(msg.getMessageCode(), msg.getMessageId());
                                handler = (MessageHandler)NXCSession.access$15(NXCSession.this).get(s);
                                if (handler != null) {
                                    if (handler.processMessage(msg)) {
                                        msg = null;
                                    }
                                    if (handler.isComplete()) {
                                        NXCSession.access$15(NXCSession.this).remove(s);
                                    } else {
                                        handler.setLastMessageTimestamp(System.currentTimeMillis());
                                    }
                                }
                            }
                            if (msg == null) continue block51;
                            if (msg.getMessageCode() >= 4096) {
                                NXCSession.this.sendNotification(new SessionNotification(2000, msg));
                            }
                            NXCSession.access$16(NXCSession.this).putMessage(msg);
                            break;
                        }
                    }
                }
                catch (IOException v6) {
                    break;
                }
                catch (NXCPException e) {
                    if (e.getErrorCode() != 2) continue;
                    break;
                }
                catch (NXCException e) {
                    if (e.getErrorCode() == 98) break;
                }
lbl183:
                // 8 sources

            } while (NXCSession.access$2(NXCSession.this).isConnected());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processConsoleOutput(NXCPMessage msg) {
            String text = msg.getFieldAsString(26L);
            Set set = NXCSession.this.consoleListeners;
            synchronized (set) {
                for (ServerConsoleListener l : NXCSession.this.consoleListeners) {
                    l.onConsoleOutput(text);
                }
            }
        }

        private void processNewEvents(NXCPMessage msg) {
            int count = msg.getFieldAsInt32(174L);
            int order = msg.getFieldAsInt32(210L);
            long varId = 0x10000000L;
            int i = 0;
            while (i < count) {
                Event event = new Event(msg, varId);
                NXCSession.this.sendNotification(new SessionNotification(2, order, event));
                ++i;
            }
        }

        private void processNewTraps(NXCPMessage msg) {
            int count = msg.getFieldAsInt32(174L);
            int order = msg.getFieldAsInt32(210L);
            long varId = 0x10000000L;
            int i = 0;
            while (i < count) {
                SnmpTrapLogRecord trap = new SnmpTrapLogRecord(msg, varId);
                NXCSession.this.sendNotification(new SessionNotification(8, order, trap));
                ++i;
            }
        }

        private void processSyslogRecords(NXCPMessage msg) {
            int count = msg.getFieldAsInt32(174L);
            int order = msg.getFieldAsInt32(210L);
            long varId = 0x10000000L;
            int i = 0;
            while (i < count) {
                SyslogRecord record = new SyslogRecord(msg, varId);
                NXCSession.this.sendNotification(new SessionNotification(7, order, record));
                ++i;
            }
        }

        private void processBulkAlarmStateChange(NXCPMessage msg) {
            int code = msg.getFieldAsInt32(23L) + 1000;
            NXCSession.this.sendNotification(new SessionNotification(code, new BulkAlarmStateChangeData(msg)));
        }

        private void processNotificationMessage(NXCPMessage msg, boolean shiftCode) {
            int code = msg.getFieldAsInt32(23L);
            if (shiftCode) {
                code += 1000;
            }
            long data = msg.getFieldAsInt64(92L);
            switch (code) {
                case 1024: {
                    NXCSession.this.strictAlarmStatusFlow = (int)data != 0;
                    break;
                }
                case 1002: {
                    if (!NXCSession.this.eventTemplatesNeedSync) break;
                    NXCSession.this.resyncEventTemplates();
                    break;
                }
                case 1: 
                case 1001: 
                case 1027: {
                    NXCSession.this.backgroundDisconnect(code);
                    return;
                }
            }
            NXCSession.this.sendNotification(new SessionNotification(code, data));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileTail(NXCPMessage msg) {
            String fileName = msg.getFieldAsString(125L);
            String fileContent = msg.getFieldAsString(460L);
            Map map = NXCSession.this.receivedFileUpdates;
            synchronized (map) {
                NXCSession.this.receivedFileUpdates.put(fileName, fileContent);
                NXCSession.this.receivedFileUpdates.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileData(NXCPMessage msg) {
            NXCReceivedFile file;
            long id = msg.getMessageId();
            Map map = NXCSession.this.receivedFiles;
            synchronized (map) {
                file = (NXCReceivedFile)NXCSession.this.receivedFiles.get(id);
                if (file == null) {
                    file = new NXCReceivedFile(id);
                    NXCSession.this.receivedFiles.put(id, file);
                }
            }
            int bytes = file.writeData(msg.getBinaryData(), msg.isCompressedStream());
            NXCSession.this.notifyProgressListener(id, bytes);
            if (msg.isEndOfFile()) {
                file.close();
                Map map2 = NXCSession.this.receivedFiles;
                synchronized (map2) {
                    NXCSession.this.receivedFiles.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileTransferError(NXCPMessage msg) {
            long id = msg.getMessageId();
            Map map = NXCSession.this.receivedFiles;
            synchronized (map) {
                NXCReceivedFile file = (NXCReceivedFile)NXCSession.this.receivedFiles.get(id);
                if (file == null) {
                    file = new NXCReceivedFile(id);
                    NXCSession.this.receivedFiles.put(id, file);
                }
                file.abortTransfer(msg.getFieldAsBoolean(609L));
                NXCSession.this.receivedFiles.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUserDBUpdate(NXCPMessage msg) {
            int code = msg.getFieldAsInt32(42L);
            long id = msg.getFieldAsInt64(35L);
            AbstractUserObject object = null;
            switch (code) {
                case 0: 
                case 2: {
                    object = (id & Integer.MIN_VALUE) != 0L ? new UserGroup(msg) : new User(msg);
                    Map map = NXCSession.this.userDB;
                    synchronized (map) {
                        NXCSession.this.userDB.put(id, object);
                        break;
                    }
                }
                case 1: {
                    Map map = NXCSession.this.userDB;
                    synchronized (map) {
                        object = (AbstractUserObject)NXCSession.this.userDB.get(id);
                        if (object != null) {
                            NXCSession.this.userDB.remove(id);
                        }
                        break;
                    }
                }
            }
            if (object != null) {
                NXCSession.this.sendNotification(new SessionNotification(3, code, object));
            }
        }

        private void processTrapConfigChange(NXCPMessage msg) {
            int code = msg.getFieldAsInt32(23L) + 1000;
            long id = msg.getFieldAsInt64(117L);
            SnmpTrap trap = code != 1018 ? new SnmpTrap(msg) : null;
            NXCSession.this.sendNotification(new SessionNotification(code, id, trap));
        }

        private void processActionConfigChange(NXCPMessage msg) {
            int code = msg.getFieldAsInt32(23L) + 1000;
            long id = msg.getFieldAsInt64(97L);
            ServerAction action = code != 1008 ? new ServerAction(msg) : null;
            NXCSession.this.sendNotification(new SessionNotification(code, id, action));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEventConfigChange(NXCPMessage msg) {
            EventTemplate et;
            int code = msg.getFieldAsInt32(23L) + 1000;
            long eventCode = msg.getFieldAsInt64(24L);
            EventTemplate eventTemplate = et = code != 1014 ? new EventTemplate(msg) : null;
            if (NXCSession.this.eventTemplatesNeedSync) {
                Map map = NXCSession.this.eventTemplates;
                synchronized (map) {
                    if (code == 1014) {
                        NXCSession.this.eventTemplates.remove(eventCode);
                    } else {
                        NXCSession.this.eventTemplates.put(eventCode, et);
                    }
                }
            }
            NXCSession.this.sendNotification(new SessionNotification(code, eventCode, et));
        }

        public void processImageLibraryUpdate(NXCPMessage msg) {
            UUID imageGuid = msg.getFieldAsUUID(222L);
            int flags = msg.getFieldAsInt32(13L);
            NXCSession.this.sendNotification(new SessionNotification(11, flags == 0 ? 201 : 202, imageGuid));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAlarmCategoryConfigChange(NXCPMessage msg) {
            AlarmCategory ac;
            int code = msg.getFieldAsInt32(23L) + 1000;
            long categoryId = msg.getFieldAsInt64(0x10000000L);
            AlarmCategory alarmCategory = ac = code != 1031 ? new AlarmCategory(msg, 0x10000000L) : null;
            if (NXCSession.this.alarmCategoriesNeedSync) {
                Map map = NXCSession.this.alarmCategories;
                synchronized (map) {
                    if (code == 1031) {
                        NXCSession.this.alarmCategories.remove(categoryId);
                    } else {
                        NXCSession.this.alarmCategories.put(categoryId, ac);
                    }
                }
            }
            NXCSession.this.sendNotification(new SessionNotification(code, categoryId, ac));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTcpProxyData(int channelId, byte[] data) {
            TcpProxy proxy;
            Map map = NXCSession.this.tcpProxies;
            synchronized (map) {
                proxy = (TcpProxy)NXCSession.this.tcpProxies.get(channelId);
            }
            if (proxy != null) {
                proxy.processRemoteData(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTcpProxyClosure(int channelId) {
            TcpProxy proxy;
            Map map = NXCSession.this.tcpProxies;
            synchronized (map) {
                proxy = (TcpProxy)NXCSession.this.tcpProxies.remove(channelId);
            }
            if (proxy != null) {
                proxy.localClose();
            }
        }
    }
}

