/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.python.core.AbstractDict;
import org.python.core.BaseDictionaryView;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyDictionary$PyDictionaryViewItems$PyExposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___and___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___eq___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___gt___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___iter___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___lt___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___ne___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___or___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___sub___exposer;
import org.python.core.PyDictionary$PyDictionaryViewKeys$dict_keys___xor___exposer;
import org.python.core.PyDictionary$PyDictionaryViewValues$dict_values___iter___exposer;
import org.python.core.PyDictionary$PyDictionaryViewValues$dict_values___len___exposer;
import org.python.core.PyDictionary$PyDictionaryViewValues$dict_values_toString_exposer;
import org.python.core.PyDictionary$PyExposer;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyMapEntrySet;
import org.python.core.PyMapKeyValSet;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySet;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.SimpleEntry;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

@ExposedType(name="dict", base=PyObject.class, doc="dict() -> new empty dictionary\ndict(mapping) -> new dictionary initialized from a mapping object's\n    (key, value) pairs\ndict(iterable) -> new dictionary initialized as if via:\n    d = {}\n    for k, v in iterable:\n        d[k] = v\ndict(**kwargs) -> new dictionary initialized with the name=value pairs\n    in the keyword argument list.  For example:  dict(one=1, two=2)")
public class PyDictionary
extends AbstractDict
implements ConcurrentMap,
Traverseproc {
    public static final PyType TYPE;
    private final ConcurrentMap<PyObject, PyObject> internalMap;

    public ConcurrentMap<PyObject, PyObject> getMap() {
        return this.internalMap;
    }

    public PyDictionary() {
        this(TYPE);
    }

    public PyDictionary(PyType type, int capacity) {
        super(type);
        TYPE.object___setattr__("__hash__", Py.None);
        this.internalMap = new ConcurrentHashMap<PyObject, PyObject>(capacity, 0.75f, 2);
    }

    public PyDictionary(PyType type) {
        super(type);
        TYPE.object___setattr__("__hash__", Py.None);
        this.internalMap = Generic.concurrentMap();
    }

    public PyDictionary(Map<PyObject, PyObject> map) {
        this(TYPE, map);
    }

    public PyDictionary(ConcurrentMap<PyObject, PyObject> backingMap, boolean useBackingMap) {
        super(TYPE);
        TYPE.object___setattr__("__hash__", Py.None);
        this.internalMap = backingMap;
    }

    public PyDictionary(PyType type, ConcurrentMap<PyObject, PyObject> backingMap, boolean useBackingMap) {
        super(type);
        TYPE.object___setattr__("__hash__", Py.None);
        this.internalMap = backingMap;
    }

    public PyDictionary(PyType type, Map<PyObject, PyObject> map) {
        this(type, Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        this.getMap().putAll(map);
    }

    protected PyDictionary(PyType type, boolean initializeBacking) {
        super(type);
        TYPE.object___setattr__("__hash__", Py.None);
        this.internalMap = initializeBacking ? Generic.concurrentMap() : null;
    }

    public PyDictionary(PyObject[] elements) {
        this();
        ConcurrentMap<PyObject, PyObject> map = this.getMap();
        for (int i = 0; i < elements.length; i += 2) {
            map.put(elements[i], elements[i + 1]);
        }
    }

    @ExposedNew
    protected final void dict___init__(PyObject[] args, String[] keywords) {
        this.updateCommon(args, keywords, "dict");
    }

    public static PyObject fromkeys(PyObject keys) {
        return PyDictionary.fromkeys(keys, Py.None);
    }

    public static PyObject fromkeys(PyObject keys, PyObject value) {
        return PyDictionary.dict_fromkeys(TYPE, keys, value);
    }

    static PyObject dict_fromkeys(PyType type, PyObject keys, PyObject value) {
        PyObject d = type.__call__();
        for (PyObject o : keys.asIterable()) {
            d.__setitem__(o, value);
        }
        return d;
    }

    @Override
    public int __len__() {
        return this.dict___len__();
    }

    final int dict___len__() {
        return this.getMap().size();
    }

    @Override
    public boolean __nonzero__() {
        return this.getMap().size() != 0;
    }

    @Override
    public PyObject __finditem__(int index) {
        throw Py.TypeError("loop over non-sequence");
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        return (PyObject)this.getMap().get(key);
    }

    protected final PyObject dict___getitem__(PyObject key) {
        PyObject missing;
        PyObject result2 = (PyObject)this.getMap().get(key);
        if (result2 != null) {
            return result2;
        }
        PyType type = this.getType();
        if (type != TYPE && (missing = type.lookup("__missing__")) != null) {
            return missing.__get__(this, type).__call__(key);
        }
        throw Py.KeyError(key);
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        this.dict___setitem__(key, value);
    }

    final void dict___setitem__(PyObject key, PyObject value) {
        this.getMap().put(key, value);
    }

    @Override
    public void __delitem__(PyObject key) {
        this.dict___delitem__(key);
    }

    final void dict___delitem__(PyObject key) {
        Object ret = this.getMap().remove(key);
        if (ret == null) {
            throw Py.KeyError(key.toString());
        }
    }

    @Override
    public PyObject __iter__() {
        return this.dict___iter__();
    }

    final PyObject dict___iter__() {
        return this.iterkeys();
    }

    @Override
    public String toString() {
        return this.dict_toString();
    }

    final String dict_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        StringBuilder buf = new StringBuilder("{");
        for (Map.Entry entry : this.getMap().entrySet()) {
            buf.append(((PyObject)entry.getKey()).__repr__().toString());
            buf.append(": ");
            buf.append(((PyObject)entry.getValue()).__repr__().toString());
            buf.append(", ");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public PyObject __eq__(PyObject otherObj) {
        return this.dict___eq__(otherObj);
    }

    final PyObject dict___eq__(PyObject otherObj) {
        int bn;
        PyType thisType = this.getType();
        PyType otherType = otherObj.getType();
        if (otherType != thisType && !thisType.isSubType(otherType) && !otherType.isSubType(thisType) || otherType == PyObject.TYPE) {
            return null;
        }
        PyDictionary other = (PyDictionary)otherObj;
        int an = this.getMap().size();
        if (an != (bn = other.getMap().size())) {
            return Py.False;
        }
        PyList akeys = this.keys();
        for (int i = 0; i < an; ++i) {
            PyObject akey = akeys.pyget(i);
            PyObject bvalue = other.__finditem__(akey);
            if (bvalue == null) {
                return Py.False;
            }
            PyObject avalue = this.__finditem__(akey);
            if (avalue._eq(bvalue).__nonzero__()) continue;
            return Py.False;
        }
        return Py.True;
    }

    @Override
    public PyObject __ne__(PyObject otherObj) {
        return this.dict___ne__(otherObj);
    }

    final PyObject dict___ne__(PyObject otherObj) {
        PyObject eq_result = this.__eq__(otherObj);
        if (eq_result == null) {
            return null;
        }
        return eq_result.__not__();
    }

    final PyObject dict___lt__(PyObject otherObj) {
        int result2 = this.__cmp__(otherObj);
        if (result2 == -2) {
            return null;
        }
        return result2 < 0 ? Py.True : Py.False;
    }

    final PyObject dict___gt__(PyObject otherObj) {
        int result2 = this.__cmp__(otherObj);
        if (result2 == -2) {
            return null;
        }
        return result2 > 0 ? Py.True : Py.False;
    }

    final PyObject dict___le__(PyObject otherObj) {
        int result2 = this.__cmp__(otherObj);
        if (result2 == -2) {
            return null;
        }
        return result2 <= 0 ? Py.True : Py.False;
    }

    final PyObject dict___ge__(PyObject otherObj) {
        int result2 = this.__cmp__(otherObj);
        if (result2 == -2) {
            return null;
        }
        return result2 >= 0 ? Py.True : Py.False;
    }

    @Override
    public int __cmp__(PyObject otherObj) {
        return this.dict___cmp__(otherObj);
    }

    final int dict___cmp__(PyObject otherObj) {
        int bn;
        PyType thisType = this.getType();
        PyType otherType = otherObj.getType();
        if (otherType != thisType && !thisType.isSubType(otherType) && !otherType.isSubType(thisType) || otherType == PyObject.TYPE) {
            return -2;
        }
        PyDictionary other = (PyDictionary)otherObj;
        int an = this.getMap().size();
        if (an < (bn = other.getMap().size())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = other.keys();
        akeys.sort();
        bkeys.sort();
        for (int i = 0; i < bn; ++i) {
            PyObject bkey;
            PyObject akey = akeys.pyget(i);
            int c = akey._cmp(bkey = bkeys.pyget(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            PyObject bvalue = other.__finditem__(bkey);
            if (avalue == null) {
                if (bvalue == null) continue;
                return -3;
            }
            if (bvalue == null) {
                return -3;
            }
            c = avalue._cmp(bvalue);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public boolean has_key(PyObject key) {
        return this.dict_has_key(key);
    }

    final boolean dict_has_key(PyObject key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.dict___contains__(o);
    }

    final boolean dict___contains__(PyObject o) {
        return this.dict_has_key(o);
    }

    @Override
    public PyObject get(PyObject key, PyObject defaultObj) {
        return this.dict_get(key, defaultObj);
    }

    final PyObject dict_get(PyObject key, PyObject defaultObj) {
        PyObject o = (PyObject)this.getMap().get(key);
        return o == null ? defaultObj : o;
    }

    @Override
    public PyObject get(PyObject key) {
        return this.dict_get(key, Py.None);
    }

    @Override
    public PyDictionary copy() {
        return this.dict_copy();
    }

    final PyDictionary dict_copy() {
        return new PyDictionary(this.getMap());
    }

    @Override
    public void clear() {
        this.dict_clear();
    }

    final void dict_clear() {
        this.getMap().clear();
    }

    @Override
    public void update(PyObject other) {
        this.dict_update(new PyObject[]{other}, Py.NoKeywords);
    }

    final void dict_update(PyObject[] args, String[] keywords) {
        this.updateCommon(args, keywords, "update");
    }

    public void updateCommon(PyObject[] args, String[] keywords, String methName) {
        int nargs = args.length - keywords.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, methName, 0, 1);
        }
        if (nargs == 1) {
            PyObject arg = args[0];
            Object proxy = arg.getJavaProxy();
            if (proxy instanceof Map) {
                this.merge((Map)proxy);
            } else if (arg.__findattr__("keys") != null) {
                this.merge(arg);
            } else {
                this.mergeFromSeq(arg);
            }
        }
        for (int i = 0; i < keywords.length; ++i) {
            this.dict___setitem__(Py.newString(keywords[i]), args[nargs + i]);
        }
    }

    private void merge(Map<Object, Object> other) {
        for (Map.Entry<Object, Object> entry : other.entrySet()) {
            this.dict___setitem__(Py.java2py(entry.getKey()), Py.java2py(entry.getValue()));
        }
    }

    private void merge(PyObject other) {
        if (other instanceof PyDictionary) {
            this.getMap().putAll(((PyDictionary)other).getMap());
        } else if (other instanceof PyStringMap) {
            this.mergeFromKeys(other, ((PyStringMap)other).keys());
        } else {
            this.mergeFromKeys(other, other.invoke("keys"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(PyObject other, boolean override) {
        ConcurrentMap<PyObject, PyObject> concurrentMap = this.internalMap;
        synchronized (concurrentMap) {
            if (override) {
                this.merge(other);
            } else if (other instanceof PyDictionary) {
                Set entrySet = ((PyDictionary)other).internalMap.entrySet();
                for (Map.Entry ent : entrySet) {
                    if (this.internalMap.containsKey(ent.getKey())) continue;
                    this.internalMap.put((PyObject)ent.getKey(), (PyObject)ent.getValue());
                }
            } else if (other instanceof PyStringMap) {
                this.mergeFromKeys(other, ((PyStringMap)other).keys(), override);
            } else {
                this.mergeFromKeys(other, other.invoke("keys"), override);
            }
        }
    }

    private void mergeFromKeys(PyObject other, PyObject keys) {
        for (PyObject key : keys.asIterable()) {
            this.dict___setitem__(key, other.__getitem__(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeFromKeys(PyObject other, PyObject keys, boolean override) {
        ConcurrentMap<PyObject, PyObject> concurrentMap = this.internalMap;
        synchronized (concurrentMap) {
            if (override) {
                this.mergeFromKeys(other, keys);
            } else {
                for (PyObject key : keys.asIterable()) {
                    if (this.dict___contains__(key)) continue;
                    this.dict___setitem__(key, other.__getitem__(key));
                }
            }
        }
    }

    private void mergeFromSeq(PyObject other) {
        PyObject pair;
        PyObject pairs = other.__iter__();
        int i = 0;
        while ((pair = pairs.__iternext__()) != null) {
            try {
                pair = PySequence.fastSequence(pair, "");
            }
            catch (PyException pye) {
                if (pye.match(Py.TypeError)) {
                    throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", i));
                }
                throw pye;
            }
            int n = pair.__len__();
            if (n != 2) {
                throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", i, n));
            }
            this.dict___setitem__(pair.__getitem__(0), pair.__getitem__(1));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeFromSeq(PyObject other, boolean override) {
        ConcurrentMap<PyObject, PyObject> concurrentMap = this.internalMap;
        synchronized (concurrentMap) {
            if (override) {
                this.mergeFromSeq(other);
            } else {
                PyObject pair;
                PyObject pairs = other.__iter__();
                int i = 0;
                while ((pair = pairs.__iternext__()) != null) {
                    try {
                        pair = PySequence.fastSequence(pair, "");
                    }
                    catch (PyException pye) {
                        if (pye.match(Py.TypeError)) {
                            throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", i));
                        }
                        throw pye;
                    }
                    int n = pair.__len__();
                    if (n != 2) {
                        throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", i, n));
                    }
                    if (!this.dict___contains__(pair.__getitem__(0))) {
                        this.dict___setitem__(pair.__getitem__(0), pair.__getitem__(1));
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public PyObject setdefault(PyObject key) {
        return this.dict_setdefault(key, Py.None);
    }

    @Override
    public PyObject setdefault(PyObject key, PyObject failobj) {
        return this.dict_setdefault(key, failobj);
    }

    final PyObject dict_setdefault(PyObject key, PyObject failobj) {
        PyObject oldValue = this.getMap().putIfAbsent(key, failobj);
        return oldValue == null ? failobj : oldValue;
    }

    final PyObject dict_setifabsent(PyObject key, PyObject failobj) {
        PyObject oldValue = this.getMap().putIfAbsent(key, failobj);
        return oldValue == null ? Py.None : oldValue;
    }

    @Override
    public PyObject pop(PyObject key) {
        return this.dict_pop(key, null);
    }

    @Override
    public PyObject pop(PyObject key, PyObject defaultValue) {
        return this.dict_pop(key, defaultValue);
    }

    final PyObject dict_pop(PyObject key, PyObject defaultValue) {
        if (!this.getMap().containsKey(key)) {
            if (defaultValue == null) {
                throw Py.KeyError(key);
            }
            return defaultValue;
        }
        return (PyObject)this.getMap().remove(key);
    }

    @Override
    public PyObject popitem() {
        return this.dict_popitem();
    }

    final PyObject dict_popitem() {
        Iterator it = this.getMap().entrySet().iterator();
        if (!it.hasNext()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        Map.Entry entry = it.next();
        PyTuple tuple = new PyTuple((PyObject)entry.getKey(), (PyObject)entry.getValue());
        it.remove();
        return tuple;
    }

    @Override
    public PyList items() {
        return this.dict_items();
    }

    final PyList dict_items() {
        ArrayList<PyObject> list = new ArrayList<PyObject>(this.getMap().size());
        for (Map.Entry entry : this.getMap().entrySet()) {
            list.add(new PyTuple((PyObject)entry.getKey(), (PyObject)entry.getValue()));
        }
        return PyList.fromList(list);
    }

    @Override
    public PyList keys() {
        return this.dict_keys();
    }

    final PyList dict_keys() {
        return PyList.fromList(new ArrayList<PyObject>(this.getMap().keySet()));
    }

    final PyList dict_values() {
        return PyList.fromList(new ArrayList<PyObject>(this.getMap().values()));
    }

    @Override
    public PyObject iteritems() {
        return this.dict_iteritems();
    }

    final PyObject dict_iteritems() {
        return new ItemsIter(this.getMap().entrySet());
    }

    @Override
    public PyObject iterkeys() {
        return this.dict_iterkeys();
    }

    final PyObject dict_iterkeys() {
        return new AbstractDict.ValuesIter(this.getMap().keySet());
    }

    @Override
    public PyObject itervalues() {
        return this.dict_itervalues();
    }

    final PyObject dict_itervalues() {
        return new AbstractDict.ValuesIter(this.getMap().values());
    }

    @Override
    public int hashCode() {
        return this.dict___hash__();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PyDictionary) {
            return ((PyDictionary)obj).getMap().equals(this.getMap());
        }
        if (obj instanceof Map) {
            return this.getMap().equals((Map)obj);
        }
        return false;
    }

    final int dict___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public boolean isMappingType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    public PyObject viewkeys() {
        return super.viewkeys();
    }

    @Override
    public PyObject viewitems() {
        return super.viewitems();
    }

    @Override
    public PyObject viewvalues() {
        return super.viewvalues();
    }

    @Override
    public Set<PyObject> pyKeySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Set entrySet() {
        return new PyMapEntrySet(this.getMap().entrySet());
    }

    @Override
    public Set keySet() {
        return new PyMapKeyValSet(this.getMap().keySet());
    }

    @Override
    public Collection values() {
        return new PyMapKeyValSet(this.getMap().values());
    }

    @Override
    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.getMap().put(Py.java2py(entry.getKey()), Py.java2py(entry.getValue()));
        }
    }

    @Override
    public Object remove(Object key) {
        return PyDictionary.tojava(this.getMap().remove(Py.java2py(key)));
    }

    @Override
    public Object put(Object key, Object value) {
        return PyDictionary.tojava(this.getMap().put(Py.java2py(key), Py.java2py(value)));
    }

    @Override
    public Object get(Object key) {
        return PyDictionary.tojava(this.getMap().get(Py.java2py(key)));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(Py.java2py(value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(Py.java2py(key));
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return PyDictionary.tojava(this.getMap().putIfAbsent(Py.java2py(key), Py.java2py(value)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.getMap().remove(Py.java2py(key), Py.java2py(value));
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.getMap().replace(Py.java2py(key), Py.java2py(oldValue), Py.java2py(newValue));
    }

    @Override
    public Object replace(Object key, Object value) {
        return PyDictionary.tojava(this.getMap().replace(Py.java2py(key), Py.java2py(value)));
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        for (Map.Entry ent : this.internalMap.entrySet()) {
            int retVal = visit.visit((PyObject)ent.getKey(), arg);
            if (retVal != 0) {
                return retVal;
            }
            if (ent.getValue() == null || (retVal = visit.visit((PyObject)ent.getValue(), arg)) == 0) continue;
            return retVal;
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.internalMap.containsKey(ob) || this.internalMap.containsValue(ob));
    }

    static {
        PyType.addBuilder(PyDictionary.class, new PyDictionary$PyExposer());
        TYPE = PyType.fromClass(PyDictionary.class);
    }

    @ExposedType(name="dict_items", base=PyObject.class)
    static class PyDictionaryViewItems
    extends BaseDictionaryView {
        public final PyType TYPE = PyType.fromClass(PyDictionaryViewItems.class);

        public PyDictionaryViewItems(AbstractDict dvDict) {
            super(dvDict);
        }

        @Override
        public PyObject __iter__() {
            return this.dict_items___iter__();
        }

        final PyObject dict_items___iter__() {
            return this.dvDict.iteritems();
        }

        final PyObject dict_items___ne__(PyObject otherObj) {
            return this.dict_view___ne__(otherObj);
        }

        final PyObject dict_items___eq__(PyObject otherObj) {
            return this.dict_view___eq__(otherObj);
        }

        final PyObject dict_items___lt__(PyObject otherObj) {
            return this.dict_view___lt__(otherObj);
        }

        final PyObject dict_items___gt__(PyObject otherObj) {
            return this.dict_view___gt__(otherObj);
        }

        final PyObject dict_items___ge__(PyObject otherObj) {
            return this.dict_view___ge__(otherObj);
        }

        final PyObject dict_items___le__(PyObject otherObj) {
            return this.dict_view___le__(otherObj);
        }

        @Override
        public PyObject __or__(PyObject otherObj) {
            return this.dict_items___or__(otherObj);
        }

        final PyObject dict_items___or__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict.iteritems());
            result2.set_update(new PyObject[]{otherObj}, new String[0]);
            return result2;
        }

        @Override
        public PyObject __xor__(PyObject otherObj) {
            return this.dict_items___xor__(otherObj);
        }

        final PyObject dict_items___xor__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict.iteritems());
            result2.set_symmetric_difference_update(otherObj);
            return result2;
        }

        @Override
        public PyObject __sub__(PyObject otherObj) {
            return this.dict_items___sub__(otherObj);
        }

        final PyObject dict_items___sub__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict.iteritems());
            result2.set_difference_update(new PyObject[]{otherObj}, new String[0]);
            return result2;
        }

        @Override
        public PyObject __and__(PyObject otherObj) {
            return this.dict_items___and__(otherObj);
        }

        final PyObject dict_items___and__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict.iteritems());
            result2.set_intersection_update(new PyObject[]{otherObj}, new String[0]);
            return result2;
        }

        @Override
        public boolean __contains__(PyObject otherObj) {
            return this.dict_items___contains__(otherObj);
        }

        final boolean dict_items___contains__(PyObject item) {
            PyTuple tupleItem;
            if (item instanceof PyTuple && (tupleItem = (PyTuple)item).size() == 2) {
                SimpleEntry entry = new SimpleEntry(tupleItem.get(0), tupleItem.get(1));
                return this.dvDict.entrySet().contains(entry);
            }
            return false;
        }

        final String dict_keys_toString() {
            return this.dict_view_toString();
        }

        static {
            PyType.addBuilder(PyDictionaryViewItems.class, new PyDictionary$PyDictionaryViewItems$PyExposer());
        }
    }

    @ExposedType(name="dict_keys", base=PyObject.class)
    static class PyDictionaryViewKeys
    extends BaseDictionaryView {
        public final PyType TYPE = PyType.fromClass(PyDictionaryViewKeys.class);

        public PyDictionaryViewKeys(AbstractDict dvDict) {
            super(dvDict);
        }

        @Override
        public PyObject __iter__() {
            return this.dict_keys___iter__();
        }

        final PyObject dict_keys___iter__() {
            return new AbstractDict.ValuesIter(this.dvDict.pyKeySet());
        }

        final PyObject dict_keys___ne__(PyObject otherObj) {
            return this.dict_view___ne__(otherObj);
        }

        final PyObject dict_keys___eq__(PyObject otherObj) {
            return this.dict_view___eq__(otherObj);
        }

        final PyObject dict_keys___lt__(PyObject otherObj) {
            return this.dict_view___lt__(otherObj);
        }

        final PyObject dict_keys___gt__(PyObject otherObj) {
            return this.dict_view___gt__(otherObj);
        }

        final PyObject dict_keys___ge__(PyObject otherObj) {
            return this.dict_view___ge__(otherObj);
        }

        final PyObject dict_keys___le__(PyObject otherObj) {
            return this.dict_view___le__(otherObj);
        }

        @Override
        public PyObject __or__(PyObject otherObj) {
            return this.dict_keys___or__(otherObj);
        }

        final PyObject dict_keys___or__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict);
            result2.set_update(new PyObject[]{otherObj}, new String[0]);
            return result2;
        }

        @Override
        public PyObject __xor__(PyObject otherObj) {
            return this.dict_keys___xor__(otherObj);
        }

        final PyObject dict_keys___xor__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict);
            result2.set_symmetric_difference_update(otherObj);
            return result2;
        }

        @Override
        public PyObject __sub__(PyObject otherObj) {
            return this.dict_keys___sub__(otherObj);
        }

        final PyObject dict_keys___sub__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict);
            result2.set_difference_update(new PyObject[]{otherObj}, new String[0]);
            return result2;
        }

        @Override
        public PyObject __and__(PyObject otherObj) {
            return this.dict_keys___and__(otherObj);
        }

        final PyObject dict_keys___and__(PyObject otherObj) {
            PySet result2 = new PySet(this.dvDict);
            result2.set_intersection_update(new PyObject[]{otherObj}, new String[0]);
            return result2;
        }

        @Override
        public boolean __contains__(PyObject otherObj) {
            return this.dict_keys___contains__(otherObj);
        }

        final boolean dict_keys___contains__(PyObject item) {
            return this.dvDict.__contains__(item);
        }

        final String dict_keys_toString() {
            return this.dict_view_toString();
        }

        static {
            PyType.addBuilder(PyDictionaryViewKeys.class, new PyDictionary$PyDictionaryViewKeys$PyExposer());
        }

        public class PyDictionary$PyDictionaryViewKeys$dict_keys___ge___exposer
        extends PyBuiltinMethodNarrow {
            public PyDictionary$PyDictionaryViewKeys$dict_keys___ge___exposer(String string2) {
                super(string2, 2, 2);
                this.doc = "x.__ge__(y) <==> x>=y";
            }

            public PyDictionary$PyDictionaryViewKeys$dict_keys___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "x.__ge__(y) <==> x>=y";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new PyDictionary$PyDictionaryViewKeys$dict_keys___ge___exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyDictionaryViewKeys)this.self).dict_keys___ge__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }

        public class PyDictionary$PyDictionaryViewKeys$dict_keys___le___exposer
        extends PyBuiltinMethodNarrow {
            public PyDictionary$PyDictionaryViewKeys$dict_keys___le___exposer(String string2) {
                super(string2, 2, 2);
                this.doc = "x.__le__(y) <==> x<=y";
            }

            public PyDictionary$PyDictionaryViewKeys$dict_keys___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "x.__le__(y) <==> x<=y";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new PyDictionary$PyDictionaryViewKeys$dict_keys___le___exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyDictionaryViewKeys)this.self).dict_keys___le__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }

        public class PyDictionary$PyDictionaryViewKeys$dict_keys___contains___exposer
        extends PyBuiltinMethodNarrow {
            public PyDictionary$PyDictionaryViewKeys$dict_keys___contains___exposer(String string2) {
                super(string2, 2, 2);
                this.doc = "x.__contains__(y) <==> y in x.";
            }

            public PyDictionary$PyDictionaryViewKeys$dict_keys___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "x.__contains__(y) <==> y in x.";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new PyDictionary$PyDictionaryViewKeys$dict_keys___contains___exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                return Py.newBoolean(((PyDictionaryViewKeys)this.self).dict_keys___contains__(pyObject));
            }
        }

        public class PyDictionary$PyDictionaryViewKeys$dict_keys_toString_exposer
        extends PyBuiltinMethodNarrow {
            public PyDictionary$PyDictionaryViewKeys$dict_keys_toString_exposer(String string2) {
                super(string2, 1, 1);
                this.doc = "x.__repr__() <==> repr(x)";
            }

            public PyDictionary$PyDictionaryViewKeys$dict_keys_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
                super(pyType, pyObject, info);
                this.doc = "x.__repr__() <==> repr(x)";
            }

            public PyBuiltinCallable bind(PyObject pyObject) {
                return new PyDictionary$PyDictionaryViewKeys$dict_keys_toString_exposer(this.getType(), pyObject, this.info);
            }

            public PyObject __call__() {
                String string2 = ((PyDictionaryViewKeys)this.self).dict_keys_toString();
                return string2 == null ? Py.None : Py.newString(string2);
            }
        }

        public class PyDictionary$PyDictionaryViewKeys$PyExposer
        extends BaseTypeBuilder {
            public PyDictionary$PyDictionaryViewKeys$PyExposer() {
                PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyDictionary$PyDictionaryViewKeys$dict_keys___iter___exposer("__iter__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___ne___exposer("__ne__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___eq___exposer("__eq__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___lt___exposer("__lt__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___gt___exposer("__gt__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___ge___exposer("__ge__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___le___exposer("__le__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___or___exposer("__or__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___xor___exposer("__xor__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___sub___exposer("__sub__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___and___exposer("__and__"), new PyDictionary$PyDictionaryViewKeys$dict_keys___contains___exposer("__contains__"), new PyDictionary$PyDictionaryViewKeys$dict_keys_toString_exposer("__repr__")};
                PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
                super("dict_keys", PyDictionaryViewKeys.class, PyObject.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, null);
            }
        }
    }

    @ExposedType(name="dict_values", base=PyObject.class, doc="")
    static class PyDictionaryViewValues
    extends BaseDictionaryView {
        public final PyType TYPE = PyType.fromClass(PyDictionaryViewValues.class);

        public PyDictionaryViewValues(AbstractDict dvDict) {
            super(dvDict);
        }

        @Override
        public PyObject __iter__() {
            return this.dict_values___iter__();
        }

        final PyObject dict_values___iter__() {
            return new AbstractDict.ValuesIter(this.dvDict.getMap().values());
        }

        final int dict_values___len__() {
            return this.dict_view___len__();
        }

        final String dict_values_toString() {
            return this.dict_view_toString();
        }

        static {
            PyType.addBuilder(PyDictionaryViewValues.class, new PyDictionary$PyDictionaryViewValues$PyExposer());
        }

        public class PyDictionary$PyDictionaryViewValues$PyExposer
        extends BaseTypeBuilder {
            public PyDictionary$PyDictionaryViewValues$PyExposer() {
                PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyDictionary$PyDictionaryViewValues$dict_values___iter___exposer("__iter__"), new PyDictionary$PyDictionaryViewValues$dict_values___len___exposer("__len__"), new PyDictionary$PyDictionaryViewValues$dict_values_toString_exposer("__repr__"), new PyDictionary$PyDictionaryViewValues$dict_values_toString_exposer("__str__")};
                PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
                super("dict_values", PyDictionaryViewValues.class, PyObject.class, true, "", pyBuiltinMethodArray, pyDataDescrArray, null);
            }
        }
    }

    class ItemsIter
    extends PyIterator {
        private final Iterator<Map.Entry<PyObject, PyObject>> iterator;
        private final int size;

        public ItemsIter(Set<Map.Entry<PyObject, PyObject>> items) {
            this.iterator = items.iterator();
            this.size = items.size();
        }

        @Override
        public PyObject __iternext__() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            Map.Entry<PyObject, PyObject> entry = this.iterator.next();
            return new PyTuple(entry.getKey(), entry.getValue());
        }
    }
}

