/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

public class IceCrypto {
    private int size;
    private int rounds;
    private int[][] keySchedule;
    private static int[][] spBox;
    private static boolean spBoxInitialised;
    private static final int[][] sMod;
    private static final int[][] sXor;
    private static final int[] pBox;
    private static final int[] keyrot;

    private int gf_mult(int a, int b, int m) {
        int res = 0;
        while (b != 0) {
            if ((b & 1) != 0) {
                res ^= a;
            }
            b >>>= 1;
            if ((a <<= 1) < 256) continue;
            a ^= m;
        }
        return res;
    }

    private int gf_exp7(int b, int m) {
        if (b == 0) {
            return 0;
        }
        int x = this.gf_mult(b, b, m);
        x = this.gf_mult(b, x, m);
        x = this.gf_mult(x, x, m);
        return this.gf_mult(b, x, m);
    }

    private int perm32(int x) {
        int res = 0;
        int i = 0;
        while (x != 0) {
            if ((x & 1) != 0) {
                res |= pBox[i];
            }
            ++i;
            x >>>= 1;
        }
        return res;
    }

    private void spBoxInit() {
        spBox = new int[4][1024];
        for (int i = 0; i < 1024; ++i) {
            int col = i >>> 1 & 0xFF;
            int row = i & 1 | (i & 0x200) >>> 8;
            int x = this.gf_exp7(col ^ sXor[0][row], sMod[0][row]) << 24;
            IceCrypto.spBox[0][i] = this.perm32(x);
            x = this.gf_exp7(col ^ sXor[1][row], sMod[1][row]) << 16;
            IceCrypto.spBox[1][i] = this.perm32(x);
            x = this.gf_exp7(col ^ sXor[2][row], sMod[2][row]) << 8;
            IceCrypto.spBox[2][i] = this.perm32(x);
            x = this.gf_exp7(col ^ sXor[3][row], sMod[3][row]);
            IceCrypto.spBox[3][i] = this.perm32(x);
        }
    }

    public IceCrypto(int level) {
        if (!spBoxInitialised) {
            this.spBoxInit();
            spBoxInitialised = true;
        }
        if (level < 1) {
            this.size = 1;
            this.rounds = 8;
        } else {
            this.size = level;
            this.rounds = level * 16;
        }
        this.keySchedule = new int[this.rounds][3];
    }

    private void scheduleBuild(int[] kb, int n, int krot_idx) {
        for (int i = 0; i < 8; ++i) {
            int j;
            int kr = keyrot[krot_idx + i];
            int[] subkey = this.keySchedule[n + i];
            for (j = 0; j < 3; ++j) {
                this.keySchedule[n + i][j] = 0;
            }
            for (j = 0; j < 15; ++j) {
                int curr_sk = j % 3;
                for (int k = 0; k < 4; ++k) {
                    int curr_kb = kb[kr + k & 3];
                    int bit = curr_kb & 1;
                    subkey[curr_sk] = subkey[curr_sk] << 1 | bit;
                    kb[kr + k & 3] = curr_kb >>> 1 | (bit ^ 1) << 15;
                }
            }
        }
    }

    public void set(byte[] key) {
        int[] kb = new int[4];
        if (this.rounds == 8) {
            for (int i = 0; i < 4; ++i) {
                kb[3 - i] = (key[i * 2] & 0xFF) << 8 | key[i * 2 + 1] & 0xFF;
            }
            this.scheduleBuild(kb, 0, 0);
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < 4; ++j) {
                kb[3 - j] = (key[i * 8 + j * 2] & 0xFF) << 8 | key[i * 8 + j * 2 + 1] & 0xFF;
            }
            this.scheduleBuild(kb, i * 8, 0);
            this.scheduleBuild(kb, this.rounds - 8 - i * 8, 8);
        }
    }

    public void clear() {
        for (int i = 0; i < this.rounds; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.keySchedule[i][j] = 0;
            }
        }
    }

    private int roundFunc(int p, int[] subkey) {
        int tl = p >>> 16 & 0x3FF | (p >>> 14 | p << 18) & 0xFFC00;
        int tr = p & 0x3FF | p << 2 & 0xFFC00;
        int al = subkey[2] & (tl ^ tr);
        int ar = al ^ tr;
        al ^= tl;
        return spBox[0][(al ^= subkey[0]) >>> 10] | spBox[1][al & 0x3FF] | spBox[2][(ar ^= subkey[1]) >>> 10] | spBox[3][ar & 0x3FF];
    }

    public void encryptBlock(byte[] plaintext, byte[] ciphertext) {
        int i;
        int l = 0;
        int r = 0;
        for (i = 0; i < 4; ++i) {
            l |= (plaintext[i] & 0xFF) << 24 - i * 8;
            r |= (plaintext[i + 4] & 0xFF) << 24 - i * 8;
        }
        for (i = 0; i < this.rounds; i += 2) {
            r ^= this.roundFunc(l ^= this.roundFunc(r, this.keySchedule[i]), this.keySchedule[i + 1]);
        }
        for (i = 0; i < 4; ++i) {
            ciphertext[3 - i] = (byte)(r & 0xFF);
            ciphertext[7 - i] = (byte)(l & 0xFF);
            r >>>= 8;
            l >>>= 8;
        }
    }

    public void decryptBlock(byte[] ciphertext, byte[] plaintext) {
        int i;
        int l = 0;
        int r = 0;
        for (i = 0; i < 4; ++i) {
            l |= (ciphertext[i] & 0xFF) << 24 - i * 8;
            r |= (ciphertext[i + 4] & 0xFF) << 24 - i * 8;
        }
        for (i = this.rounds - 1; i > 0; i -= 2) {
            r ^= this.roundFunc(l ^= this.roundFunc(r, this.keySchedule[i]), this.keySchedule[i - 1]);
        }
        for (i = 0; i < 4; ++i) {
            plaintext[3 - i] = (byte)(r & 0xFF);
            plaintext[7 - i] = (byte)(l & 0xFF);
            r >>>= 8;
            l >>>= 8;
        }
    }

    public int keySize() {
        return this.size * 8;
    }

    public int blockSize() {
        return 8;
    }

    private static void copyBytes(byte[] src, int srcStart, int length, byte[] dst, int dstStart) {
        int sp = srcStart;
        int dp = dstStart;
        for (int i = 0; i < length; ++i) {
            dst[dp++] = src[sp++];
        }
    }

    public static byte[] encrypt(byte[] in, byte[] key) {
        if (in.length == 0) {
            return new byte[0];
        }
        IceCrypto ice = new IceCrypto(1);
        ice.set(key);
        byte[] out = new byte[in.length % 8 == 0 ? in.length : in.length + (8 - in.length % 8)];
        byte[] plainText = new byte[8];
        byte[] encrypted = new byte[8];
        int stopPos = in.length - in.length % 8;
        for (int pos = 0; pos < stopPos; pos += 8) {
            IceCrypto.copyBytes(in, pos, 8, plainText, 0);
            ice.encryptBlock(plainText, encrypted);
            IceCrypto.copyBytes(encrypted, 0, 8, out, pos);
        }
        if (stopPos < in.length) {
            IceCrypto.copyBytes(in, stopPos, in.length - stopPos, plainText, 0);
            ice.encryptBlock(plainText, encrypted);
            IceCrypto.copyBytes(encrypted, 0, 8, out, stopPos);
        }
        return out;
    }

    public static byte[] decrypt(byte[] in, byte[] key) {
        byte[] out = new byte[in.length];
        if (in.length == 0) {
            return out;
        }
        IceCrypto ice = new IceCrypto(1);
        ice.set(key);
        byte[] plainText = new byte[8];
        byte[] encrypted = new byte[8];
        int stopPos = in.length - in.length % 8;
        for (int pos = 0; pos < stopPos; pos += 8) {
            IceCrypto.copyBytes(in, pos, 8, encrypted, 0);
            ice.decryptBlock(encrypted, plainText);
            IceCrypto.copyBytes(plainText, 0, 8, out, pos);
        }
        if (stopPos < in.length) {
            IceCrypto.copyBytes(in, stopPos, in.length - stopPos, encrypted, 0);
            ice.decryptBlock(encrypted, plainText);
            IceCrypto.copyBytes(plainText, 0, in.length - stopPos, out, stopPos);
        }
        return out;
    }

    static {
        spBoxInitialised = false;
        sMod = new int[][]{{333, 313, 505, 369}, {379, 375, 319, 391}, {361, 445, 451, 397}, {397, 425, 395, 505}};
        sXor = new int[][]{{131, 133, 155, 205}, {204, 167, 173, 65}, {75, 46, 212, 51}, {234, 203, 46, 4}};
        pBox = new int[]{1, 128, 1024, 8192, 524288, 0x200000, 0x1000000, 0x40000000, 8, 32, 256, 16384, 65536, 0x800000, 0x4000000, 0x20000000, 4, 16, 512, 32768, 131072, 0x400000, 0x8000000, 0x10000000, 2, 64, 2048, 4096, 262144, 0x100000, 0x2000000, Integer.MIN_VALUE};
        keyrot = new int[]{0, 1, 2, 3, 2, 1, 3, 0, 1, 3, 2, 0, 3, 1, 0, 2};
    }
}

