/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum AccessPointState {
    ADOPTED(0),
    UNADOPTED(1),
    DOWN(2),
    UNKNOWN(3);

    private int value;
    private static Map<Integer, AccessPointState> lookupTable;

    private AccessPointState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccessPointState getByValue(int value) {
        AccessPointState element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(AccessPointState.class.getName(), "Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, AccessPointState>();
        for (AccessPointState element : AccessPointState.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

