/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.Logger;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.LinkConfig;
import org.netxms.client.maps.configs.SingleDciConfig;

public class NetworkMapLink {
    public static final int NORMAL = 0;
    public static final int VPN = 1;
    public static final int MULTILINK = 2;
    public static final int ROUTING_DEFAULT = 0;
    public static final int ROUTING_DIRECT = 1;
    public static final int ROUTING_MANHATTAN = 2;
    public static final int ROUTING_BENDPOINTS = 3;
    private String name;
    private int type;
    private long element1;
    private long element2;
    private String connectorName1;
    private String connectorName2;
    private LinkConfig config = new LinkConfig();
    private int flags;

    public NetworkMapLink(String name, int type, long element1, long element2, String connectorName1, String connectorName2, SingleDciConfig[] dciList, int flags, boolean isLocked) {
        this.config.setDciList(dciList);
        this.config.setLocked(isLocked);
        this.initData(name, type, element1, element2, connectorName1, connectorName2, flags);
    }

    public NetworkMapLink(String name, int type, long element1, long element2, String connectorName1, String connectorName2, int flags) {
        this.initData(name, type, element1, element2, connectorName1, connectorName2, flags);
    }

    public void initData(String name, int type, long element1, long element2, String connectorName1, String connectorName2, int flags) {
        this.name = name;
        this.type = type;
        this.element1 = element1;
        this.element2 = element2;
        this.connectorName1 = connectorName1;
        this.connectorName2 = connectorName2;
        this.flags = flags;
    }

    public NetworkMapLink(int type, long element1, long element2) {
        this.name = "";
        this.type = type;
        this.element1 = element1;
        this.element2 = element2;
        this.connectorName1 = "";
        this.connectorName2 = "";
        this.flags = 0;
    }

    public NetworkMapLink(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId + 1L);
        this.type = msg.getFieldAsInt32(baseId);
        this.element1 = msg.getFieldAsInt64(baseId + 4L);
        this.element2 = msg.getFieldAsInt64(baseId + 5L);
        this.connectorName1 = msg.getFieldAsString(baseId + 2L);
        this.connectorName2 = msg.getFieldAsString(baseId + 3L);
        this.flags = msg.getFieldAsInt32(baseId + 7L);
        String xml = msg.getFieldAsString(baseId + 6L);
        try {
            this.config = xml != null && !xml.isEmpty() ? LinkConfig.createFromXml(xml) : new LinkConfig();
        }
        catch (Exception e) {
            Logger.warning("NetworkMapLink", "Cannot create data from XML (" + xml + ")", e);
            this.config = new LinkConfig();
        }
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        String xml = "";
        try {
            xml = this.config.createXml();
        }
        catch (Exception e) {
            Logger.warning("NetworkMapLink", "Cannot create XML from config (" + this.config.toString() + ")", e);
        }
        msg.setFieldInt16(baseId, this.type);
        msg.setField(baseId + 1L, this.name);
        msg.setField(baseId + 2L, this.connectorName1);
        msg.setField(baseId + 3L, this.connectorName2);
        msg.setFieldInt32(baseId + 4L, (int)this.element1);
        msg.setFieldInt32(baseId + 5L, (int)this.element2);
        msg.setField(baseId + 6L, xml);
        msg.setFieldInt32(baseId + 7L, this.flags);
    }

    public int getType() {
        return this.type;
    }

    public long getElement1() {
        return this.element1;
    }

    public long getElement2() {
        return this.element2;
    }

    public String getConnectorName1() {
        return this.connectorName1;
    }

    public String getConnectorName2() {
        return this.connectorName2;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (this.isUnnamed()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(this.name);
            sb.append(" (");
        }
        sb.append(this.connectorName1 != null && !this.connectorName1.isEmpty() ? this.connectorName1 : "<noname>");
        sb.append(" - ");
        sb.append(this.connectorName2 != null && !this.connectorName2.isEmpty() ? this.connectorName2 : "<noname>");
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasConnectorName1() {
        return this.connectorName1 != null && !this.connectorName1.isEmpty();
    }

    public boolean hasConnectorName2() {
        return this.connectorName2 != null && !this.connectorName2.isEmpty();
    }

    public boolean isUnnamed() {
        return !(this.name != null && !this.name.isEmpty() || this.connectorName1 != null && !this.connectorName1.isEmpty() || this.connectorName2 != null && !this.connectorName2.isEmpty());
    }

    public int getColor() {
        return this.config.getColor();
    }

    public void setColor(int color) {
        this.config.setColor(color);
    }

    public int getColorSource() {
        return this.config.getColorSource();
    }

    public void setColorSource(int colorSource) {
        this.config.setColorSource(colorSource);
    }

    public List<Long> getStatusObjects() {
        return this.config.getObjectStatusList();
    }

    public void setStatusObjects(List<Long> statusObjects) {
        this.config.setObjectStatusList(statusObjects != null ? statusObjects : new ArrayList(0));
    }

    public int getRouting() {
        return this.config.getRouting();
    }

    public void setRouting(int routing) {
        this.config.setRouting(routing);
    }

    public long[] getBendPoints() {
        return this.config.getBendPoints();
    }

    public void setBendPoints(long[] bendPoints) {
        this.config.setBendPoints(bendPoints);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean hasDciData() {
        SingleDciConfig[] dciList = this.config.getDciList();
        return dciList != null && dciList.length > 0;
    }

    public SingleDciConfig[] getDciList() {
        if (this.hasDciData()) {
            return this.config.getDciList();
        }
        return null;
    }

    public List<SingleDciConfig> getDciAsList() {
        ArrayList<SingleDciConfig> dciList = new ArrayList<SingleDciConfig>();
        if (this.hasDciData()) {
            for (SingleDciConfig dci : this.getDciList()) {
                dciList.add(new SingleDciConfig(dci));
            }
        }
        return dciList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConnectorName1(String connectorName1) {
        this.connectorName1 = connectorName1;
    }

    public void setConnectorName2(String connectorName2) {
        this.connectorName2 = connectorName2;
    }

    public LinkConfig getConfig() {
        return this.config;
    }

    public boolean isLocked() {
        return this.config.isLocked();
    }

    public void setLocked(boolean isLocked) {
        this.config.setLocked(isLocked);
    }

    public String toString() {
        return "NetworkMapLink [name=" + this.name + ", type=" + this.type + ", element1=" + this.element1 + ", element2=" + this.element2 + ", connectorName1=" + this.connectorName1 + ", connectorName2=" + this.connectorName2 + ", color=" + this.config.getColor() + ", statusObject=" + this.config.getObjectStatusList() + ", routing=" + this.config.getRouting() + ", flags=" + this.flags + "]";
    }
}

