/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.model;

import com.radensolutions.reporting.model.ReportParameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netxms.base.NXCPMessage;

public class ReportDefinition {
    private String name;
    private int numberOfColumns = 1;
    private Map<String, ReportParameter> parameters = new HashMap<String, ReportParameter>(0);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, ReportParameter> getParameters() {
        return this.parameters;
    }

    public void putParameter(ReportParameter parameter) {
        this.parameters.put(parameter.getName(), parameter);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns > 0 ? numberOfColumns : 1;
    }

    public void fillMessage(NXCPMessage message) {
        message.setField(20L, this.name);
        int size = this.parameters.size();
        message.setFieldInt32(111L, size);
        message.setFieldInt32(166L, this.numberOfColumns);
        Set<Map.Entry<String, ReportParameter>> entries = this.parameters.entrySet();
        long index = 0x30000000L;
        for (Map.Entry<String, ReportParameter> entry : entries) {
            ReportParameter parameter = entry.getValue();
            message.setFieldInt32(index++, parameter.getIndex());
            message.setField(index++, parameter.getName());
            message.setField(index++, parameter.getDescription());
            message.setField(index++, parameter.getType());
            message.setField(index++, parameter.getDefaultValue());
            message.setField(index++, parameter.getDependsOn());
            message.setFieldInt32(index++, parameter.getSpan());
            index += 3L;
        }
    }

    public String toString() {
        return "ReportDefinition{name='" + this.name + '\'' + ", numberOfColumns=" + this.numberOfColumns + ", parameters=" + this.parameters + '}';
    }
}

