/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.FillDatasetPosition;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.util.JRReportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FillDatasetRun
extends JRFillDatasetRun {
    private static final Log log = LogFactory.getLog(FillDatasetRun.class);
    private Map<String, Object> parameterValues;
    private FillDatasetPosition datasetPosition;
    private boolean cacheIncluded;
    private JRDataSource dataSource;
    private Connection connection;
    private boolean first;

    public FillDatasetRun(JRDatasetRun datasetRun, JRFillObjectFactory factory) throws JRException {
        super(factory.getReportFiller(), factory.getExpressionEvaluator(), datasetRun, FillDatasetRun.createFillDataset(datasetRun, factory));
        this.initReturnValues(factory);
        factory.registerDatasetRun(this);
    }

    public FillDatasetRun(FillDatasetRun datasetRun, JRFillCloneFactory factory) {
        super(datasetRun, factory);
    }

    private static JRFillDataset createFillDataset(JRDatasetRun datasetRun, JRFillObjectFactory factory) throws JRException {
        JasperReport jasperReport = factory.getReportFiller().getJasperReport();
        JRDataset reportDataset = JRReportUtils.findSubdataset(datasetRun, jasperReport);
        JRFillDataset fillDataset = new JRFillDataset(factory.getReportFiller(), reportDataset, factory);
        fillDataset.createCalculator(jasperReport);
        fillDataset.inheritFromMain();
        return fillDataset;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Evaluating list dataset run parameters");
        }
        this.saveReturnVariables();
        this.parameterValues = JRFillSubreport.getParameterValues(this.filler, this.expressionEvaluator, this.parametersMapExpression, this.parameters, evaluation, false, this.dataset.getResourceBundle() != null, false);
        JRFillDataset parentDataset = this.expressionEvaluator.getFillDataset();
        this.datasetPosition = new FillDatasetPosition(parentDataset.getDatasetPosition());
        this.datasetPosition.addAttribute("datasetRunUUID", this.getUUID());
        parentDataset.setCacheRecordIndex(this.datasetPosition, evaluation);
        String cacheIncludedProp = JRPropertiesUtil.getOwnProperty(this, "net.sf.jasperreports.data.cache.included");
        this.cacheIncluded = JRPropertiesUtil.asBoolean(cacheIncludedProp, true);
        if (this.dataSourceExpression != null) {
            this.dataSource = this.filler.getFillContext().hasDataSnapshot() && this.cacheIncluded ? null : (JRDataSource)this.expressionEvaluator.evaluate(this.dataSourceExpression, evaluation);
        } else if (this.connectionExpression != null) {
            this.connection = (Connection)this.expressionEvaluator.evaluate(this.connectionExpression, evaluation);
        }
    }

    public void start() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting list dataset iteration");
        }
        if (this.dataSourceExpression != null) {
            this.dataset.setDatasourceParameterValue(this.parameterValues, this.dataSource);
        } else if (this.connectionExpression != null) {
            this.dataset.setConnectionParameterValue(this.parameterValues, this.connection);
        }
        this.dataset.setFillPosition(this.datasetPosition);
        this.dataset.setCacheSkipped(!this.cacheIncluded);
        this.copyConnectionParameter(this.parameterValues);
        this.dataset.initCalculator();
        this.dataset.setParameterValues(this.parameterValues);
        this.dataset.evaluateFieldProperties();
        this.dataset.initDatasource();
        this.dataset.start();
        this.init();
        this.first = true;
    }

    public boolean next() throws JRException {
        this.checkInterrupted();
        if (this.dataset.next()) {
            if (this.first) {
                this.first = false;
            } else {
                this.group();
            }
            this.detail();
            return true;
        }
        return false;
    }

    public void end() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing the data source");
        }
        this.dataset.closeDatasource();
        this.dataset.disposeParameterContributors();
    }

    public void rewind() throws JRException {
        if (this.dataSource != null) {
            if (this.dataSource instanceof JRRewindableDataSource) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rewinding the list data source");
                }
                ((JRRewindableDataSource)this.dataSource).moveFirst();
            } else {
                log.warn((Object)"Cannot rewind list data source as it is not a JRRewindableDataSource");
            }
        }
    }

    public Object evaluateDatasetExpression(JRExpression expression, byte evaluationType) throws JRException {
        return this.dataset.evaluateExpression(expression, evaluationType);
    }

    @Override
    protected JRFillDataset getDataset() {
        return super.getDataset();
    }
}

