/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDataSniffer {
    private static final String SAX_EXCEPTION_MESSAGE_VALID_XML = "something unique";

    public static boolean isXmlData(byte[] data) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SaxHandler handler = new SaxHandler();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)bais, (DefaultHandler)handler);
            return true;
        }
        catch (ValidXmlSAXException e) {
            return true;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
    }

    private static class SaxHandler
    extends DefaultHandler {
        private SaxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            throw new ValidXmlSAXException();
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            throw new ValidXmlSAXException();
        }
    }

    private static class ValidXmlSAXException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        ValidXmlSAXException() {
            super(XmlDataSniffer.SAX_EXCEPTION_MESSAGE_VALID_XML);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

