/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.websvc.ObjectToolExecutor;
import org.netxms.websvc.ObjectToolOutputListener;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.handlers.ObjectToolOutputHandler;
import org.netxms.websvc.json.ResponseContainer;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;

public class ObjectTools
extends AbstractObjectHandler {
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        AbstractObject object = this.getObject();
        if (object.getObjectClass() != 2) {
            throw new NXCException(7);
        }
        List objectTools = session.getObjectTools();
        ArrayList<ObjectTool> result = new ArrayList<ObjectTool>();
        for (ObjectTool t : objectTools) {
            if (!t.isApplicableForNode((AbstractNode)object)) continue;
            result.add(t);
        }
        return new ResponseContainer("objectTools", result);
    }

    @Post
    public Representation onPost(Representation entity) throws Exception {
        if (entity == null || !this.attachToSession()) {
            return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
        }
        NXCSession session = this.getSession();
        AbstractObject object = this.getObject();
        if (object == null) {
            return new StringRepresentation((CharSequence)this.createErrorResponse(7).toString(), MediaType.APPLICATION_JSON);
        }
        JSONObject json = new JsonRepresentation(entity).getJsonObject();
        if (json.has("toolData")) {
            ObjectToolDetails details;
            JSONObject toolData = json.getJSONObject("toolData");
            HashMap<String, String> fields = new HashMap<String, String>();
            int id = toolData.getInt("id");
            if (toolData.optJSONArray("inputFields") != null) {
                JSONArray inputFields = toolData.getJSONArray("inputFields");
                for (int n = 0; n < inputFields.length(); ++n) {
                    String field = inputFields.getString(n);
                    String[] pair = field.split(";");
                    if (pair.length != 2) continue;
                    fields.put(pair[1], pair[0]);
                }
            }
            if (((details = session.getObjectToolDetails((long)id)).getFlags() & 2) != 0) {
                ObjectToolOutputListener listener = new ObjectToolOutputListener();
                UUID uuid = UUID.randomUUID();
                ObjectToolOutputHandler.addListener((UUID)uuid, (ObjectToolOutputListener)listener);
                new ObjectToolExecutor(details, object.getObjectId(), fields, listener, session);
                JSONObject response = new JSONObject();
                response.put("UUID", (Object)uuid);
                return new StringRepresentation((CharSequence)response.toString(), MediaType.APPLICATION_JSON);
            }
            return new StringRepresentation((CharSequence)this.createErrorResponse(0).toString(), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse(46).toString(), MediaType.APPLICATION_JSON);
    }
}

