/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.InetAddress;
import java.util.Date;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.websvc.json.JsonFilter;
import org.netxms.websvc.json.ResponseContainer;
import org.netxms.websvc.json.adapters.DateAdapter;
import org.netxms.websvc.json.adapters.InetAddressAdapter;
import org.netxms.websvc.json.adapters.InetAddressExAdapter;
import org.netxms.websvc.json.adapters.MacAddressAdapter;
import org.netxms.websvc.json.adapters.NXCSessionAdapter;

public class JsonTools {
    public static String jsonFromObject(Object object, Set<String> fields) {
        if (object instanceof JsonObject || object instanceof JsonArray || object instanceof JSONObject || object instanceof JSONArray) {
            return JsonFilter.createFilter((Object)object, fields).filter().toString();
        }
        if (object instanceof ResponseContainer) {
            return ((ResponseContainer)object).toJson(fields);
        }
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(Date.class, (Object)new DateAdapter());
        builder.registerTypeAdapter(InetAddress.class, (Object)new InetAddressAdapter());
        builder.registerTypeAdapter(InetAddressEx.class, (Object)new InetAddressExAdapter());
        builder.registerTypeAdapter(MacAddress.class, (Object)new MacAddressAdapter());
        builder.registerTypeAdapter(NXCSession.class, (Object)new NXCSessionAdapter());
        builder.setExclusionStrategies(new ExclusionStrategy[]{new /* Unavailable Anonymous Inner Class!! */});
        if (fields != null && !fields.isEmpty()) {
            return JsonFilter.createFilter((Object)builder.create().toJsonTree(object), fields).filter().toString();
        }
        return builder.create().toJson(object);
    }

    public static JsonObject objectFromJson(String json) {
        try {
            JsonParser parser = new JsonParser();
            return parser.parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    public static String getStringFromJson(JSONObject data, String key, String defaultValue) {
        String value = defaultValue;
        try {
            value = data.getString(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    public static int getIntFromJson(JSONObject data, String key, int defaultValue) {
        int value = defaultValue;
        try {
            value = data.getInt(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    public static long getLongFromJson(JSONObject data, String key, long defaultValue) {
        long value = defaultValue;
        try {
            value = data.getLong(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    public static <E extends Enum<E>> E getEnumFromJson(JSONObject data, Class<E> clazz, String key, E defaultValue) {
        Object value = defaultValue;
        try {
            value = data.getEnum(clazz, key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    public static JSONArray getJsonArrayFromJson(JSONObject data, String key, JSONArray defaultValue) {
        JSONArray value = defaultValue;
        try {
            value = data.getJSONArray(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    public static boolean getBooleanFromJson(JSONObject data, String key, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            value = data.getBoolean(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }
}

