/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.preferencepages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerFile;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.AlarmNotifier;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class AlarmSounds
extends PreferencePage
implements IWorkbenchPreferencePage {
    private NXCSession session;
    private ServerFile[] serverFiles = null;
    private IPreferenceStore ps;
    private URL workspaceUrl;
    private Set<String> soundList = new HashSet<String>();
    private List<String> currentSoundList = new ArrayList<String>();
    private Set<String> oldSoundList = new HashSet<String>();
    private List<String> newSoundList = new ArrayList<String>();
    private List<Combo> comboList = new ArrayList<Combo>();
    private List<Button> buttonList = new ArrayList<Button>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.session = ConsoleSharedData.getSession();
        this.ps = Activator.getDefault().getPreferenceStore();
        this.workspaceUrl = Platform.getInstanceLocation().getURL();
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Combo newCombo = null;
        Button button = null;
        int i = 0;
        while (i < 6) {
            String soundId = i < 5 ? StatusDisplayInfo.getStatusText((int)i) : "Outstanding alarm reminder";
            newCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)soundId, (Object)"WidgetHelper::default_layout_data");
            newCombo.setEnabled(false);
            this.comboList.add(i, newCombo);
            button = new Button(dialogArea, 8);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 3;
            button.setLayoutData((Object)gridData);
            button.setImage(Activator.getImageDescriptor("icons/sound.png").createImage());
            final int index = i;
            button.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    AlarmSounds.this.getMelodyAndDownloadIfRequired(((Combo)AlarmSounds.this.comboList.get(index)).getText());
                    try {
                        Clip sound = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
                        sound.open(AudioSystem.getAudioInputStream(new File(AlarmSounds.this.workspaceUrl.getPath(), ((Combo)AlarmSounds.this.comboList.get(index)).getText()).getAbsoluteFile()));
                        sound.start();
                        while (!sound.isRunning()) {
                            Thread.sleep(10L);
                        }
                        while (sound.isRunning()) {
                            Thread.sleep(10L);
                        }
                        sound.close();
                    }
                    catch (Exception ex) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = Display.getDefault().getActiveShell();
                                Messages.get();
                                Messages.get();
                                MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmNotifier_ErrorPlayingSound, (String)(String.valueOf(Messages.AlarmNotifier_ErrorPlayingSoundDescription) + ex.getMessage()));
                            }
                        });
                    }
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            this.buttonList.add(i, button);
            ++i;
        }
        Messages.get();
        new UIJob(Messages.AlarmMelody_JobGetMelodyList){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String[] s;
                try {
                    s = new String[]{"wav"};
                    AlarmSounds.this.serverFiles = AlarmSounds.this.session.listServerFiles(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AlarmSounds.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = AlarmSounds.this.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmMelody_ErrorGettingMelodyList, (String)(String.valueOf(Messages.AlarmMelody_ErrorGettingMelodyListDescription) + e.getMessage()));
                        }
                    });
                }
                ServerFile[] serverFileArray = AlarmSounds.this.serverFiles;
                int n = serverFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    s = serverFileArray[n2];
                    AlarmSounds.this.soundList.add(s.getName());
                    ++n2;
                }
                AlarmSounds.this.soundList.add("");
                int i = 0;
                while (i < 6) {
                    AlarmSounds.this.currentSoundList.add(i, AlarmSounds.this.ps.getString("ALARM_NOTIFIER.MELODY." + AlarmNotifier.SEVERITY_TEXT[i]));
                    ++i;
                }
                AlarmSounds.this.soundList.addAll(AlarmSounds.this.currentSoundList);
                Combo newCombo = null;
                int i2 = 0;
                while (i2 < 6) {
                    newCombo = (Combo)AlarmSounds.this.comboList.get(i2);
                    newCombo.setEnabled(true);
                    newCombo.setItems(AlarmSounds.this.soundList.toArray(new String[AlarmSounds.this.soundList.size()]));
                    newCombo.select(newCombo.indexOf((String)AlarmSounds.this.currentSoundList.get(i2)));
                    ++i2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return dialogArea;
    }

    private void getMelodyAndDownloadIfRequired(String melodyName) {
        block12: {
            URL workspaceUrl = Platform.getInstanceLocation().getURL();
            if (!AlarmSounds.isSoundFileExist(melodyName, workspaceUrl)) {
                try {
                    File fileContent = this.session.downloadFileFromServer(melodyName);
                    if (fileContent == null) break block12;
                    FileInputStream src = null;
                    FileOutputStream dest = null;
                    try {
                        try {
                            src = new FileInputStream(fileContent);
                            File f = new File(workspaceUrl.getPath(), melodyName);
                            f.createNewFile();
                            dest = new FileOutputStream(f);
                            FileChannel fcSrc = src.getChannel();
                            dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                        }
                        catch (IOException e) {
                            Activator.logError("Cannot copy sound file", e);
                            if (src != null) {
                                src.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                        }
                    }
                    finally {
                        if (src != null) {
                            src.close();
                        }
                        if (dest != null) {
                            dest.close();
                        }
                    }
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = Display.getDefault().getActiveShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmNotifier_ErrorMelodynotExists, (String)(String.valueOf(Messages.AlarmNotifier_ErrorMelodyNotExistsDescription) + e.getLocalizedMessage()));
                        }
                    });
                }
            }
        }
    }

    private static boolean isSoundFileExist(String melodyName, URL workspaceUrl) {
        if (!melodyName.isEmpty() && workspaceUrl != null) {
            File f = new File(workspaceUrl.getPath(), melodyName);
            return f.isFile();
        }
        return true;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        int i = 0;
        while (i < this.comboList.size()) {
            this.newSoundList.add(this.comboList.get(i).getText());
            ++i;
        }
        Messages.get();
        new UIJob(Messages.AlarmMelody_SaveClientSelection){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                int i = 0;
                while (i < AlarmSounds.this.newSoundList.size()) {
                    AlarmSounds.this.changeSound((String)AlarmSounds.this.newSoundList.get(i), AlarmNotifier.SEVERITY_TEXT[i], i);
                    ++i;
                }
                for (String oldName : AlarmSounds.this.oldSoundList) {
                    if (AlarmSounds.this.currentSoundList.contains(oldName)) continue;
                    File file = new File(AlarmSounds.this.workspaceUrl.getPath(), oldName);
                    file.delete();
                }
                if (isApply) {
                    AlarmSounds.this.setValid(true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void changeSound(String soundName, String severity, int id) {
        String oldSoundName = this.currentSoundList.get(id);
        if (!soundName.equals(oldSoundName)) {
            try {
                if (!AlarmSounds.checkMelodyExists(soundName, this.workspaceUrl)) {
                    AlarmSounds.downloadSoundFile(this.session, soundName, this.workspaceUrl);
                }
                this.ps.setValue("ALARM_NOTIFIER.MELODY." + severity, soundName);
                this.currentSoundList.set(id, soundName);
                this.oldSoundList.add(oldSoundName);
            }
            catch (Exception e) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = AlarmSounds.this.getShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmMelody_ErrorMelodyNotExists, (String)(String.valueOf(Messages.AlarmMelody_ErrorMelodyNotExistsDescription) + e.getMessage()));
                    }
                });
                this.ps.setValue("ALARM_NOTIFIER.MELODY." + severity, "");
            }
        }
    }

    private static boolean checkMelodyExists(String melodyName, URL workspaceUrl) {
        if (workspaceUrl != null && melodyName != null && !melodyName.equals("")) {
            File f = new File(workspaceUrl.getPath(), melodyName);
            return f.isFile();
        }
        return true;
    }

    private static void downloadSoundFile(NXCSession session, String melodyName, URL workspaceUrl) throws NXCException, IOException {
        File serverFile = session.downloadFileFromServer(melodyName);
        AbstractInterruptibleChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            try {
                src = new FileInputStream(serverFile).getChannel();
                File f = new File(workspaceUrl.getPath(), melodyName);
                f.createNewFile();
                dest = new FileOutputStream(f).getChannel();
                ((FileChannel)dest).transferFrom((ReadableByteChannel)((Object)src), 0L, ((FileChannel)src).size());
            }
            catch (IOException e) {
                Activator.logError("Cannot copy sound file", e);
                if (src != null) {
                    src.close();
                }
                if (dest != null) {
                    dest.close();
                }
            }
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (dest != null) {
                dest.close();
            }
        }
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

