/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.AlarmCategory;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.editors.AlarmCategoryEditor;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.AlarmCategoryLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmCategoryListComparator;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmCategoryListFilter;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AlarmCategoryList
extends Composite
implements SessionListener {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private boolean initShowfilter = true;
    private AlarmCategoryListFilter filter;
    private FilterText filterText;
    private Action actionShowFilter;
    private Action actionAddCategory;
    private Action actionEditCategory;
    private Action actionDeleteCategory;
    private NXCSession session = ConsoleSharedData.getSession();
    private IStructuredSelection selection;
    private SortableTableViewer viewer;
    private ViewPart viewPart;
    private HashMap<Long, AlarmCategory> alarmCategories;

    public AlarmCategoryList(ViewPart viewPart, Composite parent, int style, String configPrefix, boolean showFilter) {
        this(parent, style, configPrefix, showFilter);
        this.viewPart = viewPart;
    }

    public AlarmCategoryList(Composite parent, int style, final String configPrefix, boolean showCloseButton) {
        super(parent, style);
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.filterText = new FilterText((Composite)this, 0, null, showCloseButton);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AlarmCategoryList.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                AlarmCategoryList.this.enableFilter(false);
                AlarmCategoryList.this.actionShowFilter.setChecked(false);
            }
        });
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        String[] names = new String[]{"ID", "Name", "Description"};
        int[] widths = new int[]{50, 200, 200};
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 1, 128, 68354);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AlarmCategoryLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new AlarmCategoryListComparator());
        this.filter = new AlarmCategoryListFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)ds, (String)configPrefix);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                AlarmCategoryList.this.viewer.getControl().setBounds(AlarmCategoryList.this.getClientArea());
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)AlarmCategoryList.this.viewer, (IDialogSettings)ds, (String)configPrefix);
                ds.put(String.valueOf(configPrefix) + "initShowfilter", AlarmCategoryList.this.initShowfilter);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AlarmCategoryList.this.onSelectionChange();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.initShowfilter = AlarmCategoryList.safeCast(ds.get(String.valueOf(configPrefix) + "initShowfilter"), ds.getBoolean(String.valueOf(configPrefix) + "initShowfilter"), this.initShowfilter);
        if (this.initShowfilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.createActions();
        this.createPopupMenu();
        this.filterText.setCloseAction(this.actionShowFilter);
        this.refreshView();
        this.session.addListener((SessionListener)this);
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    private void onSelectionChange() {
        this.selection = (IStructuredSelection)this.getSelection();
        this.actionEditCategory.setEnabled(this.selection.size() == 1);
        this.actionDeleteCategory.setEnabled(this.selection.size() > 0);
    }

    public void refreshView() {
        new ConsoleJob("Open alarm category list", null, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = AlarmCategoryList.this.session.getAlarmCategories();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmCategoryList.this.alarmCategories = new HashMap(list.size());
                        for (AlarmCategory c : list) {
                            AlarmCategoryList.this.alarmCategories.put(c.getId(), c);
                        }
                        AlarmCategoryList.this.viewer.setInput((Object)AlarmCategoryList.this.alarmCategories.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot open alarm category list";
            }
        }.start();
    }

    public void enableFilter(boolean enable) {
        this.initShowfilter = enable;
        this.filterText.setVisible(this.initShowfilter);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isinitShowfilter() {
        return this.initShowfilter;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public String getFilterText() {
        return this.filterText.getText();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private void createActions() {
        this.actionAddCategory = new Action(){

            public void run() {
                AlarmCategoryList.this.createCategory();
            }
        };
        this.actionAddCategory.setText("Add category");
        this.actionAddCategory.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEditCategory = new Action(){

            public void run() {
                AlarmCategoryList.this.editCategory();
            }
        };
        this.actionEditCategory.setText("Edit category");
        this.actionEditCategory.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditCategory.setEnabled(false);
        this.actionDeleteCategory = new Action(){

            public void run() {
                AlarmCategoryList.this.deleteCategory();
            }
        };
        this.actionDeleteCategory.setText("Delete category");
        this.actionDeleteCategory.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionDeleteCategory.setEnabled(false);
        this.actionShowFilter = new Action(){

            public void run() {
                AlarmCategoryList.this.enableFilter(AlarmCategoryList.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setText("Show filter");
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowfilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.alarmviewer.commands.show_filter_alarm_category");
    }

    public void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AlarmCategoryList.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAddCategory);
        manager.add((IAction)this.actionDeleteCategory);
        manager.add((IAction)this.actionEditCategory);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
    }

    public void createCategory() {
        AlarmCategoryEditor editor = new AlarmCategoryEditor(new AlarmCategory());
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getShell(), null, (Object)editor);
        dlg.open();
    }

    public void editCategory() {
        if (this.selection.isEmpty()) {
            return;
        }
        AlarmCategoryEditor editor = new AlarmCategoryEditor((AlarmCategory)this.selection.getFirstElement());
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getShell(), null, (Object)editor);
        dlg.open();
    }

    private void deleteCategory() {
        String message;
        final IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        String string = message = selection.size() == 1 ? "Do you really wish to delete the selected category?" : "Do you really wish to delete the selected categories?";
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Confirm category deletion", (String)message)) {
            return;
        }
        new ConsoleJob("Delete alarm category database entries", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object o : selection.toList()) {
                    AlarmCategoryList.this.session.deleteAlarmCategory(((AlarmCategory)o).getId());
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete alarm category database entry";
            }
        }.start();
    }

    public Action getShowFilterAction() {
        return this.actionShowFilter;
    }

    public Action getAddCategoryAction() {
        return this.actionAddCategory;
    }

    public Action getEditCategoryAction() {
        return this.actionEditCategory;
    }

    public Action getDeleteCategoryAction() {
        return this.actionDeleteCategory;
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1030: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AlarmCategory oldCat = (AlarmCategory)AlarmCategoryList.this.alarmCategories.get(n.getSubCode());
                        if (oldCat != null) {
                            oldCat.setAll((AlarmCategory)n.getObject());
                            AlarmCategoryList.this.viewer.update((Object)oldCat, null);
                        } else {
                            AlarmCategoryList.this.alarmCategories.put(n.getSubCode(), (AlarmCategory)n.getObject());
                            AlarmCategoryList.this.viewer.setInput((Object)AlarmCategoryList.this.alarmCategories.values().toArray());
                        }
                    }
                });
                break;
            }
            case 1031: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AlarmCategoryList.this.alarmCategories.remove(n.getSubCode());
                        AlarmCategoryList.this.viewer.setInput((Object)AlarmCategoryList.this.alarmCategories.values().toArray());
                    }
                });
            }
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }
}

