/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateZoneDialog
extends Dialog {
    private LabeledText nameField;
    private LabeledText uinField;
    private String name;
    private long zoneUIN;

    public CreateZoneDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.CreateZoneDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.nameField.setLabel(Messages.CreateZoneDialog_Name);
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.uinField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.uinField.setLabel(Messages.CreateZoneDialog_ZoneId);
        this.uinField.getTextControl().setTextLimit(12);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.uinField.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        String zoneIdText = this.uinField.getText().trim();
        if (!zoneIdText.isEmpty()) {
            try {
                this.zoneUIN = Long.parseLong(this.uinField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.CreateZoneDialog_Warning, (String)Messages.CreateZoneDialog_WarningInvalidZoneId);
                return;
            }
            if (this.zoneUIN <= 0L) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.CreateZoneDialog_Warning, (String)Messages.CreateZoneDialog_WarningInvalidZoneId);
                return;
            }
        } else {
            this.zoneUIN = 0L;
        }
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.CreateZoneDialog_Warning, (String)Messages.CreateZoneDialog_WarningEmptyName);
            return;
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public long getZoneUIN() {
        return this.zoneUIN;
    }
}

