/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DashboardsDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public DashboardsDynamicMenu() {
    }

    public DashboardsDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void fill(Menu menu, int index) {
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        AbstractObject object = (AbstractObject)((IStructuredSelection)selection).getFirstElement();
        if (!(object instanceof Container || object instanceof Cluster || object instanceof Node || object instanceof MobileDevice || object instanceof ServiceRoot || object instanceof Subnet || object instanceof Zone || object instanceof Condition || object instanceof EntireNetwork)) {
            return;
        }
        List dashboards = object.getDashboards(true);
        if (dashboards.isEmpty()) {
            return;
        }
        Collections.sort(dashboards, new Comparator<AbstractObject>(){

            @Override
            public int compare(AbstractObject o1, AbstractObject o2) {
                return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
            }
        });
        Menu dashboardsMenu = new Menu(menu);
        for (AbstractObject d : dashboards) {
            final MenuItem item = new MenuItem(dashboardsMenu, 8);
            item.setText(d.getObjectName());
            item.setData((Object)d.getObjectId());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    try {
                        window.getActivePage().showView("org.netxms.ui.eclipse.dashboard.views.DashboardView", item.getData().toString(), 1);
                    }
                    catch (PartInitException ex) {
                        Shell shell = window.getShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openError((Shell)shell, (String)Messages.OpenDashboard_Error, (String)(String.valueOf(Messages.OpenDashboard_ErrorText) + ex.getMessage()));
                    }
                }
            });
        }
        MenuItem dashboardsMenuItem = new MenuItem(menu, 64, index);
        Messages.get();
        dashboardsMenuItem.setText(Messages.DashboardsDynamicMenu_Dashboards);
        dashboardsMenuItem.setMenu(dashboardsMenu);
    }
}

