/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.AgentTunnel;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TunnelListComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        AgentTunnel t1 = (AgentTunnel)e1;
        AgentTunnel t2 = (AgentTunnel)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 10: {
                result = t1.getAgentId().compareTo(t2.getAgentId());
                break;
            }
            case 9: {
                result = t1.getAgentVersion().compareToIgnoreCase(t2.getAgentVersion());
                break;
            }
            case 4: {
                result = t1.getActiveChannelCount() - t2.getActiveChannelCount();
                break;
            }
            case 0: {
                result = t1.getId() - t2.getId();
                break;
            }
            case 3: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)t1.getAddress(), (InetAddress)t2.getAddress());
                break;
            }
            case 2: {
                NXCSession session = ConsoleSharedData.getSession();
                result = session.getObjectName(t1.getNodeId()).compareToIgnoreCase(session.getObjectName(t2.getNodeId()));
                break;
            }
            case 7: {
                result = t1.getPlatformName().compareToIgnoreCase(t2.getPlatformName());
                break;
            }
            case 1: {
                result = (t1.isBound() ? 1 : 0) - (t2.isBound() ? 1 : 0);
                break;
            }
            case 8: {
                result = t1.getSystemInformation().compareToIgnoreCase(t2.getSystemInformation());
                break;
            }
            case 5: {
                result = t1.getSystemName().compareToIgnoreCase(t2.getSystemName());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

