/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerVariable;
import org.netxms.client.snmp.SnmpUsmCredential;

public class SnmpConfig {
    private List<String> communities;
    private List<SnmpUsmCredential> usmCredentials;
    private List<String> ports;

    private SnmpConfig() {
    }

    public static SnmpConfig load(NXCSession session) throws NXCException, IOException {
        SnmpConfig config = new SnmpConfig();
        config.communities = session.getSnmpCommunities();
        config.usmCredentials = session.getSnmpUsmCredentials();
        Map variables = session.getServerVariables();
        ServerVariable v = (ServerVariable)variables.get("SNMPPorts");
        config.ports = SnmpConfig.parsePorts(v != null ? v.getValue() : "");
        return config;
    }

    public static List<String> parsePorts(String portList) {
        String[] arr = portList.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr));
        return list;
    }

    public String parsePorts() {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < this.ports.size()) {
            str.append(this.ports.get(i));
            if (i != this.ports.size() - 1) {
                str.append(",");
            }
            ++i;
        }
        return str.toString();
    }

    public void save(NXCSession session) throws NXCException, IOException {
        session.updateSnmpCommunities(this.communities);
        session.updateSnmpUsmCredentials(this.usmCredentials);
        session.setServerVariable("SNMPPorts", this.parsePorts());
    }

    public List<String> getCommunities() {
        return this.communities;
    }

    public void setCommunities(List<String> communities) {
        this.communities = communities;
    }

    public List<String> getPorts() {
        return this.ports;
    }

    public void setPorts(List<String> ports) {
        this.ports = ports;
    }

    public List<SnmpUsmCredential> getUsmCredentials() {
        return this.usmCredentials;
    }

    public void setUsmCredentials(List<SnmpUsmCredential> usmCredentials) {
        this.usmCredentials = usmCredentials;
    }
}

