/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectListener;
import org.netxms.ui.eclipse.datacollection.dialogs.EditColumnDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.DCIPropertyPageDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.TableColumnLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class TableColumns
extends DCIPropertyPageDialog {
    private static final String COLUMN_SETTINGS_PREFIX = "TableColumns.ColumnList";
    private DataCollectionTable dci;
    private List<ColumnDefinition> columns;
    private TableViewer columnList;
    private Button queryButton;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsTable();
        this.editor.setCallback(new TableColumnDataProvider());
        this.columns = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition c : this.dci.getColumns()) {
            this.columns.add(new ColumnDefinition(c));
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Composite columnListArea = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        columnListArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        columnListArea.setLayout((Layout)layout);
        Label label = new Label(columnListArea, 0);
        Messages.get();
        label.setText(Messages.TableColumns_Columns);
        this.columnList = new TableViewer(columnListArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.columnList.getControl().setLayoutData((Object)gd);
        this.setupColumnList();
        this.columnList.setInput((Object)this.columns.toArray());
        Composite leftButtons = new Composite(columnListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.TableColumns_Up);
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.moveSelectionUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.TableColumns_Down);
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.moveSelectionDown();
            }
        });
        Composite buttons = new Composite(columnListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.queryButton = new Button(buttons, 8);
        this.queryButton.setText("&Query...");
        rd = new RowData();
        rd.width = 90;
        this.queryButton.setLayoutData((Object)rd);
        this.queryButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.queryColumns();
            }
        });
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.TableColumns_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.addColumn();
            }
        });
        this.modifyButton = new Button(buttons, 8);
        Messages.get();
        this.modifyButton.setText(Messages.TableColumns_Edit);
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.editColumn();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.TableColumns_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableColumns.this.deleteColumns();
            }
        });
        this.columnList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableColumns.this.deleteButton.setEnabled(selection.size() > 0);
                if (selection.size() == 1) {
                    TableColumns.this.modifyButton.setEnabled(true);
                    TableColumns.this.upButton.setEnabled(TableColumns.this.columns.indexOf(selection.getFirstElement()) > 0);
                    TableColumns.this.downButton.setEnabled(TableColumns.this.columns.indexOf(selection.getFirstElement()) < TableColumns.this.columns.size() - 1);
                } else {
                    TableColumns.this.modifyButton.setEnabled(false);
                    TableColumns.this.upButton.setEnabled(false);
                    TableColumns.this.downButton.setEnabled(false);
                }
            }
        });
        this.columnList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableColumns.this.editColumn();
            }
        });
        final DataCollectionObjectListener listener = new DataCollectionObjectListener(){

            @Override
            public void onSelectItem(int origin, String name, String description, int dataType) {
            }

            @Override
            public void onSelectTable(int origin, String name, String description) {
                if (origin == 1) {
                    TableColumns.this.updateColumnsFromAgent(name, false, null);
                }
            }
        };
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableColumns.this.editor.removeListener(listener);
            }
        });
        this.editor.addListener(listener);
        return dialogArea;
    }

    private void setupColumnList() {
        Table table = this.columnList.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableColumns_Name);
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableColumns_DisplayName);
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableColumns_Type);
        column.setWidth(80);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableColumns_Instance);
        column.setWidth(50);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableColumns_Aggregation);
        column.setWidth(80);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.TableColumns_OID);
        column.setWidth(200);
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
        this.columnList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.columnList.setLabelProvider((IBaseLabelProvider)new TableColumnLabelProvider());
    }

    private void deleteColumns() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.columns.remove(it.next());
            }
            this.columnList.setInput((Object)this.columns.toArray());
        }
    }

    private void editColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (selection.size() == 1) {
            ColumnDefinition column = (ColumnDefinition)selection.getFirstElement();
            EditColumnDialog dlg = new EditColumnDialog(this.getShell(), column);
            if (dlg.open() == 0) {
                this.columnList.update((Object)column, null);
            }
        }
    }

    private void addColumn() {
        Shell shell = this.getShell();
        Messages.get();
        Messages.get();
        InputDialog idlg = new InputDialog(shell, Messages.TableColumns_NewColumn, Messages.TableColumns_ColumnName, "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().isEmpty()) {
                    Messages.get();
                    return Messages.TableColumns_WarningText;
                }
                return null;
            }
        });
        if (idlg.open() == 0) {
            ColumnDefinition column = new ColumnDefinition(idlg.getValue(), idlg.getValue());
            EditColumnDialog dlg = new EditColumnDialog(this.getShell(), column);
            if (dlg.open() == 0) {
                this.columns.add(column);
                this.columnList.setInput((Object)this.columns.toArray());
                this.columnList.setSelection((ISelection)new StructuredSelection((Object)column));
            }
        }
    }

    private void moveSelectionUp() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ColumnDefinition column = (ColumnDefinition)selection.getFirstElement();
        int index = this.columns.indexOf(column);
        if (index > 0) {
            Collections.swap(this.columns, index, index - 1);
            this.columnList.setInput((Object)this.columns.toArray());
            this.columnList.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void moveSelectionDown() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ColumnDefinition column = (ColumnDefinition)selection.getFirstElement();
        int index = this.columns.indexOf(column);
        if (index < this.columns.size() - 1) {
            Collections.swap(this.columns, index, index + 1);
            this.columnList.setInput((Object)this.columns.toArray());
            this.columnList.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    protected void applyChanges(boolean isApply) {
        this.dci.getColumns().clear();
        this.dci.getColumns().addAll(this.columns);
        this.editor.modify();
    }

    protected void performApply() {
        this.saveSettings();
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.saveSettings();
        this.applyChanges(false);
        return true;
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.columnList.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
    }

    private void queryColumns() {
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Warning", (String)"Current column definition will be replaced by definition provided by agent. Continue?")) {
            return;
        }
        AbstractObject object = ConsoleSharedData.getSession().findObjectById(this.dci.getNodeId());
        if (this.editor.getSourceNode() == 0L && (object instanceof Template || object instanceof Cluster)) {
            ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
            if (dlg.open() != 0) {
                return;
            }
            object = (AbstractObject)dlg.getSelectedObjects().get(0);
        }
        this.updateColumnsFromAgent(this.dci.getName(), true, object);
    }

    private void updateColumnsFromAgent(final String name, final boolean interactive, final AbstractObject queryObject) {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.TableColumns_JobName, null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                block2: {
                    try {
                        final org.netxms.client.Table table = TableColumns.this.editor.getSourceNode() != 0L ? session.queryAgentTable(TableColumns.this.editor.getSourceNode(), name) : session.queryAgentTable(queryObject != null ? queryObject.getObjectId() : TableColumns.this.dci.getNodeId(), name);
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                TableColumns.this.columns.clear();
                                int i = 0;
                                while (i < table.getColumnCount()) {
                                    ColumnDefinition c = new ColumnDefinition(table.getColumnName(i), table.getColumnDisplayName(i));
                                    c.setDataType(table.getColumnDefinition(i).getDataType());
                                    c.setInstanceColumn(table.getColumnDefinition(i).isInstanceColumn());
                                    TableColumns.this.columns.add(c);
                                    ++i;
                                }
                                TableColumns.this.columnList.setInput((Object)TableColumns.this.columns.toArray());
                            }
                        });
                    }
                    catch (Exception e) {
                        Activator.logError("Cannot read table column definition from agent", e);
                        if (!interactive) break block2;
                        final String msg = e instanceof NXCException ? e.getLocalizedMessage() : "Internal error";
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialogHelper.openError((Shell)TableColumns.this.getShell(), (String)"Error", (String)String.format("Cannot read table column definition from agent (%s)", msg));
                            }
                        });
                    }
                }
            }

            protected String getErrorMessage() {
                return null;
            }
        };
        job.setUser(false);
        job.start();
    }

    public class TableColumnDataProvider {
        public List<String> getList() {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < TableColumns.this.columns.size()) {
                list.add(((ColumnDefinition)TableColumns.this.columns.get(i)).getName());
                ++i;
            }
            return list;
        }
    }
}

