/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ObjectUrlEditDialog
extends Dialog {
    private LabeledText textUrl;
    private LabeledText textDescription;
    private URL url;
    private String description;

    public ObjectUrlEditDialog(Shell parentShell, URL url, String description) {
        super(parentShell);
        this.url = url;
        this.description = description;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textUrl = new LabeledText(dialogArea, 0);
        this.textUrl.setLabel("URL");
        this.textUrl.getTextControl().setTextLimit(2000);
        if (this.url != null) {
            this.textUrl.setText(this.url.toExternalForm());
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textUrl.setLayoutData((Object)gd);
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel("Description");
        this.textDescription.getTextControl().setTextLimit(2000);
        if (this.description != null) {
            this.textDescription.setText(this.description);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        this.textDescription.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.url == null ? "Create URL" : "Edit URL");
    }

    public URL getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    protected void okPressed() {
        try {
            this.url = new URL(this.textUrl.getText().trim());
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Entered URL is invalid. Please enter valid URL.");
            return;
        }
        this.description = this.textDescription.getText();
        super.okPressed();
    }
}

