/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.AgentTunnel;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class TunnelManagerFilter
extends ViewerFilter {
    private String filterString = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AgentTunnel t = (AgentTunnel)element;
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        if (t.getAgentVersion().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.isBound() && Integer.toString(t.getActiveChannelCount()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (Integer.toString(t.getId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.getAddress().getHostAddress().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.isBound() && ConsoleSharedData.getSession().getObjectName(t.getNodeId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.getPlatformName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.isBound() ? "bound".contains(this.filterString) : "unbound".contains(this.filterString)) {
            return true;
        }
        if (t.getSystemInformation().toLowerCase().contains(this.filterString)) {
            return true;
        }
        return t.getSystemName().toLowerCase().contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

