/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.Py2kBuffer$buffer___add___exposer;
import org.python.core.Py2kBuffer$buffer___mul___exposer;
import org.python.core.Py2kBuffer$buffer___rmul___exposer;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.buffer.BaseBuffer;
import org.python.core.codecs;
import org.python.core.util.StringUtil;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="buffer", doc="buffer(object [, offset[, size]])\n\nCreate a new buffer object which references the given object.\nThe buffer will reference a slice of the target object from the\nstart of the object (or at the specified offset). The slice will\nextend to the end of the target object (or with the specified size).", base=PyObject.class, isBaseType=false)
public class Py2kBuffer
extends PySequence
implements BufferProtocol {
    public static final PyType TYPE;
    private final BufferProtocol object;
    private final int offset;
    private final int size;
    private static String[] paramNames;
    private static final String tobytes_doc = "M.tobytes() -> bytes\n\nReturn the data in the buffer as a bytestring (an object of class str).";
    private static final String tolist_doc = "M.tolist() -> list\n\nReturn the data in the buffer as a list of elements.";

    public Py2kBuffer(BufferProtocol object, int offset, int size) {
        super(TYPE);
        if (object instanceof Py2kBuffer) {
            Py2kBuffer source = (Py2kBuffer)object;
            offset = source.offset + offset;
            if (source.size >= 0) {
                int end = source.offset + source.size;
                if (size < 0 || offset + size > end) {
                    size = end - offset;
                }
            }
            object = source.object;
        }
        this.object = object;
        this.offset = offset;
        this.size = size;
    }

    private PyBuffer getBuffer() {
        boolean flags = false;
        PyBuffer buf = this.object.getBuffer(0);
        if (this.offset > 0 || this.size >= 0) {
            PyBuffer first = buf;
            int start = this.offset;
            int length = first.getLen() - start;
            if (length <= 0) {
                length = 0;
                start = 0;
            } else if (this.size >= 0 && this.size < length) {
                length = this.size;
            }
            buf = first.getBufferSlice(0, this.offset, length);
            first.release();
        }
        return buf;
    }

    private static BufferProtocol asBufferableOrNull(PyObject obj) {
        if (obj instanceof PyUnicode) {
            String bytes = codecs.encode((PyString)obj, "UTF-16BE", "replace");
            return new PyString(bytes);
        }
        if (obj instanceof BufferProtocol) {
            return (BufferProtocol)((Object)obj);
        }
        return null;
    }

    @ExposedNew
    static PyObject buffer_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("buffer", args, keywords, paramNames, 1);
        PyObject obj = ap.getPyObject(0);
        int offset = ap.getIndex(1, 0);
        int size = ap.getInt(2, -1);
        BufferProtocol object = Py2kBuffer.asBufferableOrNull(obj);
        if (object == null) {
            throw Py.TypeError("buffer object expected (or unicode)");
        }
        if (offset < 0) {
            throw Py.ValueError("offset must be zero or positive");
        }
        if (size < -1) {
            throw Py.ValueError("size must be zero or positive");
        }
        return new Py2kBuffer(object, offset, size);
    }

    @Override
    public int __len__() {
        PyBuffer buf = this.getBuffer();
        try {
            int n = buf.getLen();
            return n;
        }
        finally {
            buf.release();
        }
    }

    @Override
    public PyString __repr__() {
        String fmt = "<read-only buffer for %s, size %d, offset %d at 0x%s>";
        String ret = String.format(fmt, Py.idstr((PyObject)((Object)this.object)), this.size, this.offset, Py.idstr(this));
        return new PyString(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PyString __str__() {
        PyBuffer buf = this.getBuffer();
        try {
            if (buf instanceof BaseBuffer) {
                PyString pyString = new PyString(buf.toString());
                return pyString;
            }
            String s = StringUtil.fromBytes(buf);
            PyString pyString = new PyString(s);
            return pyString;
        }
        finally {
            buf.release();
        }
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.buffer___add__(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PyObject buffer___add__(PyObject other) {
        BufferProtocol bp = Py2kBuffer.asBufferableOrNull(other);
        if (bp == null) {
            return null;
        }
        PyBuffer buf = this.getBuffer();
        try {
            PyBuffer otherBuf = bp.getBuffer(0);
            try {
                PyString pyString = new PyString(buf.toString().concat(otherBuf.toString()));
                otherBuf.release();
                return pyString;
            }
            catch (Throwable throwable) {
                otherBuf.release();
                throw throwable;
            }
        }
        finally {
            buf.release();
        }
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.buffer___mul__(o);
    }

    final PyObject buffer___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.buffer___rmul__(o);
    }

    final PyObject buffer___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    private static int compare(PyBuffer a, PyBuffer b) {
        int ap = 0;
        int aEnd = ap + a.getLen();
        int bp = 0;
        int bEnd = b.getLen();
        while (ap < aEnd) {
            int bVal;
            int aVal;
            int diff;
            if (bp >= bEnd) {
                return 1;
            }
            if ((diff = (aVal = a.intAt(ap++)) - (bVal = b.intAt(bp++))) == 0) continue;
            return diff < 0 ? -1 : 1;
        }
        if (bp < bEnd) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buffer_cmp(PyObject b) {
        PyBuffer buf = this.getBuffer();
        try {
            PyBuffer bv;
            block10: {
                bv = BaseBytes.getView(b);
                if (bv == null) {
                    int n = -2;
                    return n;
                }
                try {
                    if (bv != buf) break block10;
                    int n = 0;
                    bv.release();
                    return n;
                }
                catch (Throwable throwable) {
                    bv.release();
                    throw throwable;
                }
            }
            int n = Py2kBuffer.compare(buf, bv);
            bv.release();
            return n;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buffer_cmpeq(PyObject b) {
        PyBuffer buf = this.getBuffer();
        try {
            PyBuffer bv;
            block13: {
                block12: {
                    bv = BaseBytes.getView(b);
                    if (bv == null) {
                        int n = -2;
                        return n;
                    }
                    try {
                        if (bv != buf) break block12;
                        int n = 0;
                        bv.release();
                        return n;
                    }
                    catch (Throwable throwable) {
                        bv.release();
                        throw throwable;
                    }
                }
                if (bv.getLen() == buf.getLen()) break block13;
                int n = 1;
                bv.release();
                return n;
            }
            int n = Py2kBuffer.compare(buf, bv);
            bv.release();
            return n;
        }
        finally {
            buf.release();
        }
    }

    @Override
    public PyBuffer getBuffer(int flags) {
        PyBuffer buf = this.object.getBuffer(flags);
        if (this.offset > 0 || this.size >= 0) {
            PyBuffer first = buf;
            int start = this.offset;
            int length = first.getLen() - start;
            if (length <= 0) {
                length = 0;
                start = 0;
            } else if (this.size >= 0 && this.size < length) {
                length = this.size;
            }
            buf = first.getBufferSlice(flags, this.offset, length);
            first.release();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PyString pyget(int index) {
        PyBuffer buf = this.getBuffer();
        try {
            PyString pyString = new PyString(String.valueOf((char)buf.intAt(index)));
            return pyString;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized PyString getslice(int start, int stop, int step) {
        PyBuffer buf = this.getBuffer();
        try {
            PyString ret;
            int n = Py2kBuffer.sliceLength(start, stop, step);
            PyBuffer first = buf;
            buf = first.getBufferSlice(284, start, n, step);
            first.release();
            PyString pyString = ret = Py.newString(buf.toString());
            return pyString;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized PyString repeat(int count2) {
        PyBuffer buf = this.getBuffer();
        try {
            PyString ret = Py.newString(buf.toString());
            PyString pyString = (PyString)ret.repeat(count2);
            return pyString;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pyset(int index, PyObject value) throws PyException {
        PyBuffer buf = this.getBuffer();
        try {
            PyBuffer valueBuf = BaseBytes.getViewOrError(value);
            try {
                if (valueBuf.getLen() != 1) {
                    throw Py.ValueError("cannot modify size of buffer object");
                }
                buf.storeAt(valueBuf.byteAt(0), index);
            }
            finally {
                valueBuf.release();
            }
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void setslice(int start, int stop, int step, PyObject value) {
        PyBuffer buf = this.getBuffer();
        try {
            if (step == 1 && stop < start) {
                stop = start;
            }
            PyBuffer valueBuf = BaseBytes.getViewOrError(value);
            PyBuffer bufSlice = null;
            try {
                int n = Py2kBuffer.sliceLength(start, stop, step);
                if (n != valueBuf.getLen()) {
                    throw Py.ValueError("cannot modify size of buffer object");
                }
                bufSlice = buf.getBufferSlice(284, start, n, step);
                bufSlice.copyFrom(valueBuf);
            }
            finally {
                if (bufSlice != null) {
                    bufSlice.release();
                }
                valueBuf.release();
            }
        }
        finally {
            buf.release();
        }
    }

    static {
        PyType.addBuilder(Py2kBuffer.class, new Py2kBuffer$PyExposer());
        TYPE = PyType.fromClass(Py2kBuffer.class);
        paramNames = new String[]{"object", "offset", "size"};
    }

    public class Py2kBuffer$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return Py2kBuffer.buffer_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class Py2kBuffer$PyExposer
    extends BaseTypeBuilder {
        public Py2kBuffer$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new Py2kBuffer$buffer___add___exposer("__add__"), new Py2kBuffer$buffer___mul___exposer("__mul__"), new Py2kBuffer$buffer___rmul___exposer("__rmul__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("buffer", Py2kBuffer.class, PyObject.class, false, "buffer(object [, offset[, size]])\n\nCreate a new buffer object which references the given object.\nThe buffer will reference a slice of the target object from the\nstart of the object (or at the specified offset). The slice will\nextend to the end of the target object (or with the specified size).", pyBuiltinMethodArray, pyDataDescrArray, new Py2kBuffer$exposed___new__());
        }
    }
}

