/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Collection;
import org.simpleframework.xml.core.CollectionFactory;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Traverser;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeList
implements Converter {
    private final CollectionFactory factory;
    private final Traverser root;
    private final String name;
    private final Type entry;
    private final Type type;

    public CompositeList(Context context, Type type, Type entry, String name) {
        this.factory = new CollectionFactory(context, type);
        this.root = new Traverser(context);
        this.entry = entry;
        this.type = type;
        this.name = name;
    }

    public Object read(InputNode node) throws Exception {
        Instance type = this.factory.getInstance(node);
        Object list = type.getInstance();
        if (!type.isReference()) {
            return this.populate(node, list);
        }
        return list;
    }

    public Object read(InputNode node, Object result2) throws Exception {
        Instance type = this.factory.getInstance(node);
        if (type.isReference()) {
            return type.getInstance();
        }
        type.setInstance(result2);
        if (result2 != null) {
            return this.populate(node, result2);
        }
        return result2;
    }

    private Object populate(InputNode node, Object result2) throws Exception {
        Collection list = (Collection)result2;
        while (true) {
            InputNode next = node.getNext();
            Class expect = this.entry.getType();
            if (next == null) {
                return list;
            }
            list.add(this.root.read(next, expect));
        }
    }

    public boolean validate(InputNode node) throws Exception {
        Instance value = this.factory.getInstance(node);
        if (!value.isReference()) {
            Object result2 = value.setInstance(null);
            Class type = value.getType();
            return this.validate(node, type);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        while (true) {
            InputNode next = node.getNext();
            Class expect = this.entry.getType();
            if (next == null) {
                return true;
            }
            this.root.validate(next, expect);
        }
    }

    public void write(OutputNode node, Object source) throws Exception {
        Collection list = (Collection)source;
        for (Object item : list) {
            Class<?> actual;
            if (item == null) continue;
            Class expect = this.entry.getType();
            if (!expect.isAssignableFrom(actual = item.getClass())) {
                throw new PersistenceException("Entry %s does not match %s for %s", actual, this.entry, this.type);
            }
            this.root.write(node, item, expect, this.name);
        }
    }
}

