/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;

public class TcpProxy {
    private NXCSession session;
    private int channelId;
    private PipedInputStream localInputStream;
    private PipedOutputStream remoteOutputStream;
    private ProxyOutputStream localOutputStream;
    private int timeThreshold = 100;
    private byte[] sendBuffer = new byte[256];
    private int pendingBytes = 0;
    private Timer sendTimer = new Timer(true);

    protected TcpProxy(NXCSession session, int channelId) throws IOException {
        this.session = session;
        this.channelId = channelId;
        this.localInputStream = new PipedInputStream();
        this.remoteOutputStream = new PipedOutputStream(this.localInputStream);
        this.localOutputStream = new ProxyOutputStream();
    }

    public void close() {
        if (this.session == null) {
            return;
        }
        this.session.closeTcpProxy(this.channelId);
        this.localClose();
    }

    protected void localClose() {
        this.sendTimer.cancel();
        this.session = null;
        try {
            this.localOutputStream.close();
            this.localInputStream.close();
            this.remoteOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localInputStream = null;
        this.localOutputStream = null;
        this.remoteOutputStream = null;
    }

    public boolean isClosed() {
        return this.session == null;
    }

    public InputStream getInputStream() {
        return this.localInputStream;
    }

    public OutputStream getOutputStream() {
        return this.localOutputStream;
    }

    protected int getChannelId() {
        return this.channelId;
    }

    public int getSizeThreshold() {
        return this.sendBuffer.length;
    }

    public int getTimeThreshold() {
        return this.timeThreshold;
    }

    public void setBufferingThresholds(int sizeThreshold, int timeThreshold) {
        this.sendBuffer = new byte[sizeThreshold];
        this.timeThreshold = timeThreshold;
    }

    public synchronized void send(byte[] data) throws IOException, NXCException {
        if (this.pendingBytes + data.length < this.sendBuffer.length) {
            TcpProxy.appendBytes(this.sendBuffer, this.pendingBytes, data, data.length);
            if (this.pendingBytes == 0) {
                this.sendTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        TcpProxy.this.flushSendBuffer();
                    }
                }, this.timeThreshold);
            }
            this.pendingBytes += data.length;
            return;
        }
        NXCPMessage msg = new NXCPMessage(365, this.channelId);
        msg.setBinaryMessage(true);
        if (this.pendingBytes > 0) {
            byte[] buffer;
            if (this.pendingBytes + data.length <= this.sendBuffer.length) {
                TcpProxy.appendBytes(this.sendBuffer, this.pendingBytes, data, data.length);
                buffer = this.sendBuffer;
            } else {
                buffer = new byte[this.pendingBytes + data.length];
                TcpProxy.appendBytes(buffer, 0, this.sendBuffer, this.pendingBytes);
                TcpProxy.appendBytes(buffer, this.pendingBytes, data, data.length);
            }
            msg.setBinaryData(buffer);
            this.pendingBytes = 0;
        } else {
            msg.setBinaryData(data);
        }
        this.session.sendMessage(msg);
    }

    private synchronized void flushSendBuffer() {
        if (this.pendingBytes == 0) {
            return;
        }
        NXCPMessage msg = new NXCPMessage(365, this.channelId);
        msg.setBinaryMessage(true);
        msg.setBinaryData(this.pendingBytes == this.sendBuffer.length ? this.sendBuffer : Arrays.copyOfRange(this.sendBuffer, 0, this.pendingBytes));
        try {
            this.session.sendMessage(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pendingBytes = 0;
    }

    protected void processRemoteData(byte[] data) {
        try {
            this.remoteOutputStream.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void appendBytes(byte[] target, int offset, byte[] source, int len) {
        int i = 0;
        int j = offset;
        while (i < len) {
            target[j] = source[i];
            ++i;
            ++j;
        }
    }

    private class ProxyOutputStream
    extends OutputStream {
        private ProxyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] data = new byte[]{(byte)b};
            this.write(data, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                if (off == 0 && len == b.length) {
                    TcpProxy.this.send(b);
                } else {
                    TcpProxy.this.send(Arrays.copyOfRange(b, off, len));
                }
            }
            catch (NXCException e) {
                throw new IOException(e);
            }
        }
    }
}

