/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.websvc.ObjectToolOutputListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectToolExecutor
extends Thread {
    private static String MULTIPLE_NODES = "<Multiple nodes>";
    private Logger log = LoggerFactory.getLogger(ObjectToolExecutor.class);
    private ObjectToolDetails details;
    private long objectId;
    private Map<String, String> inputFields;
    private ObjectToolOutputListener listener;
    private NXCSession session;

    public ObjectToolExecutor(ObjectToolDetails details, long objectId, Map<String, String> inputFields, ObjectToolOutputListener listener, NXCSession session) {
        this.details = details;
        this.objectId = objectId;
        this.inputFields = inputFields;
        this.listener = listener;
        this.session = session;
        this.setDaemon(true);
        this.start();
    }

    public ObjectToolExecutor(ObjectToolDetails details, long objectId, Map<String, String> inputFields, NXCSession session) {
        this.details = details;
        this.objectId = objectId;
        this.inputFields = inputFields;
        this.listener = null;
        this.session = session;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        switch (this.details.getToolType()) {
            case 1: {
                this.executeAgentAction();
            }
            case 6: {
                this.executeServerCommand();
            }
        }
    }

    private void executeAgentAction() {
        String[] parts = ObjectToolExecutor.splitCommandLine((String)this.substituteMacros(this.details.getData(), this.inputFields));
        String action = parts[0];
        String[] args = Arrays.copyOfRange(parts, 1, parts.length);
        if ((this.details.getFlags() & 2) == 0) {
            try {
                this.session.executeAction(this.objectId, action, args);
            }
            catch (Exception e) {
                this.log.error(e.getLocalizedMessage());
            }
        } else {
            try {
                this.session.executeAction(this.objectId, action, args, true, (TextOutputListener)this.listener, null);
            }
            catch (Exception e) {
                this.log.error(e.getLocalizedMessage());
            }
        }
    }

    private void executeServerCommand() {
        if ((this.details.getFlags() & 2) == 0) {
            try {
                this.session.executeServerCommand(this.objectId, this.details.getData(), this.inputFields);
            }
            catch (Exception e) {
                this.log.error(e.getLocalizedMessage());
            }
        } else {
            try {
                this.session.executeServerCommand(this.objectId, this.details.getData(), this.inputFields, true, (TextOutputListener)this.listener, null);
            }
            catch (Exception e) {
                this.log.error(e.getLocalizedMessage());
            }
            this.listener.onComplete();
        }
    }

    private String substituteMacros(String s, Map<String, String> inputValues) {
        AbstractNode object = (AbstractNode)this.session.findObjectById(this.objectId, AbstractNode.class);
        StringBuilder sb = new StringBuilder();
        char[] src = s.toCharArray();
        block13: for (int i = 0; i < s.length(); ++i) {
            if (src[i] == '%') {
                if (++i == s.length()) break;
                switch (src[i]) {
                    case 'a': {
                        sb.append(object != null ? object.getPrimaryIP().getHostAddress() : MULTIPLE_NODES);
                        break;
                    }
                    case 'g': {
                        sb.append(object != null ? object.getGuid().toString() : MULTIPLE_NODES);
                        break;
                    }
                    case 'i': {
                        sb.append(object != null ? String.format("0x%08X", object.getObjectId()) : MULTIPLE_NODES);
                        break;
                    }
                    case 'I': {
                        sb.append(object != null ? Long.toString(object.getObjectId()) : MULTIPLE_NODES);
                        break;
                    }
                    case 'n': {
                        sb.append(object != null ? object.getObjectName() : MULTIPLE_NODES);
                        break;
                    }
                    case 'N': {
                        break;
                    }
                    case 'U': {
                        sb.append(this.session.getUserName());
                        break;
                    }
                    case 'v': {
                        sb.append("2.2.13");
                        break;
                    }
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    case '{': {
                        String value;
                        StringBuilder attr = new StringBuilder();
                        ++i;
                        while (i < s.length() && src[i] != '}') {
                            attr.append(src[i]);
                            ++i;
                        }
                        if (object == null || attr.length() <= 0 || (value = (String)object.getCustomAttributes().get(attr.toString())) == null) continue block13;
                        sb.append(value);
                        break;
                    }
                    case '(': {
                        String value;
                        StringBuilder name = new StringBuilder();
                        ++i;
                        while (i < s.length() && src[i] != ')') {
                            name.append(src[i]);
                            ++i;
                        }
                        if (name.length() <= 0 || (value = inputValues.get(name.toString())) == null) continue block13;
                        sb.append(value);
                        break;
                    }
                }
                continue;
            }
            sb.append(src[i]);
        }
        return sb.toString();
    }

    private static String[] splitCommandLine(String input) {
        char[] in = input.toCharArray();
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int state = 0;
        block6: for (char c : in) {
            switch (state) {
                case 0: {
                    if (Character.isSpaceChar(c)) {
                        args.add(sb.toString());
                        sb = new StringBuilder();
                        state = 3;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 1;
                        continue block6;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case 1: {
                    if (c == '\"') {
                        state = 0;
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case 2: {
                    if (c == '\'') {
                        state = 0;
                        continue block6;
                    }
                    sb.append(c);
                    continue block6;
                }
                case 3: {
                    if (Character.isSpaceChar(c)) continue block6;
                    if (c == '\"') {
                        state = 1;
                        continue block6;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block6;
                    }
                    sb.append(c);
                    state = 0;
                }
            }
        }
        if (state != 3) {
            args.add(sb.toString());
        }
        return args.toArray(new String[args.size()]);
    }
}

