/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.Glob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.json.ResponseContainer;

public class Users
extends AbstractHandler {
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        if (!session.isUserDatabaseSynchronized()) {
            session.syncUserDatabase();
        }
        List<AbstractUserObject> objects = Arrays.asList(session.getUserDatabaseObjects());
        String typeFilter = query.get("type");
        String nameFilter = query.get("name");
        if (typeFilter != null || nameFilter != null) {
            ArrayList<AbstractUserObject> filteredObjects = new ArrayList<AbstractUserObject>(objects.size());
            for (AbstractUserObject o : objects) {
                if (nameFilter != null && !nameFilter.isEmpty() && !Glob.matchIgnoreCase((String)nameFilter, (String)o.getName()) || typeFilter != null && !typeFilter.isEmpty() && !typeFilter.equals("any") && (o instanceof User && !typeFilter.equals("user") || o instanceof UserGroup && !typeFilter.equals("group"))) continue;
                filteredObjects.add(o);
            }
            objects = filteredObjects;
        }
        return new ResponseContainer("users", objects);
    }

    protected Object get(String id, Map<String, String> query) throws Exception {
        AbstractUserObject object;
        NXCSession session = this.getSession();
        if (!session.isUserDatabaseSynchronized()) {
            session.syncUserDatabase();
        }
        if (id.equals("self")) {
            object = session.findUserDBObjectById((long)session.getUserId());
        } else {
            try {
                long objectId = Long.parseLong(id);
                object = session.findUserDBObjectById(objectId);
            }
            catch (NumberFormatException e) {
                UUID objectGuid = UUID.fromString(id);
                object = session.findUserDBObjectByGUID(objectGuid);
            }
        }
        if (object == null) {
            throw new NXCException(11);
        }
        return object;
    }
}

