/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.BulkAlarmStateChangeData;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AlarmReminderDialog;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class AlarmNotifier {
    public static final String[] SEVERITY_TEXT = new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL", "REMINDER"};
    private static SessionListener listener = null;
    private static Map<Long, Integer> alarmStates = new HashMap<Long, Integer>();
    private static int outstandingAlarms = 0;
    private static long lastReminderTime = 0L;
    private static NXCSession session;
    private static IPreferenceStore ps;
    private static URL workspaceUrl;
    private static LinkedBlockingQueue<String> soundQueue;
    private static AtomicInteger trayPopupCount;

    static {
        soundQueue = new LinkedBlockingQueue(4);
        trayPopupCount = new AtomicInteger(0);
    }

    public static void init(NXCSession session) {
        AlarmNotifier.session = session;
        ps = Activator.getDefault().getPreferenceStore();
        workspaceUrl = Platform.getInstanceLocation().getURL();
        AlarmNotifier.checkSounds();
        lastReminderTime = System.currentTimeMillis();
        try {
            HashMap alarms = session.getAlarms();
            for (Alarm a : alarms.values()) {
                alarmStates.put(a.getId(), a.getState());
                if (a.getState() != 0) continue;
                ++outstandingAlarms;
            }
            Activator.logInfo(String.format("Received %d alarms from server (%d outstanding)", alarms.size(), outstandingAlarms));
        }
        catch (Exception e) {
            Activator.logError("Exception while initialize alarm notifier", e);
        }
        listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                block7: {
                    block8: {
                        block6: {
                            if (n.getCode() != 1004 && n.getCode() != 1005) break block6;
                            AlarmNotifier.processNewAlarm((Alarm)n.getObject());
                            break block7;
                        }
                        if (n.getCode() != 1011 && n.getCode() != 1003) break block8;
                        Alarm a = (Alarm)n.getObject();
                        Integer state = (Integer)alarmStates.remove(a.getId());
                        if (state != 0) break block7;
                        outstandingAlarms = outstandingAlarms - 1;
                        break block7;
                    }
                    if (n.getCode() == 1033) {
                        BulkAlarmStateChangeData d = (BulkAlarmStateChangeData)n.getObject();
                        for (Long id : d.getAlarms()) {
                            Integer state = (Integer)alarmStates.get(id);
                            if (state == 0) {
                                outstandingAlarms = outstandingAlarms - 1;
                            }
                            alarmStates.put(id, 2);
                        }
                    } else if (n.getCode() == 1032) {
                        BulkAlarmStateChangeData d = (BulkAlarmStateChangeData)n.getObject();
                        for (Long id : d.getAlarms()) {
                            Integer state = (Integer)alarmStates.remove(id);
                            if (state != 0) continue;
                            outstandingAlarms = outstandingAlarms - 1;
                        }
                    }
                }
            }
        };
        session.addListener(listener);
        Thread reminderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
                    long currTime = System.currentTimeMillis();
                    if (!ps.getBoolean("OUTSTANDING_ALARMS_REMINDER") || outstandingAlarms <= 0 || lastReminderTime + 300000L > currTime) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            soundQueue.offer(SEVERITY_TEXT[SEVERITY_TEXT.length - 1]);
                            AlarmReminderDialog dlg = new AlarmReminderDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                            dlg.open();
                        }
                    });
                    lastReminderTime = currTime;
                }
            }
        }, "AlarmReminderThread");
        reminderThread.setDaemon(true);
        reminderThread.start();
        Thread playerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    String soundId;
                    try {
                        soundId = (String)soundQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    Line sound = null;
                    try {
                        try {
                            String fileName = AlarmNotifier.getSoundAndDownloadIfRequired(soundId);
                            if (fileName != null) {
                                sound = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
                                sound.open(AudioSystem.getAudioInputStream(new File(workspaceUrl.getPath(), fileName).getAbsoluteFile()));
                                sound.start();
                                while (!sound.isRunning()) {
                                    Thread.sleep(10L);
                                }
                                while (sound.isRunning()) {
                                    Thread.sleep(10L);
                                }
                            }
                        }
                        catch (Exception e) {
                            Activator.logError("Exception in alarm sound player", e);
                            if (sound == null || !sound.isOpen()) continue;
                            sound.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (sound != null && sound.isOpen()) {
                            sound.close();
                        }
                        throw throwable;
                    }
                    if (sound == null || !sound.isOpen()) continue;
                    sound.close();
                }
            }
        }, "AlarmSoundPlayer");
        playerThread.setDaemon(true);
        playerThread.start();
    }

    private static void checkSounds() {
        String[] stringArray = SEVERITY_TEXT;
        int n = SEVERITY_TEXT.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            AlarmNotifier.getSoundAndDownloadIfRequired(s);
            ++n2;
        }
    }

    private static String getSoundAndDownloadIfRequired(String severity) {
        String soundName;
        block14: {
            soundName = ps.getString("ALARM_NOTIFIER.MELODY." + severity);
            if (soundName.isEmpty()) {
                return null;
            }
            if (!AlarmNotifier.isSoundExist(soundName, workspaceUrl)) {
                try {
                    File fileContent = session.downloadFileFromServer(soundName);
                    if (fileContent != null) {
                        FileInputStream src = null;
                        FileOutputStream dest = null;
                        try {
                            try {
                                src = new FileInputStream(fileContent);
                                File f = new File(workspaceUrl.getPath(), soundName);
                                f.createNewFile();
                                dest = new FileOutputStream(f);
                                FileChannel fcSrc = src.getChannel();
                                dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                            }
                            catch (IOException e) {
                                Activator.logError("Cannot copy sound file", e);
                                if (src != null) {
                                    src.close();
                                }
                                if (dest != null) {
                                    dest.close();
                                }
                                break block14;
                            }
                        }
                        finally {
                            if (src != null) {
                                src.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                        }
                    }
                    Activator.logError("Cannot download sound file " + soundName + " from server");
                    soundName = null;
                }
                catch (Exception e) {
                    soundName = null;
                    ps.setValue("ALARM_NOTIFIER.MELODY." + severity, "");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = Display.getDefault().getActiveShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmNotifier_ErrorMelodynotExists, (String)(String.valueOf(Messages.AlarmNotifier_ErrorMelodyNotExistsDescription) + e.getLocalizedMessage()));
                        }
                    });
                }
            }
        }
        return soundName;
    }

    private static boolean isSoundExist(String name, URL workspaceUrl) {
        if (!name.isEmpty() && workspaceUrl != null) {
            File f = new File(workspaceUrl.getPath(), name);
            return f.isFile();
        }
        return true;
    }

    public static void stop() {
        NXCSession session = ConsoleSharedData.getSession();
        if (session != null && listener != null) {
            session.removeListener(listener);
        }
    }

    public static boolean isGlobalSoundEnabled() {
        return !ps.getBoolean("ALARM_NOTIFIER.SOUND.LOCAL");
    }

    public static void playSounOnAlarm(Alarm alarm) {
        try {
            soundQueue.offer(SEVERITY_TEXT[alarm.getCurrentSeverity().getValue()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Activator.logError("Invalid alarm severity", e);
        }
    }

    private static void processNewAlarm(final Alarm alarm) {
        Integer state = alarmStates.get(alarm.getId());
        if (state != null && state == 0) {
            --outstandingAlarms;
        }
        alarmStates.put(alarm.getId(), alarm.getState());
        if (alarm.getState() != 0) {
            return;
        }
        if (!ps.getBoolean("ALARM_NOTIFIER.SOUND.LOCAL")) {
            AlarmNotifier.playSounOnAlarm(alarm);
        }
        if (outstandingAlarms == 0) {
            lastReminderTime = System.currentTimeMillis();
        }
        ++outstandingAlarms;
        if (!Activator.getDefault().getPreferenceStore().getBoolean("SHOW_TRAY_POPUPS")) {
            return;
        }
        final TrayItem trayIcon = ConsoleSharedData.getTrayIcon();
        if (trayIcon != null) {
            if (trayPopupCount.incrementAndGet() < 2) {
                new UIJob("Create alarm popup"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IWorkbenchWindow[] wl;
                        AbstractObject object = session.findObjectById(alarm.getSourceObjectId());
                        int severityFlag = alarm.getCurrentSeverity() == Severity.NORMAL ? 2 : (alarm.getCurrentSeverity() == Severity.CRITICAL ? 1 : 8);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (wl = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                            window = wl[0];
                        }
                        if (window != null) {
                            ToolTip tip = new ToolTip(window.getShell(), 0x1000 | severityFlag);
                            Messages.get();
                            tip.setText(String.valueOf(Messages.AlarmNotifier_ToolTip_Header) + StatusDisplayInfo.getStatusText((Severity)alarm.getCurrentSeverity()) + ")");
                            tip.setMessage(String.valueOf(object != null ? object.getObjectName() : Long.toString(alarm.getSourceObjectId())) + ": " + alarm.getMessage());
                            tip.setAutoHide(true);
                            trayIcon.setToolTip(tip);
                            tip.setVisible(true);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            } else {
                trayPopupCount.decrementAndGet();
                Activator.logInfo("Skipping alarm tray popup creation - too many consecutive alarms");
            }
        }
    }
}

