/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectAgentParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectInternalParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectParameterScriptDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectSnmpParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.WinPerfCounterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.DCIPropertyPageDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class General
extends DCIPropertyPageDialog {
    private static final String[] snmpRawTypes;
    private DataCollectionItem dci;
    private Text description;
    private LabeledText parameter;
    private Button selectButton;
    private Combo origin;
    private Combo dataType;
    private Button checkInterpretRawSnmpValue;
    private Combo snmpRawType;
    private Button checkUseCustomSnmpPort;
    private Spinner customSnmpPort;
    private ObjectSelector sourceNode;
    private Combo agentCacheMode;
    private Combo schedulingMode;
    private Combo retentionMode;
    private LabeledSpinner pollingInterval;
    private LabeledSpinner retentionTime;
    private LabeledSpinner sampleCount;
    private Button statusActive;
    private Button statusDisabled;
    private Button statusUnsupported;

    static {
        String[] stringArray = new String[8];
        Messages.get();
        stringArray[0] = Messages.General_SNMP_DT_None;
        Messages.get();
        stringArray[1] = Messages.General_SNMP_DT_int32;
        Messages.get();
        stringArray[2] = Messages.General_SNMP_DT_uint32;
        Messages.get();
        stringArray[3] = Messages.General_SNMP_DT_int64;
        Messages.get();
        stringArray[4] = Messages.General_SNMP_DT_uint64;
        Messages.get();
        stringArray[5] = Messages.General_SNMP_DT_float;
        Messages.get();
        stringArray[6] = Messages.General_SNMP_DT_ipAddr;
        Messages.get();
        stringArray[7] = Messages.General_SNMP_DT_macAddr;
        snmpRawTypes = stringArray;
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group groupDescription = new Group(dialogArea, 0);
        Messages.get();
        groupDescription.setText(Messages.General_Description);
        FillLayout descriptionLayout = new FillLayout();
        descriptionLayout.marginWidth = 4;
        descriptionLayout.marginHeight = 4;
        groupDescription.setLayout((Layout)descriptionLayout);
        this.description = new Text((Composite)groupDescription, 2048);
        this.description.setTextLimit(255);
        this.description.setText(this.dci.getDescription());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupDescription.setLayoutData((Object)gd);
        Group groupData = new Group(dialogArea, 0);
        Messages.get();
        groupData.setText(Messages.General_Data);
        FormLayout dataLayout = new FormLayout();
        dataLayout.marginHeight = 4;
        dataLayout.marginWidth = 4;
        groupData.setLayout((Layout)dataLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupData.setLayoutData((Object)gd);
        this.parameter = new LabeledText((Composite)groupData, 0);
        Messages.get();
        this.parameter.setLabel(Messages.General_Parameter);
        this.parameter.getTextControl().setTextLimit(255);
        this.parameter.setText(this.dci.getName());
        this.selectButton = new Button((Composite)groupData, 8);
        Messages.get();
        this.selectButton.setText(Messages.General_Select);
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                General.this.selectParameter();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.selectButton, -2, 16384);
        this.parameter.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.parameter, 0, 1024);
        fd.width = 90;
        this.selectButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(50, -2);
        Messages.get();
        this.origin = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.General_Origin, (Object)fd);
        Messages.get();
        this.origin.add(Messages.General_SourceInternal);
        Messages.get();
        this.origin.add(Messages.General_SourceAgent);
        Messages.get();
        this.origin.add(Messages.General_SourceSNMP);
        Messages.get();
        this.origin.add(Messages.General_SourceCPSNMP);
        Messages.get();
        this.origin.add(Messages.General_SourcePush);
        Messages.get();
        this.origin.add(Messages.General_WinPerf);
        Messages.get();
        this.origin.add(Messages.General_SMCLP);
        Messages.get();
        this.origin.add(Messages.General_Script);
        Messages.get();
        this.origin.add(Messages.General_SourceSSH);
        Messages.get();
        this.origin.add(Messages.General_SourceMQTT);
        Messages.get();
        this.origin.add(Messages.General_SourceDeviceDriver);
        this.origin.select(this.dci.getOrigin());
        this.origin.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                General.this.onOriginChange();
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        Messages.get();
        this.dataType = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.General_DataType, (Object)fd);
        Messages.get();
        this.dataType.add(Messages.General_DT_int32);
        Messages.get();
        this.dataType.add(Messages.General_DT_uint32);
        Messages.get();
        this.dataType.add(Messages.General_DT_int64);
        Messages.get();
        this.dataType.add(Messages.General_DT_uint64);
        Messages.get();
        this.dataType.add(Messages.General_DT_string);
        Messages.get();
        this.dataType.add(Messages.General_DT_float);
        this.dataType.select(this.dci.getDataType());
        this.checkInterpretRawSnmpValue = new Button((Composite)groupData, 32);
        Messages.get();
        this.checkInterpretRawSnmpValue.setText(Messages.General_InterpretRawValue);
        this.checkInterpretRawSnmpValue.setSelection(this.dci.isSnmpRawValueInOctetString());
        this.checkInterpretRawSnmpValue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.snmpRawType.setEnabled(General.this.checkInterpretRawSnmpValue.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.origin.getParent(), 4, 1024);
        this.checkInterpretRawSnmpValue.setLayoutData((Object)fd);
        this.checkInterpretRawSnmpValue.setEnabled(this.dci.getOrigin() == 2);
        this.snmpRawType = new Combo((Composite)groupData, 2056);
        int i = 0;
        while (i < snmpRawTypes.length) {
            this.snmpRawType.add(snmpRawTypes[i]);
            ++i;
        }
        this.snmpRawType.select(this.dci.getSnmpRawValueType());
        this.snmpRawType.setEnabled(this.dci.getOrigin() == 2 && this.dci.isSnmpRawValueInOctetString());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 4, 1024);
        fd.right = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 0, 131072);
        this.snmpRawType.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort = new Button((Composite)groupData, 32);
        Messages.get();
        this.checkUseCustomSnmpPort.setText(Messages.General_UseCustomPort);
        this.checkUseCustomSnmpPort.setSelection(this.dci.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.customSnmpPort.setEnabled(General.this.checkUseCustomSnmpPort.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 4, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.dataType.getParent(), 4, 1024);
        this.checkUseCustomSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort.setEnabled(this.dci.getOrigin() == 2);
        this.customSnmpPort = new Spinner((Composite)groupData, 2048);
        this.customSnmpPort.setMinimum(1);
        this.customSnmpPort.setMaximum(65535);
        if (this.dci.getOrigin() == 2 && this.dci.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setSelection(this.dci.getSnmpPort());
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkInterpretRawSnmpValue, 4, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 1024);
        this.customSnmpPort.setLayoutData((Object)fd);
        this.sampleCount = new LabeledSpinner((Composite)groupData, 0);
        Messages.get();
        this.sampleCount.setLabel(Messages.General_SampleCountForAvg);
        this.sampleCount.setRange(0, 65535);
        this.sampleCount.setSelection(this.dci.getSampleCount());
        this.sampleCount.setEnabled(this.dci.getOrigin() == 5);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpRawType, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.sampleCount.setLayoutData((Object)fd);
        this.sourceNode = new ObjectSelector((Composite)groupData, 0, true);
        Messages.get();
        this.sourceNode.setLabel(Messages.General_ProxyNode);
        this.sourceNode.setObjectClass(Node.class);
        this.sourceNode.setObjectId(this.dci.getSourceNode());
        this.sourceNode.setEnabled(this.dci.getOrigin() != 4);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.sampleCount, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        Messages.get();
        this.agentCacheMode = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.General_AgentCacheMode, (Object)fd);
        Messages.get();
        this.agentCacheMode.add(Messages.General_Default);
        Messages.get();
        this.agentCacheMode.add(Messages.General_On);
        Messages.get();
        this.agentCacheMode.add(Messages.General_Off);
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.agentCacheMode.setEnabled(this.dci.getOrigin() == 1 || this.dci.getOrigin() == 2);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.sampleCount, 4, 1024);
        fd.right = new FormAttachment((Control)this.agentCacheMode.getParent(), -4, 16384);
        this.sourceNode.setLayoutData((Object)fd);
        Group groupPolling = new Group(dialogArea, 0);
        Messages.get();
        groupPolling.setText(Messages.General_Polling);
        FormLayout pollingLayout = new FormLayout();
        pollingLayout.marginHeight = 4;
        pollingLayout.marginWidth = 4;
        groupPolling.setLayout((Layout)pollingLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupPolling.setLayoutData((Object)gd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(50, -2);
        fd.top = new FormAttachment(0, 0);
        Messages.get();
        this.schedulingMode = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)Messages.General_PollingMode, (Object)fd);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsDefault);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsCustom);
        Messages.get();
        this.schedulingMode.add(Messages.General_CustomSchedule);
        this.schedulingMode.select(this.dci.isUseAdvancedSchedule() ? 2 : (this.dci.getPollingInterval() > 0 ? 1 : 0));
        this.schedulingMode.setEnabled(this.dci.getOrigin() != 4);
        this.schedulingMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                General.this.pollingInterval.setEnabled(General.this.schedulingMode.getSelectionIndex() == 1);
            }
        });
        this.pollingInterval = new LabeledSpinner((Composite)groupPolling, 0);
        Messages.get();
        this.pollingInterval.setLabel(Messages.General_PollingInterval);
        this.pollingInterval.setRange(1, 99999);
        this.pollingInterval.setSelection(this.dci.getPollingInterval() > 0 ? this.dci.getPollingInterval() : ConsoleSharedData.getSession().getDefaultDciPollingInterval());
        this.pollingInterval.setEnabled(!this.dci.isUseAdvancedSchedule() && this.dci.getPollingInterval() > 0 && this.dci.getOrigin() != 4);
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.pollingInterval.setLayoutData((Object)fd);
        Group groupStatus = new Group(dialogArea, 0);
        Messages.get();
        groupStatus.setText(Messages.General_Status);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupStatus.setLayoutData((Object)gd);
        RowLayout statusLayout = new RowLayout();
        statusLayout.type = 512;
        groupStatus.setLayout((Layout)statusLayout);
        this.statusActive = new Button((Composite)groupStatus, 16);
        Messages.get();
        this.statusActive.setText(Messages.General_Active);
        this.statusActive.setSelection(this.dci.getStatus() == 0);
        this.statusDisabled = new Button((Composite)groupStatus, 16);
        Messages.get();
        this.statusDisabled.setText(Messages.General_Disabled);
        this.statusDisabled.setSelection(this.dci.getStatus() == 1);
        this.statusUnsupported = new Button((Composite)groupStatus, 16);
        Messages.get();
        this.statusUnsupported.setText(Messages.General_NotSupported);
        this.statusUnsupported.setSelection(this.dci.getStatus() == 2);
        Group groupStorage = new Group(dialogArea, 0);
        Messages.get();
        groupStorage.setText(Messages.General_Storage);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        groupStorage.setLayoutData((Object)gd);
        GridLayout storageLayout = new GridLayout();
        storageLayout.numColumns = 2;
        storageLayout.horizontalSpacing = 4;
        groupStorage.setLayout((Layout)storageLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Messages.get();
        this.retentionMode = WidgetHelper.createLabeledCombo((Composite)groupStorage, (int)8, (String)Messages.General_RetentionMode, (Object)gd);
        Messages.get();
        this.retentionMode.add(Messages.General_UseDefaultRetention);
        Messages.get();
        this.retentionMode.add(Messages.General_UseCustomRetention);
        Messages.get();
        this.retentionMode.add(Messages.General_NoStorage);
        this.retentionMode.select((this.dci.getFlags() & 0x200) != 0 ? 2 : (this.dci.getRetentionTime() > 0 ? 1 : 0));
        this.retentionMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int mode = General.this.retentionMode.getSelectionIndex();
                General.this.retentionTime.setEnabled(mode == 1);
            }
        });
        this.retentionTime = new LabeledSpinner((Composite)groupStorage, 0);
        Messages.get();
        this.retentionTime.setLabel(Messages.General_RetentionTime);
        this.retentionTime.setRange(1, 99999);
        this.retentionTime.setSelection(this.dci.getRetentionTime() > 0 ? this.dci.getRetentionTime() : ConsoleSharedData.getSession().getDefaultDciRetentionTime());
        this.retentionTime.setEnabled((this.dci.getFlags() & 0x200) == 0 && this.dci.getRetentionTime() > 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.retentionTime.setLayoutData((Object)gd);
        int mode = 0;
        if ((this.dci.getFlags() & 0x200) != 0) {
            mode = 2;
        } else if (this.dci.getRetentionTime() > 0) {
            mode = 1;
        }
        this.retentionMode.select(mode);
        this.retentionTime.setEnabled(mode == 1);
        this.onOriginChange();
        return dialogArea;
    }

    private void onOriginChange() {
        int index = this.origin.getSelectionIndex();
        this.sourceNode.setEnabled(index != 4);
        this.schedulingMode.setEnabled(index != 4 && index != 9);
        this.pollingInterval.setEnabled(index != 4 && index != 9 && this.schedulingMode.getSelectionIndex() == 1);
        this.checkInterpretRawSnmpValue.setEnabled(index == 2);
        this.snmpRawType.setEnabled(index == 2 && this.checkInterpretRawSnmpValue.getSelection());
        this.checkUseCustomSnmpPort.setEnabled(index == 2);
        this.customSnmpPort.setEnabled(index == 2 && this.checkUseCustomSnmpPort.getSelection());
        this.sampleCount.setEnabled(index == 5);
        this.agentCacheMode.setEnabled(index == 1 || index == 2);
        this.selectButton.setEnabled(index == 1 || index == 2 || index == 0 || index == 5 || index == 3 || index == 10 || index == 7);
    }

    private void selectParameter() {
        IParameterSelectionDialog dlg;
        switch (this.origin.getSelectionIndex()) {
            case 0: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectInternalParamDlg(this.getShell(), this.sourceNode.getObjectId());
                    break;
                }
                dlg = new SelectInternalParamDlg(this.getShell(), this.dci.getNodeId());
                break;
            }
            case 1: 
            case 10: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectAgentParamDlg(this.getShell(), this.sourceNode.getObjectId(), this.origin.getSelectionIndex(), false);
                    break;
                }
                dlg = new SelectAgentParamDlg(this.getShell(), this.dci.getNodeId(), this.origin.getSelectionIndex(), false);
                break;
            }
            case 2: 
            case 3: {
                SnmpObjectId oid;
                try {
                    oid = SnmpObjectId.parseSnmpObjectId((String)this.parameter.getText());
                }
                catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
                    oid = null;
                }
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.sourceNode.getObjectId());
                    break;
                }
                dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.dci.getNodeId());
                break;
            }
            case 5: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new WinPerfCounterSelectionDialog(this.getShell(), this.sourceNode.getObjectId());
                    break;
                }
                dlg = new WinPerfCounterSelectionDialog(this.getShell(), this.dci.getNodeId());
                break;
            }
            case 7: {
                dlg = new SelectParameterScriptDialog(this.getShell());
                break;
            }
            default: {
                dlg = null;
            }
        }
        if (dlg != null && dlg.open() == 0) {
            IParameterSelectionDialog pd = dlg;
            this.description.setText(pd.getParameterDescription());
            this.parameter.setText(pd.getParameterName());
            this.dataType.select(pd.getParameterDataType());
            this.editor.fireOnSelectItemListeners(this.origin.getSelectionIndex(), pd.getParameterName(), pd.getParameterDescription(), pd.getParameterDataType());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setDescription(this.description.getText().trim());
        this.dci.setName(this.parameter.getText().trim());
        this.dci.setOrigin(this.origin.getSelectionIndex());
        this.dci.setDataType(this.dataType.getSelectionIndex());
        this.dci.setSampleCount(this.sampleCount.getSelection());
        this.dci.setSourceNode(this.sourceNode.getObjectId());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setUseAdvancedSchedule(this.schedulingMode.getSelectionIndex() == 2);
        this.dci.setPollingInterval(this.schedulingMode.getSelectionIndex() == 0 ? 0 : this.pollingInterval.getSelection());
        this.dci.setRetentionTime(this.retentionMode.getSelectionIndex() == 0 ? 0 : this.retentionTime.getSelection());
        this.dci.setSnmpRawValueInOctetString(this.checkInterpretRawSnmpValue.getSelection());
        this.dci.setSnmpRawValueType(this.snmpRawType.getSelectionIndex());
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dci.setSnmpPort(this.customSnmpPort.getSelection());
        } else {
            this.dci.setSnmpPort(0);
        }
        if (this.statusActive.getSelection()) {
            this.dci.setStatus(0);
        } else if (this.statusDisabled.getSelection()) {
            this.dci.setStatus(1);
        } else if (this.statusUnsupported.getSelection()) {
            this.dci.setStatus(2);
        }
        if (this.retentionMode.getSelectionIndex() == 2) {
            this.dci.setFlags(this.dci.getFlags() | 0x200);
        } else {
            this.dci.setFlags(this.dci.getFlags() & 0xFFFFFDFF);
        }
        this.editor.modify();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        NXCSession session = ConsoleSharedData.getSession();
        this.schedulingMode.select(0);
        this.pollingInterval.setSelection(session.getDefaultDciPollingInterval());
        this.statusActive.setSelection(true);
        this.statusDisabled.setSelection(false);
        this.statusUnsupported.setSelection(false);
        this.retentionTime.setSelection(session.getDefaultDciRetentionTime());
        this.checkInterpretRawSnmpValue.setSelection(false);
        this.checkUseCustomSnmpPort.setSelection(false);
        this.customSnmpPort.setSelection(161);
    }
}

