/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.dialogs.EditEventTemplateDialog;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateComparator;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateFilter;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class EventConfigurator
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.eventmanager.view.event_configurator";
    public static final String JOB_FAMILY = "EventConfiguratorJob";
    private static final String TABLE_CONFIG_PREFIX = "EventTemplateList";
    public static final int COLUMN_CODE = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_FLAGS = 3;
    public static final int COLUMN_MESSAGE = 4;
    public static final int COLUMN_DESCRIPTION = 5;
    private HashMap<Long, EventTemplate> eventTemplates;
    private SortableTableViewer viewer;
    private FilterText filterControl;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionShowFilter;
    private Action actionRefresh;
    private NXCSession session;
    private EventTemplateFilter filter;
    private boolean filterEnabled;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.filterEnabled = settings.getBoolean("EventConfigurator.filterEnabled");
    }

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FormLayout());
        this.filterControl = new FilterText(parent, 0);
        this.filterControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventConfigurator.this.onFilterModify();
            }
        });
        this.filterControl.setCloseAction(new Action(){

            public void run() {
                EventConfigurator.this.enableFilter(false);
            }
        });
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.EventConfigurator_ColCode;
        Messages.get();
        stringArray[1] = Messages.EventConfigurator_ColName;
        Messages.get();
        stringArray[2] = Messages.EventConfigurator_ColSeverity;
        Messages.get();
        stringArray[3] = Messages.EventConfigurator_ColFlags;
        Messages.get();
        stringArray[4] = Messages.EventConfigurator_ColMessage;
        Messages.get();
        stringArray[5] = Messages.EventConfigurator_ColDescription;
        String[] names = stringArray;
        int[] widths = new int[]{70, 200, 90, 50, 400, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EventTemplateLabelProvider());
        this.viewer.setComparator((ViewerComparator)new EventTemplateComparator());
        this.filter = new EventTemplateFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    EventConfigurator.this.actionEdit.setEnabled(selection.size() == 1);
                    EventConfigurator.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EventConfigurator.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)EventConfigurator.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)EventConfigurator.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterControl);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterControl.setLayoutData((Object)fd);
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refreshView();
        this.session.addListener((SessionListener)this);
        if (this.filterEnabled) {
            this.filterControl.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    private void refreshView() {
        Messages.get();
        new ConsoleJob(Messages.EventConfigurator_OpenJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.EventConfigurator_OpenJob_Error;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = EventConfigurator.this.session.getEventTemplates();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EventConfigurator.this.eventTemplates = new HashMap(list.size());
                        for (EventTemplate t : list) {
                            EventConfigurator.this.eventTemplates.put(t.getCode(), t);
                        }
                        EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                    }
                });
            }
        }.start();
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1013: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EventTemplate oldTmpl = (EventTemplate)EventConfigurator.this.eventTemplates.get(n.getSubCode());
                        if (oldTmpl != null) {
                            oldTmpl.setAll((EventTemplate)n.getObject());
                            EventConfigurator.this.viewer.update((Object)oldTmpl, null);
                        } else {
                            EventConfigurator.this.eventTemplates.put(n.getSubCode(), (EventTemplate)n.getObject());
                            EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                        }
                    }
                });
                break;
            }
            case 1014: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EventConfigurator.this.eventTemplates.remove(n.getSubCode());
                        EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                    }
                });
            }
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.eventmanager.contexts.EventConfigurator");
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                EventConfigurator.this.refreshView();
            }
        };
        Messages.get();
        this.actionNew = new Action(Messages.EventConfigurator_NewEvent, SharedIcons.ADD_OBJECT){

            public void run() {
                EventConfigurator.this.createNewEventTemplate();
            }
        };
        this.actionNew.setActionDefinitionId("org.netxms.ui.eclipse.eventmanager.commands.new_event_template");
        handlerService.activateHandler(this.actionNew.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionNew));
        Messages.get();
        this.actionEdit = new Action(Messages.EventConfigurator_Properties, SharedIcons.EDIT){

            public void run() {
                EventConfigurator.this.editEventTemplate();
            }
        };
        this.actionEdit.setEnabled(false);
        Messages.get();
        this.actionDelete = new Action(Messages.EventConfigurator_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                EventConfigurator.this.deleteEventTemplate();
            }
        };
        this.actionDelete.setEnabled(false);
        Messages.get();
        this.actionShowFilter = new Action(Messages.EventConfigurator_ShowFilter, 2){

            public void run() {
                EventConfigurator.this.enableFilter(EventConfigurator.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.eventmanager.commands.show_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EventConfigurator.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEdit);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void createNewEventTemplate() {
        final EventTemplate etmpl = new EventTemplate(0L);
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getSite().getShell(), etmpl, false);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.EventConfigurator_CreateJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.EventConfigurator_CreateJob_Error;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long code = EventConfigurator.this.session.generateEventCode();
                    etmpl.setCode(code);
                    EventConfigurator.this.session.modifyEventTemplate(etmpl);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            EventConfigurator.this.eventTemplates.put(etmpl.getCode(), etmpl);
                            EventConfigurator.this.viewer.setInput((Object)EventConfigurator.this.eventTemplates.values().toArray());
                            EventConfigurator.this.viewer.setSelection((ISelection)new StructuredSelection((Object)etmpl), true);
                        }
                    });
                }
            }.start();
        }
    }

    protected void editEventTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final EventTemplate etmpl = new EventTemplate((EventTemplate)selection.getFirstElement());
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getSite().getShell(), etmpl, false);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.EventConfigurator_UpdateJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.EventConfigurator_UpdateJob_Error;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    EventConfigurator.this.session.modifyEventTemplate(etmpl);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            EventConfigurator.this.eventTemplates.put(etmpl.getCode(), etmpl);
                            EventConfigurator.this.viewer.setInput(EventConfigurator.this.eventTemplates.values());
                            EventConfigurator.this.viewer.setSelection((ISelection)new StructuredSelection((Object)etmpl));
                        }
                    });
                }
            }.start();
        }
    }

    protected void deleteEventTemplate() {
        String string;
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() > 1) {
            Messages.get();
            string = Messages.EventConfigurator_DeleteConfirmation_Plural;
        } else {
            Messages.get();
            string = Messages.EventConfigurator_DeleteConfirmation_Singular;
        }
        String message = string;
        Shell shell = this.getViewSite().getShell();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.EventConfigurator_DeleteConfirmationTitle, (String)message)) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.EventConfigurator_DeleteJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.eventmanager", JOB_FAMILY){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.EventConfigurator_DeleteJob_Error;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    EventConfigurator.this.session.deleteEventTemplate(((EventTemplate)it.next()).getCode());
                }
            }
        }.start();
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterControl.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterControl) : new FormAttachment(0, 0);
        this.viewer.getControl().getParent().layout();
        if (enable) {
            this.filterControl.setFocus();
        } else {
            this.filterControl.setText("");
            this.onFilterModify();
        }
        this.actionShowFilter.setChecked(enable);
    }

    private void onFilterModify() {
        this.filter.setFilterText(this.filterControl.getText());
        this.viewer.refresh();
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("EventConfigurator.filterEnabled", this.filterEnabled);
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }
}

