/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum ObjectStatus {
    NORMAL(0),
    WARNING(1),
    MINOR(2),
    MAJOR(3),
    CRITICAL(4),
    UNKNOWN(5),
    UNMANAGED(6),
    DISABLED(7),
    TESTING(8);

    private int value;
    private static Map<Integer, ObjectStatus> lookupTable;

    static {
        lookupTable = new HashMap<Integer, ObjectStatus>();
        ObjectStatus[] objectStatusArray = ObjectStatus.values();
        int n = objectStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectStatus element = objectStatusArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private ObjectStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ObjectStatus getByValue(int value) {
        ObjectStatus element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)ObjectStatus.class.getName(), (String)("Unknown element " + value));
            return UNKNOWN;
        }
        return element;
    }
}

